<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OntologyValueType StructType
 * Meta information extracted from the WSDL
 * - documentation: Trip/ traveler value information with ontology reference.
 * @subpackage Structs
 */
class OntologyValueType extends AbstractStructBase
{
    /**
     * The Score
     * Meta information extracted from the WSDL
     * - base: xs:positiveInteger
     * - maxInclusive: 5
     * - minInclusive: 1
     * - use: required
     * @var int
     */
    public $Score;
    /**
     * The ScoreBasis
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\ScoreBasis[]
     */
    public $ScoreBasis;
    /**
     * The OntologyExtension
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: OntologyExtension
     * @var mixed
     */
    public $OntologyExtension;
    /**
     * Constructor method for OntologyValueType
     * @uses OntologyValueType::setScore()
     * @uses OntologyValueType::setScoreBasis()
     * @uses OntologyValueType::setOntologyExtension()
     * @param int $score
     * @param \StructType\ScoreBasis[] $scoreBasis
     * @param mixed $ontologyExtension
     */
    public function __construct($score = null, array $scoreBasis = array(), $ontologyExtension = null)
    {
        $this
            ->setScore($score)
            ->setScoreBasis($scoreBasis)
            ->setOntologyExtension($ontologyExtension);
    }
    /**
     * Get Score value
     * @return int
     */
    public function getScore()
    {
        return $this->Score;
    }
    /**
     * Set Score value
     * @param int $score
     * @return \StructType\OntologyValueType
     */
    public function setScore($score = null)
    {
        // validation for constraint: int
        if (!is_null($score) && !(is_int($score) || ctype_digit($score))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($score, true), gettype($score)), __LINE__);
        }
        // validation for constraint: maxInclusive(5)
        if (!is_null($score) && $score > 5) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 5', var_export($score, true)), __LINE__);
        }
        // validation for constraint: minInclusive(1)
        if (!is_null($score) && $score < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 1', var_export($score, true)), __LINE__);
        }
        $this->Score = $score;
        return $this;
    }
    /**
     * Get ScoreBasis value
     * @return \StructType\ScoreBasis[]|null
     */
    public function getScoreBasis()
    {
        return $this->ScoreBasis;
    }
    /**
     * This method is responsible for validating the values passed to the setScoreBasis method
     * This method is willingly generated in order to preserve the one-line inline validation within the setScoreBasis method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateScoreBasisForArrayConstraintsFromSetScoreBasis(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $ontologyValueTypeScoreBasisItem) {
            // validation for constraint: itemType
            if (!$ontologyValueTypeScoreBasisItem instanceof \StructType\ScoreBasis) {
                $invalidValues[] = is_object($ontologyValueTypeScoreBasisItem) ? get_class($ontologyValueTypeScoreBasisItem) : sprintf('%s(%s)', gettype($ontologyValueTypeScoreBasisItem), var_export($ontologyValueTypeScoreBasisItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ScoreBasis property can only contain items of type \StructType\ScoreBasis, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ScoreBasis value
     * @throws \InvalidArgumentException
     * @param \StructType\ScoreBasis[] $scoreBasis
     * @return \StructType\OntologyValueType
     */
    public function setScoreBasis(array $scoreBasis = array())
    {
        // validation for constraint: array
        if ('' !== ($scoreBasisArrayErrorMessage = self::validateScoreBasisForArrayConstraintsFromSetScoreBasis($scoreBasis))) {
            throw new \InvalidArgumentException($scoreBasisArrayErrorMessage, __LINE__);
        }
        $this->ScoreBasis = $scoreBasis;
        return $this;
    }
    /**
     * Add item to ScoreBasis value
     * @throws \InvalidArgumentException
     * @param \StructType\ScoreBasis $item
     * @return \StructType\OntologyValueType
     */
    public function addToScoreBasis(\StructType\ScoreBasis $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ScoreBasis) {
            throw new \InvalidArgumentException(sprintf('The ScoreBasis property can only contain items of type \StructType\ScoreBasis, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ScoreBasis[] = $item;
        return $this;
    }
    /**
     * Get OntologyExtension value
     * @return mixed|null
     */
    public function getOntologyExtension()
    {
        return $this->OntologyExtension;
    }
    /**
     * Set OntologyExtension value
     * @param mixed $ontologyExtension
     * @return \StructType\OntologyValueType
     */
    public function setOntologyExtension($ontologyExtension = null)
    {
        $this->OntologyExtension = $ontologyExtension;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\OntologyValueType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
