<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OntologyTimeDurationType StructType
 * Meta information extracted from the WSDL
 * - documentation: Start and end date/ time with ontology reference.
 * @subpackage Structs
 */
class OntologyTimeDurationType extends AbstractStructBase
{
    /**
     * The StartAndEnd
     * Meta information extracted from the WSDL
     * - choice: StartAndEnd | End
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * @var \StructType\StartAndEnd
     */
    public $StartAndEnd;
    /**
     * The End
     * Meta information extracted from the WSDL
     * - documentation: Example: 2013-01-13T23:37:00 | End date or date and time.
     * - choice: StartAndEnd | End
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * @var string
     */
    public $End;
    /**
     * The OntologyRefID
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - pattern: [0-9]{1,8}
     * - use: optional
     * @var string
     */
    public $OntologyRefID;
    /**
     * Constructor method for OntologyTimeDurationType
     * @uses OntologyTimeDurationType::setStartAndEnd()
     * @uses OntologyTimeDurationType::setEnd()
     * @uses OntologyTimeDurationType::setOntologyRefID()
     * @param \StructType\StartAndEnd $startAndEnd
     * @param string $end
     * @param string $ontologyRefID
     */
    public function __construct(\StructType\StartAndEnd $startAndEnd = null, $end = null, $ontologyRefID = null)
    {
        $this
            ->setStartAndEnd($startAndEnd)
            ->setEnd($end)
            ->setOntologyRefID($ontologyRefID);
    }
    /**
     * Get StartAndEnd value
     * @return \StructType\StartAndEnd|null
     */
    public function getStartAndEnd()
    {
        return isset($this->StartAndEnd) ? $this->StartAndEnd : null;
    }
    /**
     * This method is responsible for validating the value passed to the setStartAndEnd method
     * This method is willingly generated in order to preserve the one-line inline validation within the setStartAndEnd method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateStartAndEndForChoiceConstraintsFromSetStartAndEnd($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'End',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property StartAndEnd can\'t be set as the property %s is already set. Only one property must be set among these properties: StartAndEnd, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set StartAndEnd value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\StartAndEnd $startAndEnd
     * @return \StructType\OntologyTimeDurationType
     */
    public function setStartAndEnd(\StructType\StartAndEnd $startAndEnd = null)
    {
        // validation for constraint: choice(StartAndEnd, End)
        if ('' !== ($startAndEndChoiceErrorMessage = self::validateStartAndEndForChoiceConstraintsFromSetStartAndEnd($startAndEnd))) {
            throw new \InvalidArgumentException($startAndEndChoiceErrorMessage, __LINE__);
        }
        if (is_null($startAndEnd) || (is_array($startAndEnd) && empty($startAndEnd))) {
            unset($this->StartAndEnd);
        } else {
            $this->StartAndEnd = $startAndEnd;
        }
        return $this;
    }
    /**
     * Get End value
     * @return string|null
     */
    public function getEnd()
    {
        return isset($this->End) ? $this->End : null;
    }
    /**
     * This method is responsible for validating the value passed to the setEnd method
     * This method is willingly generated in order to preserve the one-line inline validation within the setEnd method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateEndForChoiceConstraintsFromSetEnd($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'StartAndEnd',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property End can\'t be set as the property %s is already set. Only one property must be set among these properties: End, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set End value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param string $end
     * @return \StructType\OntologyTimeDurationType
     */
    public function setEnd($end = null)
    {
        // validation for constraint: string
        if (!is_null($end) && !is_string($end)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($end, true), gettype($end)), __LINE__);
        }
        // validation for constraint: choice(StartAndEnd, End)
        if ('' !== ($endChoiceErrorMessage = self::validateEndForChoiceConstraintsFromSetEnd($end))) {
            throw new \InvalidArgumentException($endChoiceErrorMessage, __LINE__);
        }
        if (is_null($end) || (is_array($end) && empty($end))) {
            unset($this->End);
        } else {
            $this->End = $end;
        }
        return $this;
    }
    /**
     * Get OntologyRefID value
     * @return string|null
     */
    public function getOntologyRefID()
    {
        return $this->OntologyRefID;
    }
    /**
     * Set OntologyRefID value
     * @param string $ontologyRefID
     * @return \StructType\OntologyTimeDurationType
     */
    public function setOntologyRefID($ontologyRefID = null)
    {
        // validation for constraint: string
        if (!is_null($ontologyRefID) && !is_string($ontologyRefID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ontologyRefID, true), gettype($ontologyRefID)), __LINE__);
        }
        // validation for constraint: pattern([0-9]{1,8})
        if (!is_null($ontologyRefID) && !preg_match('/[0-9]{1,8}/', $ontologyRefID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9]{1,8}', var_export($ontologyRefID, true)), __LINE__);
        }
        $this->OntologyRefID = $ontologyRefID;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\OntologyTimeDurationType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
