<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OntologyPricingMethodType StructType
 * Meta information extracted from the WSDL
 * - documentation: Pricing method with ontology reference.
 * @subpackage Structs
 */
class OntologyPricingMethodType extends \EnumType\List_OfferPricingType
{
    /**
     * The InclusiveInd
     * Meta information extracted from the WSDL
     * - documentation: Implementer: If true, the offer pricing should include all associated fees and taxes. | Example: true | Inclusive pricing indicator.
     * - use: optional
     * @var bool
     */
    public $InclusiveInd;
    /**
     * The ApproximateInd
     * Meta information extracted from the WSDL
     * - documentation: Implementer: If true, the returned offer pricing is approximate. | Example: true | Approximate pricing indicator.
     * - use: optional
     * @var bool
     */
    public $ApproximateInd;
    /**
     * The OtherType
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - pattern: [a-zA-Z0-9]{1,64}
     * - use: optional
     * @var string
     */
    public $OtherType;
    /**
     * The OntologyRefID
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - pattern: [0-9]{1,8}
     * - use: optional
     * @var string
     */
    public $OntologyRefID;
    /**
     * Constructor method for OntologyPricingMethodType
     * @uses OntologyPricingMethodType::setInclusiveInd()
     * @uses OntologyPricingMethodType::setApproximateInd()
     * @uses OntologyPricingMethodType::setOtherType()
     * @uses OntologyPricingMethodType::setOntologyRefID()
     * @param bool $inclusiveInd
     * @param bool $approximateInd
     * @param string $otherType
     * @param string $ontologyRefID
     */
    public function __construct($inclusiveInd = null, $approximateInd = null, $otherType = null, $ontologyRefID = null)
    {
        $this
            ->setInclusiveInd($inclusiveInd)
            ->setApproximateInd($approximateInd)
            ->setOtherType($otherType)
            ->setOntologyRefID($ontologyRefID);
    }
    /**
     * Get InclusiveInd value
     * @return bool|null
     */
    public function getInclusiveInd()
    {
        return $this->InclusiveInd;
    }
    /**
     * Set InclusiveInd value
     * @param bool $inclusiveInd
     * @return \StructType\OntologyPricingMethodType
     */
    public function setInclusiveInd($inclusiveInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($inclusiveInd) && !is_bool($inclusiveInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($inclusiveInd, true), gettype($inclusiveInd)), __LINE__);
        }
        $this->InclusiveInd = $inclusiveInd;
        return $this;
    }
    /**
     * Get ApproximateInd value
     * @return bool|null
     */
    public function getApproximateInd()
    {
        return $this->ApproximateInd;
    }
    /**
     * Set ApproximateInd value
     * @param bool $approximateInd
     * @return \StructType\OntologyPricingMethodType
     */
    public function setApproximateInd($approximateInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($approximateInd) && !is_bool($approximateInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($approximateInd, true), gettype($approximateInd)), __LINE__);
        }
        $this->ApproximateInd = $approximateInd;
        return $this;
    }
    /**
     * Get OtherType value
     * @return string|null
     */
    public function getOtherType()
    {
        return $this->OtherType;
    }
    /**
     * Set OtherType value
     * @param string $otherType
     * @return \StructType\OntologyPricingMethodType
     */
    public function setOtherType($otherType = null)
    {
        // validation for constraint: string
        if (!is_null($otherType) && !is_string($otherType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($otherType, true), gettype($otherType)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{1,64})
        if (!is_null($otherType) && !preg_match('/[a-zA-Z0-9]{1,64}/', $otherType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{1,64}', var_export($otherType, true)), __LINE__);
        }
        $this->OtherType = $otherType;
        return $this;
    }
    /**
     * Get OntologyRefID value
     * @return string|null
     */
    public function getOntologyRefID()
    {
        return $this->OntologyRefID;
    }
    /**
     * Set OntologyRefID value
     * @param string $ontologyRefID
     * @return \StructType\OntologyPricingMethodType
     */
    public function setOntologyRefID($ontologyRefID = null)
    {
        // validation for constraint: string
        if (!is_null($ontologyRefID) && !is_string($ontologyRefID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ontologyRefID, true), gettype($ontologyRefID)), __LINE__);
        }
        // validation for constraint: pattern([0-9]{1,8})
        if (!is_null($ontologyRefID) && !preg_match('/[0-9]{1,8}/', $ontologyRefID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9]{1,8}', var_export($ontologyRefID, true)), __LINE__);
        }
        $this->OntologyRefID = $ontologyRefID;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\OntologyPricingMethodType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
