<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OntologyOfferType StructType
 * Meta information extracted from the WSDL
 * - documentation: Offer type, inclusion/ exclusion with ontology reference.
 * @subpackage Structs
 */
class OntologyOfferType extends AbstractStructBase
{
    /**
     * The Offer
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \StructType\Offer[]
     */
    public $Offer;
    /**
     * The OntologyExtension
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: OntologyExtension
     * @var mixed
     */
    public $OntologyExtension;
    /**
     * The AllOffersInd
     * Meta information extracted from the WSDL
     * - documentation: Implementer: If true, all offer types should be considered for the response and it is not necessary to parse the OfferType element. | Example: true | Return all offer types indicator.
     * - use: optional
     * @var bool
     */
    public $AllOffersInd;
    /**
     * The OntologyRefID
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - pattern: [0-9]{1,8}
     * - use: optional
     * @var string
     */
    public $OntologyRefID;
    /**
     * Constructor method for OntologyOfferType
     * @uses OntologyOfferType::setOffer()
     * @uses OntologyOfferType::setOntologyExtension()
     * @uses OntologyOfferType::setAllOffersInd()
     * @uses OntologyOfferType::setOntologyRefID()
     * @param \StructType\Offer[] $offer
     * @param mixed $ontologyExtension
     * @param bool $allOffersInd
     * @param string $ontologyRefID
     */
    public function __construct(array $offer = array(), $ontologyExtension = null, $allOffersInd = null, $ontologyRefID = null)
    {
        $this
            ->setOffer($offer)
            ->setOntologyExtension($ontologyExtension)
            ->setAllOffersInd($allOffersInd)
            ->setOntologyRefID($ontologyRefID);
    }
    /**
     * Get Offer value
     * @return \StructType\Offer[]|null
     */
    public function getOffer()
    {
        return $this->Offer;
    }
    /**
     * This method is responsible for validating the values passed to the setOffer method
     * This method is willingly generated in order to preserve the one-line inline validation within the setOffer method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateOfferForArrayConstraintsFromSetOffer(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $ontologyOfferTypeOfferItem) {
            // validation for constraint: itemType
            if (!$ontologyOfferTypeOfferItem instanceof \StructType\Offer) {
                $invalidValues[] = is_object($ontologyOfferTypeOfferItem) ? get_class($ontologyOfferTypeOfferItem) : sprintf('%s(%s)', gettype($ontologyOfferTypeOfferItem), var_export($ontologyOfferTypeOfferItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Offer property can only contain items of type \StructType\Offer, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Offer value
     * @throws \InvalidArgumentException
     * @param \StructType\Offer[] $offer
     * @return \StructType\OntologyOfferType
     */
    public function setOffer(array $offer = array())
    {
        // validation for constraint: array
        if ('' !== ($offerArrayErrorMessage = self::validateOfferForArrayConstraintsFromSetOffer($offer))) {
            throw new \InvalidArgumentException($offerArrayErrorMessage, __LINE__);
        }
        $this->Offer = $offer;
        return $this;
    }
    /**
     * Add item to Offer value
     * @throws \InvalidArgumentException
     * @param \StructType\Offer $item
     * @return \StructType\OntologyOfferType
     */
    public function addToOffer(\StructType\Offer $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Offer) {
            throw new \InvalidArgumentException(sprintf('The Offer property can only contain items of type \StructType\Offer, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Offer[] = $item;
        return $this;
    }
    /**
     * Get OntologyExtension value
     * @return mixed|null
     */
    public function getOntologyExtension()
    {
        return $this->OntologyExtension;
    }
    /**
     * Set OntologyExtension value
     * @param mixed $ontologyExtension
     * @return \StructType\OntologyOfferType
     */
    public function setOntologyExtension($ontologyExtension = null)
    {
        $this->OntologyExtension = $ontologyExtension;
        return $this;
    }
    /**
     * Get AllOffersInd value
     * @return bool|null
     */
    public function getAllOffersInd()
    {
        return $this->AllOffersInd;
    }
    /**
     * Set AllOffersInd value
     * @param bool $allOffersInd
     * @return \StructType\OntologyOfferType
     */
    public function setAllOffersInd($allOffersInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($allOffersInd) && !is_bool($allOffersInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($allOffersInd, true), gettype($allOffersInd)), __LINE__);
        }
        $this->AllOffersInd = $allOffersInd;
        return $this;
    }
    /**
     * Get OntologyRefID value
     * @return string|null
     */
    public function getOntologyRefID()
    {
        return $this->OntologyRefID;
    }
    /**
     * Set OntologyRefID value
     * @param string $ontologyRefID
     * @return \StructType\OntologyOfferType
     */
    public function setOntologyRefID($ontologyRefID = null)
    {
        // validation for constraint: string
        if (!is_null($ontologyRefID) && !is_string($ontologyRefID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ontologyRefID, true), gettype($ontologyRefID)), __LINE__);
        }
        // validation for constraint: pattern([0-9]{1,8})
        if (!is_null($ontologyRefID) && !preg_match('/[0-9]{1,8}/', $ontologyRefID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9]{1,8}', var_export($ontologyRefID, true)), __LINE__);
        }
        $this->OntologyRefID = $ontologyRefID;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\OntologyOfferType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
