<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OntologyNameType StructType
 * Meta information extracted from the WSDL
 * - documentation: Traveler name information with ontology reference.
 * @subpackage Structs
 */
class OntologyNameType extends AbstractStructBase
{
    /**
     * The Surname
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - pattern: [a-zA-Z]{1,64}
     * - use: required
     * @var string
     */
    public $Surname;
    /**
     * The OntologyExtension
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: OntologyExtension
     * @var mixed
     */
    public $OntologyExtension;
    /**
     * The PrivacyInd
     * Meta information extracted from the WSDL
     * - documentation: Implementer: If true, this traveler information may only be used to determine relevant offers. | Example: true | Information use and sharing restriction indicator.
     * - use: optional
     * @var bool
     */
    public $PrivacyInd;
    /**
     * The GivenName
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - pattern: [a-zA-Z]{1,64}
     * - use: optional
     * @var string
     */
    public $GivenName;
    /**
     * The OntologyRefID
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - pattern: [0-9]{1,8}
     * - use: optional
     * @var string
     */
    public $OntologyRefID;
    /**
     * Constructor method for OntologyNameType
     * @uses OntologyNameType::setSurname()
     * @uses OntologyNameType::setOntologyExtension()
     * @uses OntologyNameType::setPrivacyInd()
     * @uses OntologyNameType::setGivenName()
     * @uses OntologyNameType::setOntologyRefID()
     * @param string $surname
     * @param mixed $ontologyExtension
     * @param bool $privacyInd
     * @param string $givenName
     * @param string $ontologyRefID
     */
    public function __construct($surname = null, $ontologyExtension = null, $privacyInd = null, $givenName = null, $ontologyRefID = null)
    {
        $this
            ->setSurname($surname)
            ->setOntologyExtension($ontologyExtension)
            ->setPrivacyInd($privacyInd)
            ->setGivenName($givenName)
            ->setOntologyRefID($ontologyRefID);
    }
    /**
     * Get Surname value
     * @return string
     */
    public function getSurname()
    {
        return $this->Surname;
    }
    /**
     * Set Surname value
     * @param string $surname
     * @return \StructType\OntologyNameType
     */
    public function setSurname($surname = null)
    {
        // validation for constraint: string
        if (!is_null($surname) && !is_string($surname)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($surname, true), gettype($surname)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z]{1,64})
        if (!is_null($surname) && !preg_match('/[a-zA-Z]{1,64}/', $surname)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z]{1,64}', var_export($surname, true)), __LINE__);
        }
        $this->Surname = $surname;
        return $this;
    }
    /**
     * Get OntologyExtension value
     * @return mixed|null
     */
    public function getOntologyExtension()
    {
        return $this->OntologyExtension;
    }
    /**
     * Set OntologyExtension value
     * @param mixed $ontologyExtension
     * @return \StructType\OntologyNameType
     */
    public function setOntologyExtension($ontologyExtension = null)
    {
        $this->OntologyExtension = $ontologyExtension;
        return $this;
    }
    /**
     * Get PrivacyInd value
     * @return bool|null
     */
    public function getPrivacyInd()
    {
        return $this->PrivacyInd;
    }
    /**
     * Set PrivacyInd value
     * @param bool $privacyInd
     * @return \StructType\OntologyNameType
     */
    public function setPrivacyInd($privacyInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($privacyInd) && !is_bool($privacyInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($privacyInd, true), gettype($privacyInd)), __LINE__);
        }
        $this->PrivacyInd = $privacyInd;
        return $this;
    }
    /**
     * Get GivenName value
     * @return string|null
     */
    public function getGivenName()
    {
        return $this->GivenName;
    }
    /**
     * Set GivenName value
     * @param string $givenName
     * @return \StructType\OntologyNameType
     */
    public function setGivenName($givenName = null)
    {
        // validation for constraint: string
        if (!is_null($givenName) && !is_string($givenName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($givenName, true), gettype($givenName)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z]{1,64})
        if (!is_null($givenName) && !preg_match('/[a-zA-Z]{1,64}/', $givenName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z]{1,64}', var_export($givenName, true)), __LINE__);
        }
        $this->GivenName = $givenName;
        return $this;
    }
    /**
     * Get OntologyRefID value
     * @return string|null
     */
    public function getOntologyRefID()
    {
        return $this->OntologyRefID;
    }
    /**
     * Set OntologyRefID value
     * @param string $ontologyRefID
     * @return \StructType\OntologyNameType
     */
    public function setOntologyRefID($ontologyRefID = null)
    {
        // validation for constraint: string
        if (!is_null($ontologyRefID) && !is_string($ontologyRefID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ontologyRefID, true), gettype($ontologyRefID)), __LINE__);
        }
        // validation for constraint: pattern([0-9]{1,8})
        if (!is_null($ontologyRefID) && !preg_match('/[0-9]{1,8}/', $ontologyRefID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9]{1,8}', var_export($ontologyRefID, true)), __LINE__);
        }
        $this->OntologyRefID = $ontologyRefID;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\OntologyNameType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
