<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OntologyLoyaltyType StructType
 * Meta information extracted from the WSDL
 * - documentation: Loyalty information with ontology reference.
 * @subpackage Structs
 */
class OntologyLoyaltyType extends AbstractStructBase
{
    /**
     * The Sector
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Sector
     */
    public $Sector;
    /**
     * The ProgramNameOrCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ProgramNameOrCode
     */
    public $ProgramNameOrCode;
    /**
     * The MemberInfo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\MemberInfo
     */
    public $MemberInfo;
    /**
     * The OntologyExtension
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: OntologyExtension
     * @var mixed
     */
    public $OntologyExtension;
    /**
     * Constructor method for OntologyLoyaltyType
     * @uses OntologyLoyaltyType::setSector()
     * @uses OntologyLoyaltyType::setProgramNameOrCode()
     * @uses OntologyLoyaltyType::setMemberInfo()
     * @uses OntologyLoyaltyType::setOntologyExtension()
     * @param \StructType\Sector $sector
     * @param \StructType\ProgramNameOrCode $programNameOrCode
     * @param \StructType\MemberInfo $memberInfo
     * @param mixed $ontologyExtension
     */
    public function __construct(\StructType\Sector $sector = null, \StructType\ProgramNameOrCode $programNameOrCode = null, \StructType\MemberInfo $memberInfo = null, $ontologyExtension = null)
    {
        $this
            ->setSector($sector)
            ->setProgramNameOrCode($programNameOrCode)
            ->setMemberInfo($memberInfo)
            ->setOntologyExtension($ontologyExtension);
    }
    /**
     * Get Sector value
     * @return \StructType\Sector|null
     */
    public function getSector()
    {
        return $this->Sector;
    }
    /**
     * Set Sector value
     * @param \StructType\Sector $sector
     * @return \StructType\OntologyLoyaltyType
     */
    public function setSector(\StructType\Sector $sector = null)
    {
        $this->Sector = $sector;
        return $this;
    }
    /**
     * Get ProgramNameOrCode value
     * @return \StructType\ProgramNameOrCode|null
     */
    public function getProgramNameOrCode()
    {
        return $this->ProgramNameOrCode;
    }
    /**
     * Set ProgramNameOrCode value
     * @param \StructType\ProgramNameOrCode $programNameOrCode
     * @return \StructType\OntologyLoyaltyType
     */
    public function setProgramNameOrCode(\StructType\ProgramNameOrCode $programNameOrCode = null)
    {
        $this->ProgramNameOrCode = $programNameOrCode;
        return $this;
    }
    /**
     * Get MemberInfo value
     * @return \StructType\MemberInfo|null
     */
    public function getMemberInfo()
    {
        return $this->MemberInfo;
    }
    /**
     * Set MemberInfo value
     * @param \StructType\MemberInfo $memberInfo
     * @return \StructType\OntologyLoyaltyType
     */
    public function setMemberInfo(\StructType\MemberInfo $memberInfo = null)
    {
        $this->MemberInfo = $memberInfo;
        return $this;
    }
    /**
     * Get OntologyExtension value
     * @return mixed|null
     */
    public function getOntologyExtension()
    {
        return $this->OntologyExtension;
    }
    /**
     * Set OntologyExtension value
     * @param mixed $ontologyExtension
     * @return \StructType\OntologyLoyaltyType
     */
    public function setOntologyExtension($ontologyExtension = null)
    {
        $this->OntologyExtension = $ontologyExtension;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\OntologyLoyaltyType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
