<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OntologyDistanceType StructType
 * Meta information extracted from the WSDL
 * - documentation: Distance unit of measure and value with ontology reference.
 * @subpackage Structs
 */
class OntologyDistanceType extends AbstractStructBase
{
    /**
     * The MeasurementSystem
     * Meta information extracted from the WSDL
     * - base: List_OfferMeasurementSystem
     * - use: required
     * @var string
     */
    public $MeasurementSystem;
    /**
     * The Distance
     * @var \StructType\Distance
     */
    public $Distance;
    /**
     * The OntologyExtension
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: OntologyExtension
     * @var mixed
     */
    public $OntologyExtension;
    /**
     * The OntologyRefID
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - pattern: [0-9]{1,8}
     * - use: optional
     * @var string
     */
    public $OntologyRefID;
    /**
     * Constructor method for OntologyDistanceType
     * @uses OntologyDistanceType::setMeasurementSystem()
     * @uses OntologyDistanceType::setDistance()
     * @uses OntologyDistanceType::setOntologyExtension()
     * @uses OntologyDistanceType::setOntologyRefID()
     * @param string $measurementSystem
     * @param \StructType\Distance $distance
     * @param mixed $ontologyExtension
     * @param string $ontologyRefID
     */
    public function __construct($measurementSystem = null, \StructType\Distance $distance = null, $ontologyExtension = null, $ontologyRefID = null)
    {
        $this
            ->setMeasurementSystem($measurementSystem)
            ->setDistance($distance)
            ->setOntologyExtension($ontologyExtension)
            ->setOntologyRefID($ontologyRefID);
    }
    /**
     * Get MeasurementSystem value
     * @return string
     */
    public function getMeasurementSystem()
    {
        return $this->MeasurementSystem;
    }
    /**
     * Set MeasurementSystem value
     * @param string $measurementSystem
     * @return \StructType\OntologyDistanceType
     */
    public function setMeasurementSystem($measurementSystem = null)
    {
        // validation for constraint: string
        if (!is_null($measurementSystem) && !is_string($measurementSystem)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($measurementSystem, true), gettype($measurementSystem)), __LINE__);
        }
        $this->MeasurementSystem = $measurementSystem;
        return $this;
    }
    /**
     * Get Distance value
     * @return \StructType\Distance|null
     */
    public function getDistance()
    {
        return $this->Distance;
    }
    /**
     * Set Distance value
     * @param \StructType\Distance $distance
     * @return \StructType\OntologyDistanceType
     */
    public function setDistance(\StructType\Distance $distance = null)
    {
        $this->Distance = $distance;
        return $this;
    }
    /**
     * Get OntologyExtension value
     * @return mixed|null
     */
    public function getOntologyExtension()
    {
        return $this->OntologyExtension;
    }
    /**
     * Set OntologyExtension value
     * @param mixed $ontologyExtension
     * @return \StructType\OntologyDistanceType
     */
    public function setOntologyExtension($ontologyExtension = null)
    {
        $this->OntologyExtension = $ontologyExtension;
        return $this;
    }
    /**
     * Get OntologyRefID value
     * @return string|null
     */
    public function getOntologyRefID()
    {
        return $this->OntologyRefID;
    }
    /**
     * Set OntologyRefID value
     * @param string $ontologyRefID
     * @return \StructType\OntologyDistanceType
     */
    public function setOntologyRefID($ontologyRefID = null)
    {
        // validation for constraint: string
        if (!is_null($ontologyRefID) && !is_string($ontologyRefID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ontologyRefID, true), gettype($ontologyRefID)), __LINE__);
        }
        // validation for constraint: pattern([0-9]{1,8})
        if (!is_null($ontologyRefID) && !preg_match('/[0-9]{1,8}/', $ontologyRefID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9]{1,8}', var_export($ontologyRefID, true)), __LINE__);
        }
        $this->OntologyRefID = $ontologyRefID;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\OntologyDistanceType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
