<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OntologyDefinitionType StructType
 * Meta information extracted from the WSDL
 * - documentation: Ontology specification.
 * @subpackage Structs
 */
class OntologyDefinitionType extends AbstractStructBase
{
    /**
     * The URI
     * Meta information extracted from the WSDL
     * - documentation: Example: http://www.thistravelcompany.com/myontology | URI.
     * - use: required
     * @var string
     */
    public $URI;
    /**
     * The Version
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - pattern: [0-9]{1,16}
     * - use: required
     * @var string
     */
    public $Version;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - pattern: [a-zA-Z0-9]{1,64}
     * - use: optional
     * @var string
     */
    public $Name;
    /**
     * The RefID
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - pattern: [0-9]{1,8}
     * - use: optional
     * @var string
     */
    public $RefID;
    /**
     * Constructor method for OntologyDefinitionType
     * @uses OntologyDefinitionType::setURI()
     * @uses OntologyDefinitionType::setVersion()
     * @uses OntologyDefinitionType::setName()
     * @uses OntologyDefinitionType::setRefID()
     * @param string $uRI
     * @param string $version
     * @param string $name
     * @param string $refID
     */
    public function __construct($uRI = null, $version = null, $name = null, $refID = null)
    {
        $this
            ->setURI($uRI)
            ->setVersion($version)
            ->setName($name)
            ->setRefID($refID);
    }
    /**
     * Get URI value
     * @return string
     */
    public function getURI()
    {
        return $this->URI;
    }
    /**
     * Set URI value
     * @param string $uRI
     * @return \StructType\OntologyDefinitionType
     */
    public function setURI($uRI = null)
    {
        // validation for constraint: string
        if (!is_null($uRI) && !is_string($uRI)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uRI, true), gettype($uRI)), __LINE__);
        }
        $this->URI = $uRI;
        return $this;
    }
    /**
     * Get Version value
     * @return string
     */
    public function getVersion()
    {
        return $this->Version;
    }
    /**
     * Set Version value
     * @param string $version
     * @return \StructType\OntologyDefinitionType
     */
    public function setVersion($version = null)
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($version, true), gettype($version)), __LINE__);
        }
        // validation for constraint: pattern([0-9]{1,16})
        if (!is_null($version) && !preg_match('/[0-9]{1,16}/', $version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9]{1,16}', var_export($version, true)), __LINE__);
        }
        $this->Version = $version;
        return $this;
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \StructType\OntologyDefinitionType
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{1,64})
        if (!is_null($name) && !preg_match('/[a-zA-Z0-9]{1,64}/', $name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{1,64}', var_export($name, true)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get RefID value
     * @return string|null
     */
    public function getRefID()
    {
        return $this->RefID;
    }
    /**
     * Set RefID value
     * @param string $refID
     * @return \StructType\OntologyDefinitionType
     */
    public function setRefID($refID = null)
    {
        // validation for constraint: string
        if (!is_null($refID) && !is_string($refID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($refID, true), gettype($refID)), __LINE__);
        }
        // validation for constraint: pattern([0-9]{1,8})
        if (!is_null($refID) && !preg_match('/[0-9]{1,8}/', $refID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9]{1,8}', var_export($refID, true)), __LINE__);
        }
        $this->RefID = $refID;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\OntologyDefinitionType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
