<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OntologyCurrencyType StructType
 * Meta information extracted from the WSDL
 * - documentation: Currency encoding, amount with ontology reference.
 * @subpackage Structs
 */
class OntologyCurrencyType extends AbstractStructBase
{
    /**
     * The CurrencyCode
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - pattern: [a-zA-Z]{3}
     * - use: required
     * @var string
     */
    public $CurrencyCode;
    /**
     * The CurrencyDecimal
     * Meta information extracted from the WSDL
     * - base: xs:positiveInteger
     * - maxInclusive: 3
     * - minInclusive: 1
     * - use: required
     * @var int
     */
    public $CurrencyDecimal;
    /**
     * The Amount
     * Meta information extracted from the WSDL
     * - documentation: Note: ISO 4217 Currency Code format. | Example: USD | Currency amount.
     * - use: required
     * @var int
     */
    public $Amount;
    /**
     * The Context
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - pattern: [a-zA-Z0-9]{1,64}
     * - use: optional
     * @var string
     */
    public $Context;
    /**
     * The OntologyRefID
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - pattern: [0-9]{1,8}
     * - use: optional
     * @var string
     */
    public $OntologyRefID;
    /**
     * Constructor method for OntologyCurrencyType
     * @uses OntologyCurrencyType::setCurrencyCode()
     * @uses OntologyCurrencyType::setCurrencyDecimal()
     * @uses OntologyCurrencyType::setAmount()
     * @uses OntologyCurrencyType::setContext()
     * @uses OntologyCurrencyType::setOntologyRefID()
     * @param string $currencyCode
     * @param int $currencyDecimal
     * @param int $amount
     * @param string $context
     * @param string $ontologyRefID
     */
    public function __construct($currencyCode = null, $currencyDecimal = null, $amount = null, $context = null, $ontologyRefID = null)
    {
        $this
            ->setCurrencyCode($currencyCode)
            ->setCurrencyDecimal($currencyDecimal)
            ->setAmount($amount)
            ->setContext($context)
            ->setOntologyRefID($ontologyRefID);
    }
    /**
     * Get CurrencyCode value
     * @return string
     */
    public function getCurrencyCode()
    {
        return $this->CurrencyCode;
    }
    /**
     * Set CurrencyCode value
     * @param string $currencyCode
     * @return \StructType\OntologyCurrencyType
     */
    public function setCurrencyCode($currencyCode = null)
    {
        // validation for constraint: string
        if (!is_null($currencyCode) && !is_string($currencyCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currencyCode, true), gettype($currencyCode)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z]{3})
        if (!is_null($currencyCode) && !preg_match('/[a-zA-Z]{3}/', $currencyCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z]{3}', var_export($currencyCode, true)), __LINE__);
        }
        $this->CurrencyCode = $currencyCode;
        return $this;
    }
    /**
     * Get CurrencyDecimal value
     * @return int
     */
    public function getCurrencyDecimal()
    {
        return $this->CurrencyDecimal;
    }
    /**
     * Set CurrencyDecimal value
     * @param int $currencyDecimal
     * @return \StructType\OntologyCurrencyType
     */
    public function setCurrencyDecimal($currencyDecimal = null)
    {
        // validation for constraint: int
        if (!is_null($currencyDecimal) && !(is_int($currencyDecimal) || ctype_digit($currencyDecimal))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($currencyDecimal, true), gettype($currencyDecimal)), __LINE__);
        }
        // validation for constraint: maxInclusive(3)
        if (!is_null($currencyDecimal) && $currencyDecimal > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 3', var_export($currencyDecimal, true)), __LINE__);
        }
        // validation for constraint: minInclusive(1)
        if (!is_null($currencyDecimal) && $currencyDecimal < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 1', var_export($currencyDecimal, true)), __LINE__);
        }
        $this->CurrencyDecimal = $currencyDecimal;
        return $this;
    }
    /**
     * Get Amount value
     * @return int
     */
    public function getAmount()
    {
        return $this->Amount;
    }
    /**
     * Set Amount value
     * @param int $amount
     * @return \StructType\OntologyCurrencyType
     */
    public function setAmount($amount = null)
    {
        // validation for constraint: int
        if (!is_null($amount) && !(is_int($amount) || ctype_digit($amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($amount, true), gettype($amount)), __LINE__);
        }
        $this->Amount = $amount;
        return $this;
    }
    /**
     * Get Context value
     * @return string|null
     */
    public function getContext()
    {
        return $this->Context;
    }
    /**
     * Set Context value
     * @param string $context
     * @return \StructType\OntologyCurrencyType
     */
    public function setContext($context = null)
    {
        // validation for constraint: string
        if (!is_null($context) && !is_string($context)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($context, true), gettype($context)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{1,64})
        if (!is_null($context) && !preg_match('/[a-zA-Z0-9]{1,64}/', $context)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{1,64}', var_export($context, true)), __LINE__);
        }
        $this->Context = $context;
        return $this;
    }
    /**
     * Get OntologyRefID value
     * @return string|null
     */
    public function getOntologyRefID()
    {
        return $this->OntologyRefID;
    }
    /**
     * Set OntologyRefID value
     * @param string $ontologyRefID
     * @return \StructType\OntologyCurrencyType
     */
    public function setOntologyRefID($ontologyRefID = null)
    {
        // validation for constraint: string
        if (!is_null($ontologyRefID) && !is_string($ontologyRefID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ontologyRefID, true), gettype($ontologyRefID)), __LINE__);
        }
        // validation for constraint: pattern([0-9]{1,8})
        if (!is_null($ontologyRefID) && !preg_match('/[0-9]{1,8}/', $ontologyRefID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9]{1,8}', var_export($ontologyRefID, true)), __LINE__);
        }
        $this->OntologyRefID = $ontologyRefID;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\OntologyCurrencyType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
