<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OntologyContactType StructType
 * Meta information extracted from the WSDL
 * - documentation: Contact information with ontology reference.
 * @subpackage Structs
 */
class OntologyContactType extends AbstractStructBase
{
    /**
     * The Email
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Email
     */
    public $Email;
    /**
     * The Phone
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Phone
     */
    public $Phone;
    /**
     * The OntologyExtension
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: OntologyExtension
     * @var mixed
     */
    public $OntologyExtension;
    /**
     * Constructor method for OntologyContactType
     * @uses OntologyContactType::setEmail()
     * @uses OntologyContactType::setPhone()
     * @uses OntologyContactType::setOntologyExtension()
     * @param \StructType\Email $email
     * @param \StructType\Phone $phone
     * @param mixed $ontologyExtension
     */
    public function __construct(\StructType\Email $email = null, \StructType\Phone $phone = null, $ontologyExtension = null)
    {
        $this
            ->setEmail($email)
            ->setPhone($phone)
            ->setOntologyExtension($ontologyExtension);
    }
    /**
     * Get Email value
     * @return \StructType\Email|null
     */
    public function getEmail()
    {
        return $this->Email;
    }
    /**
     * Set Email value
     * @param \StructType\Email $email
     * @return \StructType\OntologyContactType
     */
    public function setEmail(\StructType\Email $email = null)
    {
        $this->Email = $email;
        return $this;
    }
    /**
     * Get Phone value
     * @return \StructType\Phone|null
     */
    public function getPhone()
    {
        return $this->Phone;
    }
    /**
     * Set Phone value
     * @param \StructType\Phone $phone
     * @return \StructType\OntologyContactType
     */
    public function setPhone(\StructType\Phone $phone = null)
    {
        $this->Phone = $phone;
        return $this;
    }
    /**
     * Get OntologyExtension value
     * @return mixed|null
     */
    public function getOntologyExtension()
    {
        return $this->OntologyExtension;
    }
    /**
     * Set OntologyExtension value
     * @param mixed $ontologyExtension
     * @return \StructType\OntologyContactType
     */
    public function setOntologyExtension($ontologyExtension = null)
    {
        $this->OntologyExtension = $ontologyExtension;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\OntologyContactType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
