<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OntologyCompanyType StructType
 * Meta information extracted from the WSDL
 * - documentation: Company name, code, travel segment with ontology reference.
 * @subpackage Structs
 */
class OntologyCompanyType extends AbstractStructBase
{
    /**
     * The NameOrCode
     * Meta information extracted from the WSDL
     * - documentation: Example: OTA | Company code and/ or name.
     * @var mixed
     */
    public $NameOrCode;
    /**
     * The TravelSegment
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\TravelSegment
     */
    public $TravelSegment;
    /**
     * The OntologyExtension
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: OntologyExtension
     * @var mixed
     */
    public $OntologyExtension;
    /**
     * Constructor method for OntologyCompanyType
     * @uses OntologyCompanyType::setNameOrCode()
     * @uses OntologyCompanyType::setTravelSegment()
     * @uses OntologyCompanyType::setOntologyExtension()
     * @param mixed $nameOrCode
     * @param \StructType\TravelSegment $travelSegment
     * @param mixed $ontologyExtension
     */
    public function __construct($nameOrCode = null, \StructType\TravelSegment $travelSegment = null, $ontologyExtension = null)
    {
        $this
            ->setNameOrCode($nameOrCode)
            ->setTravelSegment($travelSegment)
            ->setOntologyExtension($ontologyExtension);
    }
    /**
     * Get NameOrCode value
     * @return mixed|null
     */
    public function getNameOrCode()
    {
        return $this->NameOrCode;
    }
    /**
     * Set NameOrCode value
     * @param mixed $nameOrCode
     * @return \StructType\OntologyCompanyType
     */
    public function setNameOrCode($nameOrCode = null)
    {
        $this->NameOrCode = $nameOrCode;
        return $this;
    }
    /**
     * Get TravelSegment value
     * @return \StructType\TravelSegment|null
     */
    public function getTravelSegment()
    {
        return $this->TravelSegment;
    }
    /**
     * Set TravelSegment value
     * @param \StructType\TravelSegment $travelSegment
     * @return \StructType\OntologyCompanyType
     */
    public function setTravelSegment(\StructType\TravelSegment $travelSegment = null)
    {
        $this->TravelSegment = $travelSegment;
        return $this;
    }
    /**
     * Get OntologyExtension value
     * @return mixed|null
     */
    public function getOntologyExtension()
    {
        return $this->OntologyExtension;
    }
    /**
     * Set OntologyExtension value
     * @param mixed $ontologyExtension
     * @return \StructType\OntologyCompanyType
     */
    public function setOntologyExtension($ontologyExtension = null)
    {
        $this->OntologyExtension = $ontologyExtension;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\OntologyCompanyType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
