<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OntologyBaggageType StructType
 * Meta information extracted from the WSDL
 * - documentation: Baggage type, quantity, weight, size with ontology reference.
 * @subpackage Structs
 */
class OntologyBaggageType extends AbstractStructBase
{
    /**
     * The TotalWeight
     * Meta information extracted from the WSDL
     * - documentation: Total weight for all baggage items.
     * - minOccurs: 0
     * @var mixed
     */
    public $TotalWeight;
    /**
     * The Detail
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Detail[]
     */
    public $Detail;
    /**
     * The OntologyExtension
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: OntologyExtension
     * @var mixed
     */
    public $OntologyExtension;
    /**
     * The SpecialItemInd
     * Meta information extracted from the WSDL
     * - documentation: Implementer: If true, traveler(s) have one or more specialty baggage items. | Example: true | Specialty baggage item indicator.
     * - use: optional
     * @var bool
     */
    public $SpecialItemInd;
    /**
     * The TotalPieces
     * Meta information extracted from the WSDL
     * - documentation: Example: 4 | Total baggage quantity.
     * - use: optional
     * @var int
     */
    public $TotalPieces;
    /**
     * Constructor method for OntologyBaggageType
     * @uses OntologyBaggageType::setTotalWeight()
     * @uses OntologyBaggageType::setDetail()
     * @uses OntologyBaggageType::setOntologyExtension()
     * @uses OntologyBaggageType::setSpecialItemInd()
     * @uses OntologyBaggageType::setTotalPieces()
     * @param mixed $totalWeight
     * @param \StructType\Detail[] $detail
     * @param mixed $ontologyExtension
     * @param bool $specialItemInd
     * @param int $totalPieces
     */
    public function __construct($totalWeight = null, array $detail = array(), $ontologyExtension = null, $specialItemInd = null, $totalPieces = null)
    {
        $this
            ->setTotalWeight($totalWeight)
            ->setDetail($detail)
            ->setOntologyExtension($ontologyExtension)
            ->setSpecialItemInd($specialItemInd)
            ->setTotalPieces($totalPieces);
    }
    /**
     * Get TotalWeight value
     * @return mixed|null
     */
    public function getTotalWeight()
    {
        return $this->TotalWeight;
    }
    /**
     * Set TotalWeight value
     * @param mixed $totalWeight
     * @return \StructType\OntologyBaggageType
     */
    public function setTotalWeight($totalWeight = null)
    {
        $this->TotalWeight = $totalWeight;
        return $this;
    }
    /**
     * Get Detail value
     * @return \StructType\Detail[]|null
     */
    public function getDetail()
    {
        return $this->Detail;
    }
    /**
     * This method is responsible for validating the values passed to the setDetail method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDetail method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDetailForArrayConstraintsFromSetDetail(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $ontologyBaggageTypeDetailItem) {
            // validation for constraint: itemType
            if (!$ontologyBaggageTypeDetailItem instanceof \StructType\Detail) {
                $invalidValues[] = is_object($ontologyBaggageTypeDetailItem) ? get_class($ontologyBaggageTypeDetailItem) : sprintf('%s(%s)', gettype($ontologyBaggageTypeDetailItem), var_export($ontologyBaggageTypeDetailItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Detail property can only contain items of type \StructType\Detail, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Detail value
     * @throws \InvalidArgumentException
     * @param \StructType\Detail[] $detail
     * @return \StructType\OntologyBaggageType
     */
    public function setDetail(array $detail = array())
    {
        // validation for constraint: array
        if ('' !== ($detailArrayErrorMessage = self::validateDetailForArrayConstraintsFromSetDetail($detail))) {
            throw new \InvalidArgumentException($detailArrayErrorMessage, __LINE__);
        }
        $this->Detail = $detail;
        return $this;
    }
    /**
     * Add item to Detail value
     * @throws \InvalidArgumentException
     * @param \StructType\Detail $item
     * @return \StructType\OntologyBaggageType
     */
    public function addToDetail(\StructType\Detail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Detail) {
            throw new \InvalidArgumentException(sprintf('The Detail property can only contain items of type \StructType\Detail, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Detail[] = $item;
        return $this;
    }
    /**
     * Get OntologyExtension value
     * @return mixed|null
     */
    public function getOntologyExtension()
    {
        return $this->OntologyExtension;
    }
    /**
     * Set OntologyExtension value
     * @param mixed $ontologyExtension
     * @return \StructType\OntologyBaggageType
     */
    public function setOntologyExtension($ontologyExtension = null)
    {
        $this->OntologyExtension = $ontologyExtension;
        return $this;
    }
    /**
     * Get SpecialItemInd value
     * @return bool|null
     */
    public function getSpecialItemInd()
    {
        return $this->SpecialItemInd;
    }
    /**
     * Set SpecialItemInd value
     * @param bool $specialItemInd
     * @return \StructType\OntologyBaggageType
     */
    public function setSpecialItemInd($specialItemInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($specialItemInd) && !is_bool($specialItemInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($specialItemInd, true), gettype($specialItemInd)), __LINE__);
        }
        $this->SpecialItemInd = $specialItemInd;
        return $this;
    }
    /**
     * Get TotalPieces value
     * @return int|null
     */
    public function getTotalPieces()
    {
        return $this->TotalPieces;
    }
    /**
     * Set TotalPieces value
     * @param int $totalPieces
     * @return \StructType\OntologyBaggageType
     */
    public function setTotalPieces($totalPieces = null)
    {
        // validation for constraint: int
        if (!is_null($totalPieces) && !(is_int($totalPieces) || ctype_digit($totalPieces))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($totalPieces, true), gettype($totalPieces)), __LINE__);
        }
        $this->TotalPieces = $totalPieces;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\OntologyBaggageType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
