<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OntologyAnimalType StructType
 * Meta information extracted from the WSDL
 * - documentation: Animal type, weight with ontology reference.
 * @subpackage Structs
 */
class OntologyAnimalType extends AbstractStructBase
{
    /**
     * The Detail
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Detail[]
     */
    public $Detail;
    /**
     * The Quantity
     * Meta information extracted from the WSDL
     * - documentation: Example: 1 | Animal quantity.
     * - use: optional
     * @var int
     */
    public $Quantity;
    /**
     * The ServiceAnimalInd
     * Meta information extracted from the WSDL
     * - documentation: Implementer: If true, one or more travelers has a service animal. | Example: true | Service animal indicator.
     * - use: optional
     * @var bool
     */
    public $ServiceAnimalInd;
    /**
     * Constructor method for OntologyAnimalType
     * @uses OntologyAnimalType::setDetail()
     * @uses OntologyAnimalType::setQuantity()
     * @uses OntologyAnimalType::setServiceAnimalInd()
     * @param \StructType\Detail[] $detail
     * @param int $quantity
     * @param bool $serviceAnimalInd
     */
    public function __construct(array $detail = array(), $quantity = null, $serviceAnimalInd = null)
    {
        $this
            ->setDetail($detail)
            ->setQuantity($quantity)
            ->setServiceAnimalInd($serviceAnimalInd);
    }
    /**
     * Get Detail value
     * @return \StructType\Detail[]|null
     */
    public function getDetail()
    {
        return $this->Detail;
    }
    /**
     * This method is responsible for validating the values passed to the setDetail method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDetail method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDetailForArrayConstraintsFromSetDetail(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $ontologyAnimalTypeDetailItem) {
            // validation for constraint: itemType
            if (!$ontologyAnimalTypeDetailItem instanceof \StructType\Detail) {
                $invalidValues[] = is_object($ontologyAnimalTypeDetailItem) ? get_class($ontologyAnimalTypeDetailItem) : sprintf('%s(%s)', gettype($ontologyAnimalTypeDetailItem), var_export($ontologyAnimalTypeDetailItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Detail property can only contain items of type \StructType\Detail, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Detail value
     * @throws \InvalidArgumentException
     * @param \StructType\Detail[] $detail
     * @return \StructType\OntologyAnimalType
     */
    public function setDetail(array $detail = array())
    {
        // validation for constraint: array
        if ('' !== ($detailArrayErrorMessage = self::validateDetailForArrayConstraintsFromSetDetail($detail))) {
            throw new \InvalidArgumentException($detailArrayErrorMessage, __LINE__);
        }
        $this->Detail = $detail;
        return $this;
    }
    /**
     * Add item to Detail value
     * @throws \InvalidArgumentException
     * @param \StructType\Detail $item
     * @return \StructType\OntologyAnimalType
     */
    public function addToDetail(\StructType\Detail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Detail) {
            throw new \InvalidArgumentException(sprintf('The Detail property can only contain items of type \StructType\Detail, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Detail[] = $item;
        return $this;
    }
    /**
     * Get Quantity value
     * @return int|null
     */
    public function getQuantity()
    {
        return $this->Quantity;
    }
    /**
     * Set Quantity value
     * @param int $quantity
     * @return \StructType\OntologyAnimalType
     */
    public function setQuantity($quantity = null)
    {
        // validation for constraint: int
        if (!is_null($quantity) && !(is_int($quantity) || ctype_digit($quantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($quantity, true), gettype($quantity)), __LINE__);
        }
        $this->Quantity = $quantity;
        return $this;
    }
    /**
     * Get ServiceAnimalInd value
     * @return bool|null
     */
    public function getServiceAnimalInd()
    {
        return $this->ServiceAnimalInd;
    }
    /**
     * Set ServiceAnimalInd value
     * @param bool $serviceAnimalInd
     * @return \StructType\OntologyAnimalType
     */
    public function setServiceAnimalInd($serviceAnimalInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($serviceAnimalInd) && !is_bool($serviceAnimalInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($serviceAnimalInd, true), gettype($serviceAnimalInd)), __LINE__);
        }
        $this->ServiceAnimalInd = $serviceAnimalInd;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\OntologyAnimalType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
