<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OntologyAgeBirthDateType StructType
 * Meta information extracted from the WSDL
 * - documentation: Age,and birthdate information with ontology reference.
 * @subpackage Structs
 */
class OntologyAgeBirthDateType extends AbstractStructBase
{
    /**
     * The PrivacyInd
     * Meta information extracted from the WSDL
     * - documentation: Implementer: If true, this traveler information may only be used to determine relevant offers. | Example: true | Information use and sharing restriction indicator.
     * - use: optional
     * @var bool
     */
    public $PrivacyInd;
    /**
     * The Age
     * Meta information extracted from the WSDL
     * - documentation: Example: 32 | Age in years.
     * - use: optional
     * @var int
     */
    public $Age;
    /**
     * The BirthDate
     * Meta information extracted from the WSDL
     * - documentation: Example: 1973-01-12 | Birth date.
     * - use: optional
     * @var string
     */
    public $BirthDate;
    /**
     * The BirthYear
     * Meta information extracted from the WSDL
     * - documentation: Example: 1973-01-12 | Birth year.
     * - use: optional
     * @var string
     */
    public $BirthYear;
    /**
     * The OntologyRefID
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - pattern: [0-9]{1,8}
     * - use: optional
     * @var string
     */
    public $OntologyRefID;
    /**
     * Constructor method for OntologyAgeBirthDateType
     * @uses OntologyAgeBirthDateType::setPrivacyInd()
     * @uses OntologyAgeBirthDateType::setAge()
     * @uses OntologyAgeBirthDateType::setBirthDate()
     * @uses OntologyAgeBirthDateType::setBirthYear()
     * @uses OntologyAgeBirthDateType::setOntologyRefID()
     * @param bool $privacyInd
     * @param int $age
     * @param string $birthDate
     * @param string $birthYear
     * @param string $ontologyRefID
     */
    public function __construct($privacyInd = null, $age = null, $birthDate = null, $birthYear = null, $ontologyRefID = null)
    {
        $this
            ->setPrivacyInd($privacyInd)
            ->setAge($age)
            ->setBirthDate($birthDate)
            ->setBirthYear($birthYear)
            ->setOntologyRefID($ontologyRefID);
    }
    /**
     * Get PrivacyInd value
     * @return bool|null
     */
    public function getPrivacyInd()
    {
        return $this->PrivacyInd;
    }
    /**
     * Set PrivacyInd value
     * @param bool $privacyInd
     * @return \StructType\OntologyAgeBirthDateType
     */
    public function setPrivacyInd($privacyInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($privacyInd) && !is_bool($privacyInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($privacyInd, true), gettype($privacyInd)), __LINE__);
        }
        $this->PrivacyInd = $privacyInd;
        return $this;
    }
    /**
     * Get Age value
     * @return int|null
     */
    public function getAge()
    {
        return $this->Age;
    }
    /**
     * Set Age value
     * @param int $age
     * @return \StructType\OntologyAgeBirthDateType
     */
    public function setAge($age = null)
    {
        // validation for constraint: int
        if (!is_null($age) && !(is_int($age) || ctype_digit($age))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($age, true), gettype($age)), __LINE__);
        }
        $this->Age = $age;
        return $this;
    }
    /**
     * Get BirthDate value
     * @return string|null
     */
    public function getBirthDate()
    {
        return $this->BirthDate;
    }
    /**
     * Set BirthDate value
     * @param string $birthDate
     * @return \StructType\OntologyAgeBirthDateType
     */
    public function setBirthDate($birthDate = null)
    {
        // validation for constraint: string
        if (!is_null($birthDate) && !is_string($birthDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($birthDate, true), gettype($birthDate)), __LINE__);
        }
        $this->BirthDate = $birthDate;
        return $this;
    }
    /**
     * Get BirthYear value
     * @return string|null
     */
    public function getBirthYear()
    {
        return $this->BirthYear;
    }
    /**
     * Set BirthYear value
     * @param string $birthYear
     * @return \StructType\OntologyAgeBirthDateType
     */
    public function setBirthYear($birthYear = null)
    {
        // validation for constraint: string
        if (!is_null($birthYear) && !is_string($birthYear)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($birthYear, true), gettype($birthYear)), __LINE__);
        }
        $this->BirthYear = $birthYear;
        return $this;
    }
    /**
     * Get OntologyRefID value
     * @return string|null
     */
    public function getOntologyRefID()
    {
        return $this->OntologyRefID;
    }
    /**
     * Set OntologyRefID value
     * @param string $ontologyRefID
     * @return \StructType\OntologyAgeBirthDateType
     */
    public function setOntologyRefID($ontologyRefID = null)
    {
        // validation for constraint: string
        if (!is_null($ontologyRefID) && !is_string($ontologyRefID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ontologyRefID, true), gettype($ontologyRefID)), __LINE__);
        }
        // validation for constraint: pattern([0-9]{1,8})
        if (!is_null($ontologyRefID) && !preg_match('/[0-9]{1,8}/', $ontologyRefID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9]{1,8}', var_export($ontologyRefID, true)), __LINE__);
        }
        $this->OntologyRefID = $ontologyRefID;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\OntologyAgeBirthDateType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
