<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OntologyAddressType StructType
 * Meta information extracted from the WSDL
 * - documentation: Address information with ontology reference.
 * @subpackage Structs
 */
class OntologyAddressType extends AbstractStructBase
{
    /**
     * The Street
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Street
     */
    public $Street;
    /**
     * The City
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\City
     */
    public $City;
    /**
     * The StateProvince
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\StateProvince
     */
    public $StateProvince;
    /**
     * The Postal
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Postal
     */
    public $Postal;
    /**
     * The Country
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Country
     */
    public $Country;
    /**
     * The OntologyExtension
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: OntologyExtension
     * @var mixed
     */
    public $OntologyExtension;
    /**
     * The PrivacyInd
     * Meta information extracted from the WSDL
     * - documentation: Implementer: If true, this traveler information may only be used to determine relevant offers. | Example: true | Information use and sharing restriction indicator.
     * - use: optional
     * @var bool
     */
    public $PrivacyInd;
    /**
     * Constructor method for OntologyAddressType
     * @uses OntologyAddressType::setStreet()
     * @uses OntologyAddressType::setCity()
     * @uses OntologyAddressType::setStateProvince()
     * @uses OntologyAddressType::setPostal()
     * @uses OntologyAddressType::setCountry()
     * @uses OntologyAddressType::setOntologyExtension()
     * @uses OntologyAddressType::setPrivacyInd()
     * @param \StructType\Street $street
     * @param \StructType\City $city
     * @param \StructType\StateProvince $stateProvince
     * @param \StructType\Postal $postal
     * @param \StructType\Country $country
     * @param mixed $ontologyExtension
     * @param bool $privacyInd
     */
    public function __construct(\StructType\Street $street = null, \StructType\City $city = null, \StructType\StateProvince $stateProvince = null, \StructType\Postal $postal = null, \StructType\Country $country = null, $ontologyExtension = null, $privacyInd = null)
    {
        $this
            ->setStreet($street)
            ->setCity($city)
            ->setStateProvince($stateProvince)
            ->setPostal($postal)
            ->setCountry($country)
            ->setOntologyExtension($ontologyExtension)
            ->setPrivacyInd($privacyInd);
    }
    /**
     * Get Street value
     * @return \StructType\Street|null
     */
    public function getStreet()
    {
        return $this->Street;
    }
    /**
     * Set Street value
     * @param \StructType\Street $street
     * @return \StructType\OntologyAddressType
     */
    public function setStreet(\StructType\Street $street = null)
    {
        $this->Street = $street;
        return $this;
    }
    /**
     * Get City value
     * @return \StructType\City|null
     */
    public function getCity()
    {
        return $this->City;
    }
    /**
     * Set City value
     * @param \StructType\City $city
     * @return \StructType\OntologyAddressType
     */
    public function setCity(\StructType\City $city = null)
    {
        $this->City = $city;
        return $this;
    }
    /**
     * Get StateProvince value
     * @return \StructType\StateProvince|null
     */
    public function getStateProvince()
    {
        return $this->StateProvince;
    }
    /**
     * Set StateProvince value
     * @param \StructType\StateProvince $stateProvince
     * @return \StructType\OntologyAddressType
     */
    public function setStateProvince(\StructType\StateProvince $stateProvince = null)
    {
        $this->StateProvince = $stateProvince;
        return $this;
    }
    /**
     * Get Postal value
     * @return \StructType\Postal|null
     */
    public function getPostal()
    {
        return $this->Postal;
    }
    /**
     * Set Postal value
     * @param \StructType\Postal $postal
     * @return \StructType\OntologyAddressType
     */
    public function setPostal(\StructType\Postal $postal = null)
    {
        $this->Postal = $postal;
        return $this;
    }
    /**
     * Get Country value
     * @return \StructType\Country|null
     */
    public function getCountry()
    {
        return $this->Country;
    }
    /**
     * Set Country value
     * @param \StructType\Country $country
     * @return \StructType\OntologyAddressType
     */
    public function setCountry(\StructType\Country $country = null)
    {
        $this->Country = $country;
        return $this;
    }
    /**
     * Get OntologyExtension value
     * @return mixed|null
     */
    public function getOntologyExtension()
    {
        return $this->OntologyExtension;
    }
    /**
     * Set OntologyExtension value
     * @param mixed $ontologyExtension
     * @return \StructType\OntologyAddressType
     */
    public function setOntologyExtension($ontologyExtension = null)
    {
        $this->OntologyExtension = $ontologyExtension;
        return $this;
    }
    /**
     * Get PrivacyInd value
     * @return bool|null
     */
    public function getPrivacyInd()
    {
        return $this->PrivacyInd;
    }
    /**
     * Set PrivacyInd value
     * @param bool $privacyInd
     * @return \StructType\OntologyAddressType
     */
    public function setPrivacyInd($privacyInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($privacyInd) && !is_bool($privacyInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($privacyInd, true), gettype($privacyInd)), __LINE__);
        }
        $this->PrivacyInd = $privacyInd;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\OntologyAddressType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
