<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Ontology StructType
 * Meta information extracted from the WSDL
 * - documentation: OpenTravel ontology information.
 * @subpackage Structs
 */
class Ontology extends OntologyDefinitionType
{
    /**
     * The CompatibleWith
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\CompatibleWith[]
     */
    public $CompatibleWith;
    /**
     * The OntologyExtension
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: OntologyExtension
     * @var mixed
     */
    public $OntologyExtension;
    /**
     * Constructor method for Ontology
     * @uses Ontology::setCompatibleWith()
     * @uses Ontology::setOntologyExtension()
     * @param \StructType\CompatibleWith[] $compatibleWith
     * @param mixed $ontologyExtension
     */
    public function __construct(array $compatibleWith = array(), $ontologyExtension = null)
    {
        $this
            ->setCompatibleWith($compatibleWith)
            ->setOntologyExtension($ontologyExtension);
    }
    /**
     * Get CompatibleWith value
     * @return \StructType\CompatibleWith[]|null
     */
    public function getCompatibleWith()
    {
        return $this->CompatibleWith;
    }
    /**
     * This method is responsible for validating the values passed to the setCompatibleWith method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCompatibleWith method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCompatibleWithForArrayConstraintsFromSetCompatibleWith(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $ontologyCompatibleWithItem) {
            // validation for constraint: itemType
            if (!$ontologyCompatibleWithItem instanceof \StructType\CompatibleWith) {
                $invalidValues[] = is_object($ontologyCompatibleWithItem) ? get_class($ontologyCompatibleWithItem) : sprintf('%s(%s)', gettype($ontologyCompatibleWithItem), var_export($ontologyCompatibleWithItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The CompatibleWith property can only contain items of type \StructType\CompatibleWith, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set CompatibleWith value
     * @throws \InvalidArgumentException
     * @param \StructType\CompatibleWith[] $compatibleWith
     * @return \StructType\Ontology
     */
    public function setCompatibleWith(array $compatibleWith = array())
    {
        // validation for constraint: array
        if ('' !== ($compatibleWithArrayErrorMessage = self::validateCompatibleWithForArrayConstraintsFromSetCompatibleWith($compatibleWith))) {
            throw new \InvalidArgumentException($compatibleWithArrayErrorMessage, __LINE__);
        }
        $this->CompatibleWith = $compatibleWith;
        return $this;
    }
    /**
     * Add item to CompatibleWith value
     * @throws \InvalidArgumentException
     * @param \StructType\CompatibleWith $item
     * @return \StructType\Ontology
     */
    public function addToCompatibleWith(\StructType\CompatibleWith $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CompatibleWith) {
            throw new \InvalidArgumentException(sprintf('The CompatibleWith property can only contain items of type \StructType\CompatibleWith, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->CompatibleWith[] = $item;
        return $this;
    }
    /**
     * Get OntologyExtension value
     * @return mixed|null
     */
    public function getOntologyExtension()
    {
        return $this->OntologyExtension;
    }
    /**
     * Set OntologyExtension value
     * @param mixed $ontologyExtension
     * @return \StructType\Ontology
     */
    public function setOntologyExtension($ontologyExtension = null)
    {
        $this->OntologyExtension = $ontologyExtension;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Ontology
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
