<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OfferType StructType
 * Meta information extracted from the WSDL
 * - documentation: Defines the type of offer, the conditions under which the offer can be applied and the amounts and/or percentages deducted.
 * @subpackage Structs
 */
class OfferType extends AbstractStructBase
{
    /**
     * The OfferRules
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\OfferRules
     */
    public $OfferRules;
    /**
     * The Discount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Discount
     */
    public $Discount;
    /**
     * The FreeUpgrade
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\FreeUpgrade
     */
    public $FreeUpgrade;
    /**
     * The OfferDescription
     * Meta information extracted from the WSDL
     * - documentation: A description of the offer. If the offer is based on a written contract, the appropriate paragraph from the contract could be quoted here.
     * - minOccurs: 0
     * @var mixed
     */
    public $OfferDescription;
    /**
     * The CompatibleOffers
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\CompatibleOffers
     */
    public $CompatibleOffers;
    /**
     * The Inventories
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Inventories
     */
    public $Inventories;
    /**
     * The Guests
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Guests
     */
    public $Guests;
    /**
     * The OfferCode
     * Meta information extracted from the WSDL
     * - documentation: A code which uniquely names this offer.
     * - use: optional
     * @var string
     */
    public $OfferCode;
    /**
     * The RPH
     * Meta information extracted from the WSDL
     * - documentation: A reference place holder for this particular offer.
     * - use: optional
     * @var string
     */
    public $RPH;
    /**
     * The ApplicationOrder
     * Meta information extracted from the WSDL
     * - documentation: The order in which the discounts are applied.
     * - use: optional
     * @var int
     */
    public $ApplicationOrder;
    /**
     * Constructor method for OfferType
     * @uses OfferType::setOfferRules()
     * @uses OfferType::setDiscount()
     * @uses OfferType::setFreeUpgrade()
     * @uses OfferType::setOfferDescription()
     * @uses OfferType::setCompatibleOffers()
     * @uses OfferType::setInventories()
     * @uses OfferType::setGuests()
     * @uses OfferType::setOfferCode()
     * @uses OfferType::setRPH()
     * @uses OfferType::setApplicationOrder()
     * @param \StructType\OfferRules $offerRules
     * @param \StructType\Discount $discount
     * @param \StructType\FreeUpgrade $freeUpgrade
     * @param mixed $offerDescription
     * @param \StructType\CompatibleOffers $compatibleOffers
     * @param \StructType\Inventories $inventories
     * @param \StructType\Guests $guests
     * @param string $offerCode
     * @param string $rPH
     * @param int $applicationOrder
     */
    public function __construct(\StructType\OfferRules $offerRules = null, \StructType\Discount $discount = null, \StructType\FreeUpgrade $freeUpgrade = null, $offerDescription = null, \StructType\CompatibleOffers $compatibleOffers = null, \StructType\Inventories $inventories = null, \StructType\Guests $guests = null, $offerCode = null, $rPH = null, $applicationOrder = null)
    {
        $this
            ->setOfferRules($offerRules)
            ->setDiscount($discount)
            ->setFreeUpgrade($freeUpgrade)
            ->setOfferDescription($offerDescription)
            ->setCompatibleOffers($compatibleOffers)
            ->setInventories($inventories)
            ->setGuests($guests)
            ->setOfferCode($offerCode)
            ->setRPH($rPH)
            ->setApplicationOrder($applicationOrder);
    }
    /**
     * Get OfferRules value
     * @return \StructType\OfferRules|null
     */
    public function getOfferRules()
    {
        return $this->OfferRules;
    }
    /**
     * Set OfferRules value
     * @param \StructType\OfferRules $offerRules
     * @return \StructType\OfferType
     */
    public function setOfferRules(\StructType\OfferRules $offerRules = null)
    {
        $this->OfferRules = $offerRules;
        return $this;
    }
    /**
     * Get Discount value
     * @return \StructType\Discount|null
     */
    public function getDiscount()
    {
        return $this->Discount;
    }
    /**
     * Set Discount value
     * @param \StructType\Discount $discount
     * @return \StructType\OfferType
     */
    public function setDiscount(\StructType\Discount $discount = null)
    {
        $this->Discount = $discount;
        return $this;
    }
    /**
     * Get FreeUpgrade value
     * @return \StructType\FreeUpgrade|null
     */
    public function getFreeUpgrade()
    {
        return $this->FreeUpgrade;
    }
    /**
     * Set FreeUpgrade value
     * @param \StructType\FreeUpgrade $freeUpgrade
     * @return \StructType\OfferType
     */
    public function setFreeUpgrade(\StructType\FreeUpgrade $freeUpgrade = null)
    {
        $this->FreeUpgrade = $freeUpgrade;
        return $this;
    }
    /**
     * Get OfferDescription value
     * @return mixed|null
     */
    public function getOfferDescription()
    {
        return $this->OfferDescription;
    }
    /**
     * Set OfferDescription value
     * @param mixed $offerDescription
     * @return \StructType\OfferType
     */
    public function setOfferDescription($offerDescription = null)
    {
        $this->OfferDescription = $offerDescription;
        return $this;
    }
    /**
     * Get CompatibleOffers value
     * @return \StructType\CompatibleOffers|null
     */
    public function getCompatibleOffers()
    {
        return $this->CompatibleOffers;
    }
    /**
     * Set CompatibleOffers value
     * @param \StructType\CompatibleOffers $compatibleOffers
     * @return \StructType\OfferType
     */
    public function setCompatibleOffers(\StructType\CompatibleOffers $compatibleOffers = null)
    {
        $this->CompatibleOffers = $compatibleOffers;
        return $this;
    }
    /**
     * Get Inventories value
     * @return \StructType\Inventories|null
     */
    public function getInventories()
    {
        return $this->Inventories;
    }
    /**
     * Set Inventories value
     * @param \StructType\Inventories $inventories
     * @return \StructType\OfferType
     */
    public function setInventories(\StructType\Inventories $inventories = null)
    {
        $this->Inventories = $inventories;
        return $this;
    }
    /**
     * Get Guests value
     * @return \StructType\Guests|null
     */
    public function getGuests()
    {
        return $this->Guests;
    }
    /**
     * Set Guests value
     * @param \StructType\Guests $guests
     * @return \StructType\OfferType
     */
    public function setGuests(\StructType\Guests $guests = null)
    {
        $this->Guests = $guests;
        return $this;
    }
    /**
     * Get OfferCode value
     * @return string|null
     */
    public function getOfferCode()
    {
        return $this->OfferCode;
    }
    /**
     * Set OfferCode value
     * @param string $offerCode
     * @return \StructType\OfferType
     */
    public function setOfferCode($offerCode = null)
    {
        // validation for constraint: string
        if (!is_null($offerCode) && !is_string($offerCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($offerCode, true), gettype($offerCode)), __LINE__);
        }
        $this->OfferCode = $offerCode;
        return $this;
    }
    /**
     * Get RPH value
     * @return string|null
     */
    public function getRPH()
    {
        return $this->RPH;
    }
    /**
     * Set RPH value
     * @param string $rPH
     * @return \StructType\OfferType
     */
    public function setRPH($rPH = null)
    {
        // validation for constraint: string
        if (!is_null($rPH) && !is_string($rPH)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rPH, true), gettype($rPH)), __LINE__);
        }
        $this->RPH = $rPH;
        return $this;
    }
    /**
     * Get ApplicationOrder value
     * @return int|null
     */
    public function getApplicationOrder()
    {
        return $this->ApplicationOrder;
    }
    /**
     * Set ApplicationOrder value
     * @param int $applicationOrder
     * @return \StructType\OfferType
     */
    public function setApplicationOrder($applicationOrder = null)
    {
        // validation for constraint: int
        if (!is_null($applicationOrder) && !(is_int($applicationOrder) || ctype_digit($applicationOrder))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($applicationOrder, true), gettype($applicationOrder)), __LINE__);
        }
        $this->ApplicationOrder = $applicationOrder;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\OfferType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
