<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OfferRules StructType
 * Meta information extracted from the WSDL
 * - documentation: Collection of offer rules.
 * @subpackage Structs
 */
class OfferRules extends AbstractStructBase
{
    /**
     * The OfferRule
     * Meta information extracted from the WSDL
     * - maxOccurs: 99
     * @var \StructType\OfferRule[]
     */
    public $OfferRule;
    /**
     * Constructor method for OfferRules
     * @uses OfferRules::setOfferRule()
     * @param \StructType\OfferRule[] $offerRule
     */
    public function __construct(array $offerRule = array())
    {
        $this
            ->setOfferRule($offerRule);
    }
    /**
     * Get OfferRule value
     * @return \StructType\OfferRule[]|null
     */
    public function getOfferRule()
    {
        return $this->OfferRule;
    }
    /**
     * This method is responsible for validating the values passed to the setOfferRule method
     * This method is willingly generated in order to preserve the one-line inline validation within the setOfferRule method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateOfferRuleForArrayConstraintsFromSetOfferRule(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $offerRulesOfferRuleItem) {
            // validation for constraint: itemType
            if (!$offerRulesOfferRuleItem instanceof \StructType\OfferRule) {
                $invalidValues[] = is_object($offerRulesOfferRuleItem) ? get_class($offerRulesOfferRuleItem) : sprintf('%s(%s)', gettype($offerRulesOfferRuleItem), var_export($offerRulesOfferRuleItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The OfferRule property can only contain items of type \StructType\OfferRule, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set OfferRule value
     * @throws \InvalidArgumentException
     * @param \StructType\OfferRule[] $offerRule
     * @return \StructType\OfferRules
     */
    public function setOfferRule(array $offerRule = array())
    {
        // validation for constraint: array
        if ('' !== ($offerRuleArrayErrorMessage = self::validateOfferRuleForArrayConstraintsFromSetOfferRule($offerRule))) {
            throw new \InvalidArgumentException($offerRuleArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($offerRule) && count($offerRule) > 99) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 99', count($offerRule)), __LINE__);
        }
        $this->OfferRule = $offerRule;
        return $this;
    }
    /**
     * Add item to OfferRule value
     * @throws \InvalidArgumentException
     * @param \StructType\OfferRule $item
     * @return \StructType\OfferRules
     */
    public function addToOfferRule(\StructType\OfferRule $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\OfferRule) {
            throw new \InvalidArgumentException(sprintf('The OfferRule property can only contain items of type \StructType\OfferRule, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($this->OfferRule) && count($this->OfferRule) >= 99) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 99', count($this->OfferRule)), __LINE__);
        }
        $this->OfferRule[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\OfferRules
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
