<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OfferRule StructType
 * Meta information extracted from the WSDL
 * - documentation: Defines conditions for which the offer applies.
 * @subpackage Structs
 */
class OfferRule extends AbstractStructBase
{
    /**
     * The DateRestriction
     * Meta information extracted from the WSDL
     * - maxOccurs: 5
     * - minOccurs: 0
     * @var \StructType\DateRestriction[]
     */
    public $DateRestriction;
    /**
     * The LengthsOfStay
     * Meta information extracted from the WSDL
     * - documentation: A collection of lengths of stay.
     * - minOccurs: 0
     * @var mixed
     */
    public $LengthsOfStay;
    /**
     * The DOW_Restrictions
     * Meta information extracted from the WSDL
     * - documentation: A collection of Day Of Week restrictions.
     * - minOccurs: 0
     * @var mixed
     */
    public $DOW_Restrictions;
    /**
     * The Occupancy
     * Meta information extracted from the WSDL
     * - maxOccurs: 5
     * - minOccurs: 0
     * @var \StructType\Occupancy[]
     */
    public $Occupancy;
    /**
     * The Inventories
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Inventories
     */
    public $Inventories;
    /**
     * The StayOverDate
     * Meta information extracted from the WSDL
     * - documentation: Indicates a specific day on which the guest must stay over in order to be eligible for the offer.
     * - use: optional
     * @var string
     */
    public $StayOverDate;
    /**
     * The MinTotalOccupancy
     * Meta information extracted from the WSDL
     * - documentation: Defines the minimum number of total occupants required for a rate plan.
     * - use: optional
     * @var int
     */
    public $MinTotalOccupancy;
    /**
     * The MaxTotalOccupancy
     * Meta information extracted from the WSDL
     * - documentation: Defines the maximum number of total occupants allowed for a rate plan.
     * - use: optional
     * @var int
     */
    public $MaxTotalOccupancy;
    /**
     * The MaxContiguousBookings
     * Meta information extracted from the WSDL
     * - documentation: The maximum number of times a rate may be booked contiguously within a reservation (often used with packages).
     * - use: optional
     * @var int
     */
    public $MaxContiguousBookings;
    /**
     * The MaxAdvancedBookingOffset
     * Meta information extracted from the WSDL
     * - documentation: Maximum days before the arrival date for which this offer may be booked.
     * - use: optional
     * @var string
     */
    public $MaxAdvancedBookingOffset;
    /**
     * The MinAdvancedBookingOffset
     * Meta information extracted from the WSDL
     * - documentation: Minimum days before the arrival date for which this offer may be booked.
     * - use: optional
     * @var string
     */
    public $MinAdvancedBookingOffset;
    /**
     * Constructor method for OfferRule
     * @uses OfferRule::setDateRestriction()
     * @uses OfferRule::setLengthsOfStay()
     * @uses OfferRule::setDOW_Restrictions()
     * @uses OfferRule::setOccupancy()
     * @uses OfferRule::setInventories()
     * @uses OfferRule::setStayOverDate()
     * @uses OfferRule::setMinTotalOccupancy()
     * @uses OfferRule::setMaxTotalOccupancy()
     * @uses OfferRule::setMaxContiguousBookings()
     * @uses OfferRule::setMaxAdvancedBookingOffset()
     * @uses OfferRule::setMinAdvancedBookingOffset()
     * @param \StructType\DateRestriction[] $dateRestriction
     * @param mixed $lengthsOfStay
     * @param mixed $dOW_Restrictions
     * @param \StructType\Occupancy[] $occupancy
     * @param \StructType\Inventories $inventories
     * @param string $stayOverDate
     * @param int $minTotalOccupancy
     * @param int $maxTotalOccupancy
     * @param int $maxContiguousBookings
     * @param string $maxAdvancedBookingOffset
     * @param string $minAdvancedBookingOffset
     */
    public function __construct(array $dateRestriction = array(), $lengthsOfStay = null, $dOW_Restrictions = null, array $occupancy = array(), \StructType\Inventories $inventories = null, $stayOverDate = null, $minTotalOccupancy = null, $maxTotalOccupancy = null, $maxContiguousBookings = null, $maxAdvancedBookingOffset = null, $minAdvancedBookingOffset = null)
    {
        $this
            ->setDateRestriction($dateRestriction)
            ->setLengthsOfStay($lengthsOfStay)
            ->setDOW_Restrictions($dOW_Restrictions)
            ->setOccupancy($occupancy)
            ->setInventories($inventories)
            ->setStayOverDate($stayOverDate)
            ->setMinTotalOccupancy($minTotalOccupancy)
            ->setMaxTotalOccupancy($maxTotalOccupancy)
            ->setMaxContiguousBookings($maxContiguousBookings)
            ->setMaxAdvancedBookingOffset($maxAdvancedBookingOffset)
            ->setMinAdvancedBookingOffset($minAdvancedBookingOffset);
    }
    /**
     * Get DateRestriction value
     * @return \StructType\DateRestriction[]|null
     */
    public function getDateRestriction()
    {
        return $this->DateRestriction;
    }
    /**
     * This method is responsible for validating the values passed to the setDateRestriction method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDateRestriction method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDateRestrictionForArrayConstraintsFromSetDateRestriction(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $offerRuleDateRestrictionItem) {
            // validation for constraint: itemType
            if (!$offerRuleDateRestrictionItem instanceof \StructType\DateRestriction) {
                $invalidValues[] = is_object($offerRuleDateRestrictionItem) ? get_class($offerRuleDateRestrictionItem) : sprintf('%s(%s)', gettype($offerRuleDateRestrictionItem), var_export($offerRuleDateRestrictionItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The DateRestriction property can only contain items of type \StructType\DateRestriction, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set DateRestriction value
     * @throws \InvalidArgumentException
     * @param \StructType\DateRestriction[] $dateRestriction
     * @return \StructType\OfferRule
     */
    public function setDateRestriction(array $dateRestriction = array())
    {
        // validation for constraint: array
        if ('' !== ($dateRestrictionArrayErrorMessage = self::validateDateRestrictionForArrayConstraintsFromSetDateRestriction($dateRestriction))) {
            throw new \InvalidArgumentException($dateRestrictionArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(5)
        if (is_array($dateRestriction) && count($dateRestriction) > 5) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 5', count($dateRestriction)), __LINE__);
        }
        $this->DateRestriction = $dateRestriction;
        return $this;
    }
    /**
     * Add item to DateRestriction value
     * @throws \InvalidArgumentException
     * @param \StructType\DateRestriction $item
     * @return \StructType\OfferRule
     */
    public function addToDateRestriction(\StructType\DateRestriction $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\DateRestriction) {
            throw new \InvalidArgumentException(sprintf('The DateRestriction property can only contain items of type \StructType\DateRestriction, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(5)
        if (is_array($this->DateRestriction) && count($this->DateRestriction) >= 5) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 5', count($this->DateRestriction)), __LINE__);
        }
        $this->DateRestriction[] = $item;
        return $this;
    }
    /**
     * Get LengthsOfStay value
     * @return mixed|null
     */
    public function getLengthsOfStay()
    {
        return $this->LengthsOfStay;
    }
    /**
     * Set LengthsOfStay value
     * @param mixed $lengthsOfStay
     * @return \StructType\OfferRule
     */
    public function setLengthsOfStay($lengthsOfStay = null)
    {
        $this->LengthsOfStay = $lengthsOfStay;
        return $this;
    }
    /**
     * Get DOW_Restrictions value
     * @return mixed|null
     */
    public function getDOW_Restrictions()
    {
        return $this->DOW_Restrictions;
    }
    /**
     * Set DOW_Restrictions value
     * @param mixed $dOW_Restrictions
     * @return \StructType\OfferRule
     */
    public function setDOW_Restrictions($dOW_Restrictions = null)
    {
        $this->DOW_Restrictions = $dOW_Restrictions;
        return $this;
    }
    /**
     * Get Occupancy value
     * @return \StructType\Occupancy[]|null
     */
    public function getOccupancy()
    {
        return $this->Occupancy;
    }
    /**
     * This method is responsible for validating the values passed to the setOccupancy method
     * This method is willingly generated in order to preserve the one-line inline validation within the setOccupancy method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateOccupancyForArrayConstraintsFromSetOccupancy(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $offerRuleOccupancyItem) {
            // validation for constraint: itemType
            if (!$offerRuleOccupancyItem instanceof \StructType\Occupancy) {
                $invalidValues[] = is_object($offerRuleOccupancyItem) ? get_class($offerRuleOccupancyItem) : sprintf('%s(%s)', gettype($offerRuleOccupancyItem), var_export($offerRuleOccupancyItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Occupancy property can only contain items of type \StructType\Occupancy, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Occupancy value
     * @throws \InvalidArgumentException
     * @param \StructType\Occupancy[] $occupancy
     * @return \StructType\OfferRule
     */
    public function setOccupancy(array $occupancy = array())
    {
        // validation for constraint: array
        if ('' !== ($occupancyArrayErrorMessage = self::validateOccupancyForArrayConstraintsFromSetOccupancy($occupancy))) {
            throw new \InvalidArgumentException($occupancyArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(5)
        if (is_array($occupancy) && count($occupancy) > 5) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 5', count($occupancy)), __LINE__);
        }
        $this->Occupancy = $occupancy;
        return $this;
    }
    /**
     * Add item to Occupancy value
     * @throws \InvalidArgumentException
     * @param \StructType\Occupancy $item
     * @return \StructType\OfferRule
     */
    public function addToOccupancy(\StructType\Occupancy $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Occupancy) {
            throw new \InvalidArgumentException(sprintf('The Occupancy property can only contain items of type \StructType\Occupancy, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(5)
        if (is_array($this->Occupancy) && count($this->Occupancy) >= 5) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 5', count($this->Occupancy)), __LINE__);
        }
        $this->Occupancy[] = $item;
        return $this;
    }
    /**
     * Get Inventories value
     * @return \StructType\Inventories|null
     */
    public function getInventories()
    {
        return $this->Inventories;
    }
    /**
     * Set Inventories value
     * @param \StructType\Inventories $inventories
     * @return \StructType\OfferRule
     */
    public function setInventories(\StructType\Inventories $inventories = null)
    {
        $this->Inventories = $inventories;
        return $this;
    }
    /**
     * Get StayOverDate value
     * @return string|null
     */
    public function getStayOverDate()
    {
        return $this->StayOverDate;
    }
    /**
     * Set StayOverDate value
     * @uses \EnumType\DayOfWeekType::valueIsValid()
     * @uses \EnumType\DayOfWeekType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $stayOverDate
     * @return \StructType\OfferRule
     */
    public function setStayOverDate($stayOverDate = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\DayOfWeekType::valueIsValid($stayOverDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\DayOfWeekType', is_array($stayOverDate) ? implode(', ', $stayOverDate) : var_export($stayOverDate, true), implode(', ', \EnumType\DayOfWeekType::getValidValues())), __LINE__);
        }
        $this->StayOverDate = $stayOverDate;
        return $this;
    }
    /**
     * Get MinTotalOccupancy value
     * @return int|null
     */
    public function getMinTotalOccupancy()
    {
        return $this->MinTotalOccupancy;
    }
    /**
     * Set MinTotalOccupancy value
     * @param int $minTotalOccupancy
     * @return \StructType\OfferRule
     */
    public function setMinTotalOccupancy($minTotalOccupancy = null)
    {
        // validation for constraint: int
        if (!is_null($minTotalOccupancy) && !(is_int($minTotalOccupancy) || ctype_digit($minTotalOccupancy))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($minTotalOccupancy, true), gettype($minTotalOccupancy)), __LINE__);
        }
        $this->MinTotalOccupancy = $minTotalOccupancy;
        return $this;
    }
    /**
     * Get MaxTotalOccupancy value
     * @return int|null
     */
    public function getMaxTotalOccupancy()
    {
        return $this->MaxTotalOccupancy;
    }
    /**
     * Set MaxTotalOccupancy value
     * @param int $maxTotalOccupancy
     * @return \StructType\OfferRule
     */
    public function setMaxTotalOccupancy($maxTotalOccupancy = null)
    {
        // validation for constraint: int
        if (!is_null($maxTotalOccupancy) && !(is_int($maxTotalOccupancy) || ctype_digit($maxTotalOccupancy))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($maxTotalOccupancy, true), gettype($maxTotalOccupancy)), __LINE__);
        }
        $this->MaxTotalOccupancy = $maxTotalOccupancy;
        return $this;
    }
    /**
     * Get MaxContiguousBookings value
     * @return int|null
     */
    public function getMaxContiguousBookings()
    {
        return $this->MaxContiguousBookings;
    }
    /**
     * Set MaxContiguousBookings value
     * @param int $maxContiguousBookings
     * @return \StructType\OfferRule
     */
    public function setMaxContiguousBookings($maxContiguousBookings = null)
    {
        // validation for constraint: int
        if (!is_null($maxContiguousBookings) && !(is_int($maxContiguousBookings) || ctype_digit($maxContiguousBookings))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($maxContiguousBookings, true), gettype($maxContiguousBookings)), __LINE__);
        }
        $this->MaxContiguousBookings = $maxContiguousBookings;
        return $this;
    }
    /**
     * Get MaxAdvancedBookingOffset value
     * @return string|null
     */
    public function getMaxAdvancedBookingOffset()
    {
        return $this->MaxAdvancedBookingOffset;
    }
    /**
     * Set MaxAdvancedBookingOffset value
     * @param string $maxAdvancedBookingOffset
     * @return \StructType\OfferRule
     */
    public function setMaxAdvancedBookingOffset($maxAdvancedBookingOffset = null)
    {
        // validation for constraint: string
        if (!is_null($maxAdvancedBookingOffset) && !is_string($maxAdvancedBookingOffset)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($maxAdvancedBookingOffset, true), gettype($maxAdvancedBookingOffset)), __LINE__);
        }
        $this->MaxAdvancedBookingOffset = $maxAdvancedBookingOffset;
        return $this;
    }
    /**
     * Get MinAdvancedBookingOffset value
     * @return string|null
     */
    public function getMinAdvancedBookingOffset()
    {
        return $this->MinAdvancedBookingOffset;
    }
    /**
     * Set MinAdvancedBookingOffset value
     * @param string $minAdvancedBookingOffset
     * @return \StructType\OfferRule
     */
    public function setMinAdvancedBookingOffset($minAdvancedBookingOffset = null)
    {
        // validation for constraint: string
        if (!is_null($minAdvancedBookingOffset) && !is_string($minAdvancedBookingOffset)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($minAdvancedBookingOffset, true), gettype($minAdvancedBookingOffset)), __LINE__);
        }
        $this->MinAdvancedBookingOffset = $minAdvancedBookingOffset;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\OfferRule
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
