<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Offer StructType
 * Meta information extracted from the WSDL
 * - documentation: One offer type. | Source from which members can receive information. | An individual offer, which defines the type of offer, the conditions under which it can be applied and the amounts and/or percentages deducted. | Requested offer.
 * @subpackage Structs
 */
class Offer extends \EnumType\List_OfferTypesRequested
{
    /**
     * The Communication
     * Meta information extracted from the WSDL
     * - maxOccurs: 5
     * - minOccurs: 0
     * @var \StructType\Communication[]
     */
    public $Communication;
    /**
     * The Type
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $Type;
    /**
     * The ExcludeInd
     * Meta information extracted from the WSDL
     * - documentation: Implementer: If true, this offer type should NOT be included in the response. | Example: true | Exclude offer type indicator.
     * - use: optional
     * @var bool
     */
    public $ExcludeInd;
    /**
     * The OtherType
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - pattern: [a-zA-Z0-9]{1,64}
     * - use: optional
     * @var string
     */
    public $OtherType;
    /**
     * The OntologyRefID
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - pattern: [0-9]{1,8}
     * - use: optional
     * @var string
     */
    public $OntologyRefID;
    /**
     * The SupplementRPH
     * Meta information extracted from the WSDL
     * - documentation: Identifies one or more supplements applicable to this offer.
     * - use: optional
     * @var list
     */
    public $SupplementRPH;
    /**
     * The OfferCode
     * Meta information extracted from the WSDL
     * - documentation: A string value used to request a particular offer. | Used for Character Strings, length 1 to 16.
     * - base: xs:string
     * - maxLength: 16
     * - minLength: 1
     * - use: optional
     * @var string
     */
    public $OfferCode;
    /**
     * Constructor method for Offer
     * @uses Offer::setCommunication()
     * @uses Offer::setType()
     * @uses Offer::setExcludeInd()
     * @uses Offer::setOtherType()
     * @uses Offer::setOntologyRefID()
     * @uses Offer::setSupplementRPH()
     * @uses Offer::setOfferCode()
     * @param \StructType\Communication[] $communication
     * @param string $type
     * @param bool $excludeInd
     * @param string $otherType
     * @param string $ontologyRefID
     * @param list $supplementRPH
     * @param string $offerCode
     */
    public function __construct(array $communication = array(), $type = null, $excludeInd = null, $otherType = null, $ontologyRefID = null, list $supplementRPH = null, $offerCode = null)
    {
        $this
            ->setCommunication($communication)
            ->setType($type)
            ->setExcludeInd($excludeInd)
            ->setOtherType($otherType)
            ->setOntologyRefID($ontologyRefID)
            ->setSupplementRPH($supplementRPH)
            ->setOfferCode($offerCode);
    }
    /**
     * Get Communication value
     * @return \StructType\Communication[]|null
     */
    public function getCommunication()
    {
        return $this->Communication;
    }
    /**
     * This method is responsible for validating the values passed to the setCommunication method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCommunication method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCommunicationForArrayConstraintsFromSetCommunication(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $offerCommunicationItem) {
            // validation for constraint: itemType
            if (!$offerCommunicationItem instanceof \StructType\Communication) {
                $invalidValues[] = is_object($offerCommunicationItem) ? get_class($offerCommunicationItem) : sprintf('%s(%s)', gettype($offerCommunicationItem), var_export($offerCommunicationItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Communication property can only contain items of type \StructType\Communication, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Communication value
     * @throws \InvalidArgumentException
     * @param \StructType\Communication[] $communication
     * @return \StructType\Offer
     */
    public function setCommunication(array $communication = array())
    {
        // validation for constraint: array
        if ('' !== ($communicationArrayErrorMessage = self::validateCommunicationForArrayConstraintsFromSetCommunication($communication))) {
            throw new \InvalidArgumentException($communicationArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(5)
        if (is_array($communication) && count($communication) > 5) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 5', count($communication)), __LINE__);
        }
        $this->Communication = $communication;
        return $this;
    }
    /**
     * Add item to Communication value
     * @throws \InvalidArgumentException
     * @param \StructType\Communication $item
     * @return \StructType\Offer
     */
    public function addToCommunication(\StructType\Communication $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Communication) {
            throw new \InvalidArgumentException(sprintf('The Communication property can only contain items of type \StructType\Communication, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(5)
        if (is_array($this->Communication) && count($this->Communication) >= 5) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 5', count($this->Communication)), __LINE__);
        }
        $this->Communication[] = $item;
        return $this;
    }
    /**
     * Get Type value
     * @return string|null
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @param string $type
     * @return \StructType\Offer
     */
    public function setType($type = null)
    {
        // validation for constraint: string
        if (!is_null($type) && !is_string($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($type, true), gettype($type)), __LINE__);
        }
        $this->Type = $type;
        return $this;
    }
    /**
     * Get ExcludeInd value
     * @return bool|null
     */
    public function getExcludeInd()
    {
        return $this->ExcludeInd;
    }
    /**
     * Set ExcludeInd value
     * @param bool $excludeInd
     * @return \StructType\Offer
     */
    public function setExcludeInd($excludeInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($excludeInd) && !is_bool($excludeInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($excludeInd, true), gettype($excludeInd)), __LINE__);
        }
        $this->ExcludeInd = $excludeInd;
        return $this;
    }
    /**
     * Get OtherType value
     * @return string|null
     */
    public function getOtherType()
    {
        return $this->OtherType;
    }
    /**
     * Set OtherType value
     * @param string $otherType
     * @return \StructType\Offer
     */
    public function setOtherType($otherType = null)
    {
        // validation for constraint: string
        if (!is_null($otherType) && !is_string($otherType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($otherType, true), gettype($otherType)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{1,64})
        if (!is_null($otherType) && !preg_match('/[a-zA-Z0-9]{1,64}/', $otherType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{1,64}', var_export($otherType, true)), __LINE__);
        }
        $this->OtherType = $otherType;
        return $this;
    }
    /**
     * Get OntologyRefID value
     * @return string|null
     */
    public function getOntologyRefID()
    {
        return $this->OntologyRefID;
    }
    /**
     * Set OntologyRefID value
     * @param string $ontologyRefID
     * @return \StructType\Offer
     */
    public function setOntologyRefID($ontologyRefID = null)
    {
        // validation for constraint: string
        if (!is_null($ontologyRefID) && !is_string($ontologyRefID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ontologyRefID, true), gettype($ontologyRefID)), __LINE__);
        }
        // validation for constraint: pattern([0-9]{1,8})
        if (!is_null($ontologyRefID) && !preg_match('/[0-9]{1,8}/', $ontologyRefID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9]{1,8}', var_export($ontologyRefID, true)), __LINE__);
        }
        $this->OntologyRefID = $ontologyRefID;
        return $this;
    }
    /**
     * Get SupplementRPH value
     * @return list|null
     */
    public function getSupplementRPH()
    {
        return $this->SupplementRPH;
    }
    /**
     * Set SupplementRPH value
     * @param list $supplementRPH
     * @return \StructType\Offer
     */
    public function setSupplementRPH(list $supplementRPH = null)
    {
        $this->SupplementRPH = $supplementRPH;
        return $this;
    }
    /**
     * Get OfferCode value
     * @return string|null
     */
    public function getOfferCode()
    {
        return $this->OfferCode;
    }
    /**
     * Set OfferCode value
     * @param string $offerCode
     * @return \StructType\Offer
     */
    public function setOfferCode($offerCode = null)
    {
        // validation for constraint: string
        if (!is_null($offerCode) && !is_string($offerCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($offerCode, true), gettype($offerCode)), __LINE__);
        }
        // validation for constraint: maxLength(16)
        if (!is_null($offerCode) && mb_strlen($offerCode) > 16) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 16', mb_strlen($offerCode)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($offerCode) && mb_strlen($offerCode) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($offerCode)), __LINE__);
        }
        $this->OfferCode = $offerCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Offer
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
