<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OTA_ReadRQ StructType
 * Meta information extracted from the WSDL
 * - documentation: Used to indicate a maximum number of items desired in the list response message or when used for subsequent retrievals of additional data the MoreDataEchoToken determines where to continue the list. | A generic message, available as
 * an action on several OpenTravel services which requests a server to read and return the document type identified by the UniqueID element.
 * @subpackage Structs
 */
class OTA_ReadRQ extends AbstractStructBase
{
    /**
     * The POS
     * Meta information extracted from the WSDL
     * - documentation: Point of Sale Identification for the transaction initiator that includes the identification information of the party that has made the reservation request and optional information, such as an agency number assigned by IATA, ARC, ESRP
     * or TID.
     * - minOccurs: 0
     * @var \StructType\POS_Type
     */
    public $POS;
    /**
     * The UniqueID
     * Meta information extracted from the WSDL
     * - documentation: A reference to identify the booking.
     * - minOccurs: 0
     * @var \StructType\UniqueID_Type
     */
    public $UniqueID;
    /**
     * The ReadRequests
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ReadRequests
     */
    public $ReadRequests;
    /**
     * The ReservationType
     * Meta information extracted from the WSDL
     * - documentation: To specify the type of reservation, Global, Air, Hotel, Car, Package, or Golf, that is being requested. Refer to OpenTravel Code List Travel Sector (TVS). | Used for codes in the OpenTravel Code tables. Possible values of this
     * pattern are 1, 101, 101.EQP, or 101.EQP.X.
     * - base: xs:string
     * - pattern: [0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1}
     * - use: optional
     * @var string
     */
    public $ReservationType;
    /**
     * The ReturnListIndicator
     * Meta information extracted from the WSDL
     * - documentation: To indicate if a list should always be returned even when only one reservation matches the input criteria. The default is to return the reservation record. If set to true, then always return a list.
     * - use: optional
     * @var bool
     */
    public $ReturnListIndicator;
    /**
     * The EchoToken
     * @var string
     */
    public $EchoToken;
    /**
     * The TimeStamp
     * @var string
     */
    public $TimeStamp;
    /**
     * The Target
     * @var string
     */
    public $Target;
    /**
     * The TargetName
     * @var string
     */
    public $TargetName;
    /**
     * The Version
     * @var float
     */
    public $Version;
    /**
     * The TransactionIdentifier
     * @var string
     */
    public $TransactionIdentifier;
    /**
     * The SequenceNmbr
     * @var int
     */
    public $SequenceNmbr;
    /**
     * The TransactionStatusCode
     * @var string
     */
    public $TransactionStatusCode;
    /**
     * The RetransmissionIndicator
     * @var bool
     */
    public $RetransmissionIndicator;
    /**
     * The CorrelationID
     * @var string
     */
    public $CorrelationID;
    /**
     * The PrimaryLangID
     * @var string
     */
    public $PrimaryLangID;
    /**
     * The AltLangID
     * @var string
     */
    public $AltLangID;
    /**
     * The ReqRespVersion
     * @var string
     */
    public $ReqRespVersion;
    /**
     * The MoreIndicator
     * @var bool
     */
    public $MoreIndicator;
    /**
     * The MoreDataEchoToken
     * @var string
     */
    public $MoreDataEchoToken;
    /**
     * The MaxResponses
     * @var int
     */
    public $MaxResponses;
    /**
     * Constructor method for OTA_ReadRQ
     * @uses OTA_ReadRQ::setPOS()
     * @uses OTA_ReadRQ::setUniqueID()
     * @uses OTA_ReadRQ::setReadRequests()
     * @uses OTA_ReadRQ::setReservationType()
     * @uses OTA_ReadRQ::setReturnListIndicator()
     * @uses OTA_ReadRQ::setEchoToken()
     * @uses OTA_ReadRQ::setTimeStamp()
     * @uses OTA_ReadRQ::setTarget()
     * @uses OTA_ReadRQ::setTargetName()
     * @uses OTA_ReadRQ::setVersion()
     * @uses OTA_ReadRQ::setTransactionIdentifier()
     * @uses OTA_ReadRQ::setSequenceNmbr()
     * @uses OTA_ReadRQ::setTransactionStatusCode()
     * @uses OTA_ReadRQ::setRetransmissionIndicator()
     * @uses OTA_ReadRQ::setCorrelationID()
     * @uses OTA_ReadRQ::setPrimaryLangID()
     * @uses OTA_ReadRQ::setAltLangID()
     * @uses OTA_ReadRQ::setReqRespVersion()
     * @uses OTA_ReadRQ::setMoreIndicator()
     * @uses OTA_ReadRQ::setMoreDataEchoToken()
     * @uses OTA_ReadRQ::setMaxResponses()
     * @param \StructType\POS_Type $pOS
     * @param \StructType\UniqueID_Type $uniqueID
     * @param \StructType\ReadRequests $readRequests
     * @param string $reservationType
     * @param bool $returnListIndicator
     * @param string $echoToken
     * @param string $timeStamp
     * @param string $target
     * @param string $targetName
     * @param float $version
     * @param string $transactionIdentifier
     * @param int $sequenceNmbr
     * @param string $transactionStatusCode
     * @param bool $retransmissionIndicator
     * @param string $correlationID
     * @param string $primaryLangID
     * @param string $altLangID
     * @param string $reqRespVersion
     * @param bool $moreIndicator
     * @param string $moreDataEchoToken
     * @param int $maxResponses
     */
    public function __construct(\StructType\POS_Type $pOS = null, \StructType\UniqueID_Type $uniqueID = null, \StructType\ReadRequests $readRequests = null, $reservationType = null, $returnListIndicator = null, $echoToken = null, $timeStamp = null, $target = null, $targetName = null, $version = null, $transactionIdentifier = null, $sequenceNmbr = null, $transactionStatusCode = null, $retransmissionIndicator = null, $correlationID = null, $primaryLangID = null, $altLangID = null, $reqRespVersion = null, $moreIndicator = null, $moreDataEchoToken = null, $maxResponses = null)
    {
        $this
            ->setPOS($pOS)
            ->setUniqueID($uniqueID)
            ->setReadRequests($readRequests)
            ->setReservationType($reservationType)
            ->setReturnListIndicator($returnListIndicator)
            ->setEchoToken($echoToken)
            ->setTimeStamp($timeStamp)
            ->setTarget($target)
            ->setTargetName($targetName)
            ->setVersion($version)
            ->setTransactionIdentifier($transactionIdentifier)
            ->setSequenceNmbr($sequenceNmbr)
            ->setTransactionStatusCode($transactionStatusCode)
            ->setRetransmissionIndicator($retransmissionIndicator)
            ->setCorrelationID($correlationID)
            ->setPrimaryLangID($primaryLangID)
            ->setAltLangID($altLangID)
            ->setReqRespVersion($reqRespVersion)
            ->setMoreIndicator($moreIndicator)
            ->setMoreDataEchoToken($moreDataEchoToken)
            ->setMaxResponses($maxResponses);
    }
    /**
     * Get POS value
     * @return \StructType\POS_Type|null
     */
    public function getPOS()
    {
        return $this->POS;
    }
    /**
     * Set POS value
     * @param \StructType\POS_Type $pOS
     * @return \StructType\OTA_ReadRQ
     */
    public function setPOS(\StructType\POS_Type $pOS = null)
    {
        $this->POS = $pOS;
        return $this;
    }
    /**
     * Get UniqueID value
     * @return \StructType\UniqueID_Type|null
     */
    public function getUniqueID()
    {
        return $this->UniqueID;
    }
    /**
     * Set UniqueID value
     * @param \StructType\UniqueID_Type $uniqueID
     * @return \StructType\OTA_ReadRQ
     */
    public function setUniqueID(\StructType\UniqueID_Type $uniqueID = null)
    {
        $this->UniqueID = $uniqueID;
        return $this;
    }
    /**
     * Get ReadRequests value
     * @return \StructType\ReadRequests|null
     */
    public function getReadRequests()
    {
        return $this->ReadRequests;
    }
    /**
     * Set ReadRequests value
     * @param \StructType\ReadRequests $readRequests
     * @return \StructType\OTA_ReadRQ
     */
    public function setReadRequests(\StructType\ReadRequests $readRequests = null)
    {
        $this->ReadRequests = $readRequests;
        return $this;
    }
    /**
     * Get ReservationType value
     * @return string|null
     */
    public function getReservationType()
    {
        return $this->ReservationType;
    }
    /**
     * Set ReservationType value
     * @param string $reservationType
     * @return \StructType\OTA_ReadRQ
     */
    public function setReservationType($reservationType = null)
    {
        // validation for constraint: string
        if (!is_null($reservationType) && !is_string($reservationType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reservationType, true), gettype($reservationType)), __LINE__);
        }
        // validation for constraint: pattern([0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1})
        if (!is_null($reservationType) && !preg_match('/[0-9A-Z]{1,3}(\\.[A-Z]{3}(\\.X){0,1}){0,1}/', $reservationType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1}', var_export($reservationType, true)), __LINE__);
        }
        $this->ReservationType = $reservationType;
        return $this;
    }
    /**
     * Get ReturnListIndicator value
     * @return bool|null
     */
    public function getReturnListIndicator()
    {
        return $this->ReturnListIndicator;
    }
    /**
     * Set ReturnListIndicator value
     * @param bool $returnListIndicator
     * @return \StructType\OTA_ReadRQ
     */
    public function setReturnListIndicator($returnListIndicator = null)
    {
        // validation for constraint: boolean
        if (!is_null($returnListIndicator) && !is_bool($returnListIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($returnListIndicator, true), gettype($returnListIndicator)), __LINE__);
        }
        $this->ReturnListIndicator = $returnListIndicator;
        return $this;
    }
    /**
     * Get EchoToken value
     * @return string|null
     */
    public function getEchoToken()
    {
        return $this->EchoToken;
    }
    /**
     * Set EchoToken value
     * @param string $echoToken
     * @return \StructType\OTA_ReadRQ
     */
    public function setEchoToken($echoToken = null)
    {
        // validation for constraint: string
        if (!is_null($echoToken) && !is_string($echoToken)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($echoToken, true), gettype($echoToken)), __LINE__);
        }
        $this->EchoToken = $echoToken;
        return $this;
    }
    /**
     * Get TimeStamp value
     * @return string|null
     */
    public function getTimeStamp()
    {
        return $this->TimeStamp;
    }
    /**
     * Set TimeStamp value
     * @param string $timeStamp
     * @return \StructType\OTA_ReadRQ
     */
    public function setTimeStamp($timeStamp = null)
    {
        // validation for constraint: string
        if (!is_null($timeStamp) && !is_string($timeStamp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($timeStamp, true), gettype($timeStamp)), __LINE__);
        }
        $this->TimeStamp = $timeStamp;
        return $this;
    }
    /**
     * Get Target value
     * @return string|null
     */
    public function getTarget()
    {
        return $this->Target;
    }
    /**
     * Set Target value
     * @param string $target
     * @return \StructType\OTA_ReadRQ
     */
    public function setTarget($target = null)
    {
        // validation for constraint: string
        if (!is_null($target) && !is_string($target)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($target, true), gettype($target)), __LINE__);
        }
        $this->Target = $target;
        return $this;
    }
    /**
     * Get TargetName value
     * @return string|null
     */
    public function getTargetName()
    {
        return $this->TargetName;
    }
    /**
     * Set TargetName value
     * @param string $targetName
     * @return \StructType\OTA_ReadRQ
     */
    public function setTargetName($targetName = null)
    {
        // validation for constraint: string
        if (!is_null($targetName) && !is_string($targetName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($targetName, true), gettype($targetName)), __LINE__);
        }
        $this->TargetName = $targetName;
        return $this;
    }
    /**
     * Get Version value
     * @return float|null
     */
    public function getVersion()
    {
        return $this->Version;
    }
    /**
     * Set Version value
     * @param float $version
     * @return \StructType\OTA_ReadRQ
     */
    public function setVersion($version = null)
    {
        // validation for constraint: float
        if (!is_null($version) && !(is_float($version) || is_numeric($version))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($version, true), gettype($version)), __LINE__);
        }
        $this->Version = $version;
        return $this;
    }
    /**
     * Get TransactionIdentifier value
     * @return string|null
     */
    public function getTransactionIdentifier()
    {
        return $this->TransactionIdentifier;
    }
    /**
     * Set TransactionIdentifier value
     * @param string $transactionIdentifier
     * @return \StructType\OTA_ReadRQ
     */
    public function setTransactionIdentifier($transactionIdentifier = null)
    {
        // validation for constraint: string
        if (!is_null($transactionIdentifier) && !is_string($transactionIdentifier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionIdentifier, true), gettype($transactionIdentifier)), __LINE__);
        }
        $this->TransactionIdentifier = $transactionIdentifier;
        return $this;
    }
    /**
     * Get SequenceNmbr value
     * @return int|null
     */
    public function getSequenceNmbr()
    {
        return $this->SequenceNmbr;
    }
    /**
     * Set SequenceNmbr value
     * @param int $sequenceNmbr
     * @return \StructType\OTA_ReadRQ
     */
    public function setSequenceNmbr($sequenceNmbr = null)
    {
        // validation for constraint: int
        if (!is_null($sequenceNmbr) && !(is_int($sequenceNmbr) || ctype_digit($sequenceNmbr))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($sequenceNmbr, true), gettype($sequenceNmbr)), __LINE__);
        }
        $this->SequenceNmbr = $sequenceNmbr;
        return $this;
    }
    /**
     * Get TransactionStatusCode value
     * @return string|null
     */
    public function getTransactionStatusCode()
    {
        return $this->TransactionStatusCode;
    }
    /**
     * Set TransactionStatusCode value
     * @param string $transactionStatusCode
     * @return \StructType\OTA_ReadRQ
     */
    public function setTransactionStatusCode($transactionStatusCode = null)
    {
        // validation for constraint: string
        if (!is_null($transactionStatusCode) && !is_string($transactionStatusCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionStatusCode, true), gettype($transactionStatusCode)), __LINE__);
        }
        $this->TransactionStatusCode = $transactionStatusCode;
        return $this;
    }
    /**
     * Get RetransmissionIndicator value
     * @return bool|null
     */
    public function getRetransmissionIndicator()
    {
        return $this->RetransmissionIndicator;
    }
    /**
     * Set RetransmissionIndicator value
     * @param bool $retransmissionIndicator
     * @return \StructType\OTA_ReadRQ
     */
    public function setRetransmissionIndicator($retransmissionIndicator = null)
    {
        // validation for constraint: boolean
        if (!is_null($retransmissionIndicator) && !is_bool($retransmissionIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($retransmissionIndicator, true), gettype($retransmissionIndicator)), __LINE__);
        }
        $this->RetransmissionIndicator = $retransmissionIndicator;
        return $this;
    }
    /**
     * Get CorrelationID value
     * @return string|null
     */
    public function getCorrelationID()
    {
        return $this->CorrelationID;
    }
    /**
     * Set CorrelationID value
     * @param string $correlationID
     * @return \StructType\OTA_ReadRQ
     */
    public function setCorrelationID($correlationID = null)
    {
        // validation for constraint: string
        if (!is_null($correlationID) && !is_string($correlationID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($correlationID, true), gettype($correlationID)), __LINE__);
        }
        $this->CorrelationID = $correlationID;
        return $this;
    }
    /**
     * Get PrimaryLangID value
     * @return string|null
     */
    public function getPrimaryLangID()
    {
        return $this->PrimaryLangID;
    }
    /**
     * Set PrimaryLangID value
     * @param string $primaryLangID
     * @return \StructType\OTA_ReadRQ
     */
    public function setPrimaryLangID($primaryLangID = null)
    {
        // validation for constraint: string
        if (!is_null($primaryLangID) && !is_string($primaryLangID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($primaryLangID, true), gettype($primaryLangID)), __LINE__);
        }
        $this->PrimaryLangID = $primaryLangID;
        return $this;
    }
    /**
     * Get AltLangID value
     * @return string|null
     */
    public function getAltLangID()
    {
        return $this->AltLangID;
    }
    /**
     * Set AltLangID value
     * @param string $altLangID
     * @return \StructType\OTA_ReadRQ
     */
    public function setAltLangID($altLangID = null)
    {
        // validation for constraint: string
        if (!is_null($altLangID) && !is_string($altLangID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($altLangID, true), gettype($altLangID)), __LINE__);
        }
        $this->AltLangID = $altLangID;
        return $this;
    }
    /**
     * Get ReqRespVersion value
     * @return string|null
     */
    public function getReqRespVersion()
    {
        return $this->ReqRespVersion;
    }
    /**
     * Set ReqRespVersion value
     * @param string $reqRespVersion
     * @return \StructType\OTA_ReadRQ
     */
    public function setReqRespVersion($reqRespVersion = null)
    {
        // validation for constraint: string
        if (!is_null($reqRespVersion) && !is_string($reqRespVersion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reqRespVersion, true), gettype($reqRespVersion)), __LINE__);
        }
        $this->ReqRespVersion = $reqRespVersion;
        return $this;
    }
    /**
     * Get MoreIndicator value
     * @return bool|null
     */
    public function getMoreIndicator()
    {
        return $this->MoreIndicator;
    }
    /**
     * Set MoreIndicator value
     * @param bool $moreIndicator
     * @return \StructType\OTA_ReadRQ
     */
    public function setMoreIndicator($moreIndicator = null)
    {
        // validation for constraint: boolean
        if (!is_null($moreIndicator) && !is_bool($moreIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($moreIndicator, true), gettype($moreIndicator)), __LINE__);
        }
        $this->MoreIndicator = $moreIndicator;
        return $this;
    }
    /**
     * Get MoreDataEchoToken value
     * @return string|null
     */
    public function getMoreDataEchoToken()
    {
        return $this->MoreDataEchoToken;
    }
    /**
     * Set MoreDataEchoToken value
     * @param string $moreDataEchoToken
     * @return \StructType\OTA_ReadRQ
     */
    public function setMoreDataEchoToken($moreDataEchoToken = null)
    {
        // validation for constraint: string
        if (!is_null($moreDataEchoToken) && !is_string($moreDataEchoToken)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($moreDataEchoToken, true), gettype($moreDataEchoToken)), __LINE__);
        }
        $this->MoreDataEchoToken = $moreDataEchoToken;
        return $this;
    }
    /**
     * Get MaxResponses value
     * @return int|null
     */
    public function getMaxResponses()
    {
        return $this->MaxResponses;
    }
    /**
     * Set MaxResponses value
     * @param int $maxResponses
     * @return \StructType\OTA_ReadRQ
     */
    public function setMaxResponses($maxResponses = null)
    {
        // validation for constraint: int
        if (!is_null($maxResponses) && !(is_int($maxResponses) || ctype_digit($maxResponses))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($maxResponses, true), gettype($maxResponses)), __LINE__);
        }
        $this->MaxResponses = $maxResponses;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\OTA_ReadRQ
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
