<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for NoShowFeeType StructType
 * Meta information extracted from the WSDL
 * - documentation: Information regarding the no show fee policy for a vehicle type.
 * @subpackage Structs
 */
class NoShowFeeType extends AbstractStructBase
{
    /**
     * The Deadline
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Deadline
     */
    public $Deadline;
    /**
     * The GracePeriod
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\GracePeriod
     */
    public $GracePeriod;
    /**
     * The FeeAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\FeeAmount
     */
    public $FeeAmount;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - documentation: A general text description of the no show fee policy that is suitable for display to the customer during the booking process.
     * - minOccurs: 0
     * @var mixed
     */
    public $Description;
    /**
     * Constructor method for NoShowFeeType
     * @uses NoShowFeeType::setDeadline()
     * @uses NoShowFeeType::setGracePeriod()
     * @uses NoShowFeeType::setFeeAmount()
     * @uses NoShowFeeType::setDescription()
     * @param \StructType\Deadline $deadline
     * @param \StructType\GracePeriod $gracePeriod
     * @param \StructType\FeeAmount $feeAmount
     * @param mixed $description
     */
    public function __construct(\StructType\Deadline $deadline = null, \StructType\GracePeriod $gracePeriod = null, \StructType\FeeAmount $feeAmount = null, $description = null)
    {
        $this
            ->setDeadline($deadline)
            ->setGracePeriod($gracePeriod)
            ->setFeeAmount($feeAmount)
            ->setDescription($description);
    }
    /**
     * Get Deadline value
     * @return \StructType\Deadline|null
     */
    public function getDeadline()
    {
        return $this->Deadline;
    }
    /**
     * Set Deadline value
     * @param \StructType\Deadline $deadline
     * @return \StructType\NoShowFeeType
     */
    public function setDeadline(\StructType\Deadline $deadline = null)
    {
        $this->Deadline = $deadline;
        return $this;
    }
    /**
     * Get GracePeriod value
     * @return \StructType\GracePeriod|null
     */
    public function getGracePeriod()
    {
        return $this->GracePeriod;
    }
    /**
     * Set GracePeriod value
     * @param \StructType\GracePeriod $gracePeriod
     * @return \StructType\NoShowFeeType
     */
    public function setGracePeriod(\StructType\GracePeriod $gracePeriod = null)
    {
        $this->GracePeriod = $gracePeriod;
        return $this;
    }
    /**
     * Get FeeAmount value
     * @return \StructType\FeeAmount|null
     */
    public function getFeeAmount()
    {
        return $this->FeeAmount;
    }
    /**
     * Set FeeAmount value
     * @param \StructType\FeeAmount $feeAmount
     * @return \StructType\NoShowFeeType
     */
    public function setFeeAmount(\StructType\FeeAmount $feeAmount = null)
    {
        $this->FeeAmount = $feeAmount;
        return $this;
    }
    /**
     * Get Description value
     * @return mixed|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param mixed $description
     * @return \StructType\NoShowFeeType
     */
    public function setDescription($description = null)
    {
        $this->Description = $description;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\NoShowFeeType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
