<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Name StructType
 * Meta information extracted from the WSDL
 * - documentation: The ID attribute in this group is a unique identifying value assigned by the creating system and may be used to reference a primary-key value within a database or in a particular implementation. | The gender of the contact person in
 * the ContactName attribute. This may be useful for purposes of correspondence to the hotel. | Used to pass detailed name information regarding a contact. | This name refers to an OpenTravel Code List table (e.g. RestaurantCategoryCode/InfoCode). The
 * actual code is passed in the Code attribute. | Example: OpenTravel Car Ontology | Name. | The donor name.
 * - type: StringLength1to64
 * - use: optional
 * @subpackage Structs
 */
class Name extends PersonNameType
{
    /**
     * The JobTitle
     * Meta information extracted from the WSDL
     * - maxOccurs: 5
     * - minOccurs: 0
     * @var \StructType\JobTitle[]
     */
    public $JobTitle;
    /**
     * The SrvcCode
     * Meta information extracted from the WSDL
     * - documentation: The information describing the contact service code for a hotel facility. (e.g., who to contact about golf tours). Refer to OpenTravel Code List Contact Srvc Code (CSC).
     * - use: optional
     * @var string
     */
    public $SrvcCode;
    /**
     * The Location
     * Meta information extracted from the WSDL
     * - documentation: The location of the hotel contact. e.g.: at the hotel property, at a central office, etc. Refer to OpenTravel Code List Contact Location (CON).
     * - use: optional
     * @var string
     */
    public $Location;
    /**
     * The CorporatePosition
     * Meta information extracted from the WSDL
     * - documentation: The corporate position of the contact.
     * - use: optional
     * @var string
     */
    public $CorporatePosition;
    /**
     * The OKToPublish
     * Meta information extracted from the WSDL
     * - documentation: Values: 0 = No, Limited Publication, or 1 = Yes, OK for External Publication. | Indicates whether the contact information can be published externally (on a web site for the general public) or whether this is strictly a contact to be
     * used in conjunction with the data feed (limited use).
     * - use: optional
     * @var bool
     */
    public $OKToPublish;
    /**
     * The NameOrdered
     * Meta information extracted from the WSDL
     * - documentation: The proper name in the usual order (e.g. used for correspondance Mr. James Smith).
     * - use: optional
     * @var string
     */
    public $NameOrdered;
    /**
     * Constructor method for Name
     * @uses Name::setJobTitle()
     * @uses Name::setSrvcCode()
     * @uses Name::setLocation()
     * @uses Name::setCorporatePosition()
     * @uses Name::setOKToPublish()
     * @uses Name::setNameOrdered()
     * @param \StructType\JobTitle[] $jobTitle
     * @param string $srvcCode
     * @param string $location
     * @param string $corporatePosition
     * @param bool $oKToPublish
     * @param string $nameOrdered
     */
    public function __construct(array $jobTitle = array(), $srvcCode = null, $location = null, $corporatePosition = null, $oKToPublish = null, $nameOrdered = null)
    {
        $this
            ->setJobTitle($jobTitle)
            ->setSrvcCode($srvcCode)
            ->setLocation($location)
            ->setCorporatePosition($corporatePosition)
            ->setOKToPublish($oKToPublish)
            ->setNameOrdered($nameOrdered);
    }
    /**
     * Get JobTitle value
     * @return \StructType\JobTitle[]|null
     */
    public function getJobTitle()
    {
        return $this->JobTitle;
    }
    /**
     * This method is responsible for validating the values passed to the setJobTitle method
     * This method is willingly generated in order to preserve the one-line inline validation within the setJobTitle method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateJobTitleForArrayConstraintsFromSetJobTitle(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $nameJobTitleItem) {
            // validation for constraint: itemType
            if (!$nameJobTitleItem instanceof \StructType\JobTitle) {
                $invalidValues[] = is_object($nameJobTitleItem) ? get_class($nameJobTitleItem) : sprintf('%s(%s)', gettype($nameJobTitleItem), var_export($nameJobTitleItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The JobTitle property can only contain items of type \StructType\JobTitle, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set JobTitle value
     * @throws \InvalidArgumentException
     * @param \StructType\JobTitle[] $jobTitle
     * @return \StructType\Name
     */
    public function setJobTitle(array $jobTitle = array())
    {
        // validation for constraint: array
        if ('' !== ($jobTitleArrayErrorMessage = self::validateJobTitleForArrayConstraintsFromSetJobTitle($jobTitle))) {
            throw new \InvalidArgumentException($jobTitleArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(5)
        if (is_array($jobTitle) && count($jobTitle) > 5) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 5', count($jobTitle)), __LINE__);
        }
        $this->JobTitle = $jobTitle;
        return $this;
    }
    /**
     * Add item to JobTitle value
     * @throws \InvalidArgumentException
     * @param \StructType\JobTitle $item
     * @return \StructType\Name
     */
    public function addToJobTitle(\StructType\JobTitle $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\JobTitle) {
            throw new \InvalidArgumentException(sprintf('The JobTitle property can only contain items of type \StructType\JobTitle, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(5)
        if (is_array($this->JobTitle) && count($this->JobTitle) >= 5) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 5', count($this->JobTitle)), __LINE__);
        }
        $this->JobTitle[] = $item;
        return $this;
    }
    /**
     * Get SrvcCode value
     * @return string|null
     */
    public function getSrvcCode()
    {
        return $this->SrvcCode;
    }
    /**
     * Set SrvcCode value
     * @param string $srvcCode
     * @return \StructType\Name
     */
    public function setSrvcCode($srvcCode = null)
    {
        // validation for constraint: string
        if (!is_null($srvcCode) && !is_string($srvcCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($srvcCode, true), gettype($srvcCode)), __LINE__);
        }
        $this->SrvcCode = $srvcCode;
        return $this;
    }
    /**
     * Get Location value
     * @return string|null
     */
    public function getLocation()
    {
        return $this->Location;
    }
    /**
     * Set Location value
     * @param string $location
     * @return \StructType\Name
     */
    public function setLocation($location = null)
    {
        // validation for constraint: string
        if (!is_null($location) && !is_string($location)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($location, true), gettype($location)), __LINE__);
        }
        $this->Location = $location;
        return $this;
    }
    /**
     * Get CorporatePosition value
     * @return string|null
     */
    public function getCorporatePosition()
    {
        return $this->CorporatePosition;
    }
    /**
     * Set CorporatePosition value
     * @param string $corporatePosition
     * @return \StructType\Name
     */
    public function setCorporatePosition($corporatePosition = null)
    {
        // validation for constraint: string
        if (!is_null($corporatePosition) && !is_string($corporatePosition)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($corporatePosition, true), gettype($corporatePosition)), __LINE__);
        }
        $this->CorporatePosition = $corporatePosition;
        return $this;
    }
    /**
     * Get OKToPublish value
     * @return bool|null
     */
    public function getOKToPublish()
    {
        return $this->OKToPublish;
    }
    /**
     * Set OKToPublish value
     * @param bool $oKToPublish
     * @return \StructType\Name
     */
    public function setOKToPublish($oKToPublish = null)
    {
        // validation for constraint: boolean
        if (!is_null($oKToPublish) && !is_bool($oKToPublish)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($oKToPublish, true), gettype($oKToPublish)), __LINE__);
        }
        $this->OKToPublish = $oKToPublish;
        return $this;
    }
    /**
     * Get NameOrdered value
     * @return string|null
     */
    public function getNameOrdered()
    {
        return $this->NameOrdered;
    }
    /**
     * Set NameOrdered value
     * @param string $nameOrdered
     * @return \StructType\Name
     */
    public function setNameOrdered($nameOrdered = null)
    {
        // validation for constraint: string
        if (!is_null($nameOrdered) && !is_string($nameOrdered)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nameOrdered, true), gettype($nameOrdered)), __LINE__);
        }
        $this->NameOrdered = $nameOrdered;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Name
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
