<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MultimediaDescriptionType StructType
 * Meta information extracted from the WSDL
 * - documentation: A unique identifying value assigned by the creating system. The ID attribute may be used to reference a primary-key value within a database or in a particular implementation. | Describes multimedia item(s).
 * @subpackage Structs
 */
class MultimediaDescriptionType extends AbstractStructBase
{
    /**
     * The VideoItems
     * Meta information extracted from the WSDL
     * - documentation: A collection of video items.
     * - choice: VideoItems | ImageItems | TextItems
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 0
     * - minOccurs: 0
     * @var mixed
     */
    public $VideoItems;
    /**
     * The ImageItems
     * Meta information extracted from the WSDL
     * - documentation: A collection of image items.
     * - choice: VideoItems | ImageItems | TextItems
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 0
     * - minOccurs: 0
     * @var mixed
     */
    public $ImageItems;
    /**
     * The TextItems
     * Meta information extracted from the WSDL
     * - documentation: A collection of text items.
     * - choice: VideoItems | ImageItems | TextItems
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 0
     * - minOccurs: 0
     * @var mixed
     */
    public $TextItems;
    /**
     * The InfoCode
     * Meta information extracted from the WSDL
     * - documentation: Used to designate a particular type of description such as marketing. Refer to OpenTravel Code List Information Type (INF).
     * - use: optional
     * @var string
     */
    public $InfoCode;
    /**
     * The AdditionalDetailCode
     * Meta information extracted from the WSDL
     * - documentation: Used to designate a particular type of additional information. Refer to OpenTravel Code List Additional Detail Type (ADT).
     * - use: optional
     * @var string
     */
    public $AdditionalDetailCode;
    /**
     * The LastUpdated
     * Meta information extracted from the WSDL
     * - documentation: The date and time when the multimedia information was last updated.
     * - use: optional
     * @var string
     */
    public $LastUpdated;
    /**
     * The Version
     * Meta information extracted from the WSDL
     * - documentation: The version of the content, typically in the form of "1" or "2.3."
     * - use: optional
     * @var string
     */
    public $Version;
    /**
     * Constructor method for MultimediaDescriptionType
     * @uses MultimediaDescriptionType::setVideoItems()
     * @uses MultimediaDescriptionType::setImageItems()
     * @uses MultimediaDescriptionType::setTextItems()
     * @uses MultimediaDescriptionType::setInfoCode()
     * @uses MultimediaDescriptionType::setAdditionalDetailCode()
     * @uses MultimediaDescriptionType::setLastUpdated()
     * @uses MultimediaDescriptionType::setVersion()
     * @param mixed $videoItems
     * @param mixed $imageItems
     * @param mixed $textItems
     * @param string $infoCode
     * @param string $additionalDetailCode
     * @param string $lastUpdated
     * @param string $version
     */
    public function __construct($videoItems = null, $imageItems = null, $textItems = null, $infoCode = null, $additionalDetailCode = null, $lastUpdated = null, $version = null)
    {
        $this
            ->setVideoItems($videoItems)
            ->setImageItems($imageItems)
            ->setTextItems($textItems)
            ->setInfoCode($infoCode)
            ->setAdditionalDetailCode($additionalDetailCode)
            ->setLastUpdated($lastUpdated)
            ->setVersion($version);
    }
    /**
     * Get VideoItems value
     * @return mixed|null
     */
    public function getVideoItems()
    {
        return isset($this->VideoItems) ? $this->VideoItems : null;
    }
    /**
     * This method is responsible for validating the value passed to the setVideoItems method
     * This method is willingly generated in order to preserve the one-line inline validation within the setVideoItems method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateVideoItemsForChoiceConstraintsFromSetVideoItems($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'ImageItems',
            'TextItems',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property VideoItems can\'t be set as the property %s is already set. Only one property must be set among these properties: VideoItems, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set VideoItems value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param mixed $videoItems
     * @return \StructType\MultimediaDescriptionType
     */
    public function setVideoItems($videoItems = null)
    {
        // validation for constraint: choice(VideoItems, ImageItems, TextItems)
        if ('' !== ($videoItemsChoiceErrorMessage = self::validateVideoItemsForChoiceConstraintsFromSetVideoItems($videoItems))) {
            throw new \InvalidArgumentException($videoItemsChoiceErrorMessage, __LINE__);
        }
        if (is_null($videoItems) || (is_array($videoItems) && empty($videoItems))) {
            unset($this->VideoItems);
        } else {
            $this->VideoItems = $videoItems;
        }
        return $this;
    }
    /**
     * Get ImageItems value
     * @return mixed|null
     */
    public function getImageItems()
    {
        return isset($this->ImageItems) ? $this->ImageItems : null;
    }
    /**
     * This method is responsible for validating the value passed to the setImageItems method
     * This method is willingly generated in order to preserve the one-line inline validation within the setImageItems method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateImageItemsForChoiceConstraintsFromSetImageItems($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'VideoItems',
            'TextItems',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property ImageItems can\'t be set as the property %s is already set. Only one property must be set among these properties: ImageItems, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set ImageItems value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param mixed $imageItems
     * @return \StructType\MultimediaDescriptionType
     */
    public function setImageItems($imageItems = null)
    {
        // validation for constraint: choice(VideoItems, ImageItems, TextItems)
        if ('' !== ($imageItemsChoiceErrorMessage = self::validateImageItemsForChoiceConstraintsFromSetImageItems($imageItems))) {
            throw new \InvalidArgumentException($imageItemsChoiceErrorMessage, __LINE__);
        }
        if (is_null($imageItems) || (is_array($imageItems) && empty($imageItems))) {
            unset($this->ImageItems);
        } else {
            $this->ImageItems = $imageItems;
        }
        return $this;
    }
    /**
     * Get TextItems value
     * @return mixed|null
     */
    public function getTextItems()
    {
        return isset($this->TextItems) ? $this->TextItems : null;
    }
    /**
     * This method is responsible for validating the value passed to the setTextItems method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTextItems method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateTextItemsForChoiceConstraintsFromSetTextItems($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'VideoItems',
            'ImageItems',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property TextItems can\'t be set as the property %s is already set. Only one property must be set among these properties: TextItems, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set TextItems value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param mixed $textItems
     * @return \StructType\MultimediaDescriptionType
     */
    public function setTextItems($textItems = null)
    {
        // validation for constraint: choice(VideoItems, ImageItems, TextItems)
        if ('' !== ($textItemsChoiceErrorMessage = self::validateTextItemsForChoiceConstraintsFromSetTextItems($textItems))) {
            throw new \InvalidArgumentException($textItemsChoiceErrorMessage, __LINE__);
        }
        if (is_null($textItems) || (is_array($textItems) && empty($textItems))) {
            unset($this->TextItems);
        } else {
            $this->TextItems = $textItems;
        }
        return $this;
    }
    /**
     * Get InfoCode value
     * @return string|null
     */
    public function getInfoCode()
    {
        return $this->InfoCode;
    }
    /**
     * Set InfoCode value
     * @param string $infoCode
     * @return \StructType\MultimediaDescriptionType
     */
    public function setInfoCode($infoCode = null)
    {
        // validation for constraint: string
        if (!is_null($infoCode) && !is_string($infoCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($infoCode, true), gettype($infoCode)), __LINE__);
        }
        $this->InfoCode = $infoCode;
        return $this;
    }
    /**
     * Get AdditionalDetailCode value
     * @return string|null
     */
    public function getAdditionalDetailCode()
    {
        return $this->AdditionalDetailCode;
    }
    /**
     * Set AdditionalDetailCode value
     * @param string $additionalDetailCode
     * @return \StructType\MultimediaDescriptionType
     */
    public function setAdditionalDetailCode($additionalDetailCode = null)
    {
        // validation for constraint: string
        if (!is_null($additionalDetailCode) && !is_string($additionalDetailCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($additionalDetailCode, true), gettype($additionalDetailCode)), __LINE__);
        }
        $this->AdditionalDetailCode = $additionalDetailCode;
        return $this;
    }
    /**
     * Get LastUpdated value
     * @return string|null
     */
    public function getLastUpdated()
    {
        return $this->LastUpdated;
    }
    /**
     * Set LastUpdated value
     * @param string $lastUpdated
     * @return \StructType\MultimediaDescriptionType
     */
    public function setLastUpdated($lastUpdated = null)
    {
        // validation for constraint: string
        if (!is_null($lastUpdated) && !is_string($lastUpdated)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastUpdated, true), gettype($lastUpdated)), __LINE__);
        }
        $this->LastUpdated = $lastUpdated;
        return $this;
    }
    /**
     * Get Version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->Version;
    }
    /**
     * Set Version value
     * @param string $version
     * @return \StructType\MultimediaDescriptionType
     */
    public function setVersion($version = null)
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($version, true), gettype($version)), __LINE__);
        }
        $this->Version = $version;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\MultimediaDescriptionType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
