<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Multimedia StructType
 * Meta information extracted from the WSDL
 * - documentation: Images, etc. of the ancillary item.
 * @subpackage Structs
 */
class Multimedia extends ImageDescriptionType
{
    /**
     * The Sequence
     * Meta information extracted from the WSDL
     * - documentation: The sequence order the image should be displayed in.
     * - use: optional
     * @var int
     */
    public $Sequence;
    /**
     * The ContentUsageType
     * Meta information extracted from the WSDL
     * - documentation: The name of a page or page section where the image should be displayed.
     * - use: optional
     * @var string
     */
    public $ContentUsageType;
    /**
     * Constructor method for Multimedia
     * @uses Multimedia::setSequence()
     * @uses Multimedia::setContentUsageType()
     * @param int $sequence
     * @param string $contentUsageType
     */
    public function __construct($sequence = null, $contentUsageType = null)
    {
        $this
            ->setSequence($sequence)
            ->setContentUsageType($contentUsageType);
    }
    /**
     * Get Sequence value
     * @return int|null
     */
    public function getSequence()
    {
        return $this->Sequence;
    }
    /**
     * Set Sequence value
     * @param int $sequence
     * @return \StructType\Multimedia
     */
    public function setSequence($sequence = null)
    {
        // validation for constraint: int
        if (!is_null($sequence) && !(is_int($sequence) || ctype_digit($sequence))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($sequence, true), gettype($sequence)), __LINE__);
        }
        $this->Sequence = $sequence;
        return $this;
    }
    /**
     * Get ContentUsageType value
     * @return string|null
     */
    public function getContentUsageType()
    {
        return $this->ContentUsageType;
    }
    /**
     * Set ContentUsageType value
     * @param string $contentUsageType
     * @return \StructType\Multimedia
     */
    public function setContentUsageType($contentUsageType = null)
    {
        // validation for constraint: string
        if (!is_null($contentUsageType) && !is_string($contentUsageType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($contentUsageType, true), gettype($contentUsageType)), __LINE__);
        }
        $this->ContentUsageType = $contentUsageType;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Multimedia
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
