<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MonetaryRuleType StructType
 * Meta information extracted from the WSDL
 * - documentation: Provides the currency amount pertaining to the rule. | This defines the information pertaining to rules and amounts associated with these rules. | Used for Character Strings, length 0 to 255.
 * - base: xs:string
 * - maxLength: 255
 * - minLength: 0
 * @subpackage Structs
 */
class MonetaryRuleType extends AbstractStructBase
{
    /**
     * The RuleType
     * Meta information extracted from the WSDL
     * - documentation: Refer to OpenTravel Code List Rule Type (RUL).
     * - use: required
     * @var string
     */
    public $RuleType;
    /**
     * The Percent
     * Meta information extracted from the WSDL
     * - documentation: The percent applicable to the monetary rule.
     * - use: optional
     * @var float
     */
    public $Percent;
    /**
     * The DateTime
     * Meta information extracted from the WSDL
     * - documentation: The date and time applicable to this monetary rule.
     * - use: optional
     * @var string
     */
    public $DateTime;
    /**
     * The PaymentType
     * Meta information extracted from the WSDL
     * - documentation: Refer to OpenTravel Code List Payment Type (PMT).
     * - use: optional
     * @var string
     */
    public $PaymentType;
    /**
     * The RateConvertedInd
     * Meta information extracted from the WSDL
     * - documentation: When true, indicates the amount was converted from another currency.
     * - use: optional
     * @var bool
     */
    public $RateConvertedInd;
    /**
     * Constructor method for MonetaryRuleType
     * @uses MonetaryRuleType::setRuleType()
     * @uses MonetaryRuleType::setPercent()
     * @uses MonetaryRuleType::setDateTime()
     * @uses MonetaryRuleType::setPaymentType()
     * @uses MonetaryRuleType::setRateConvertedInd()
     * @param string $ruleType
     * @param float $percent
     * @param string $dateTime
     * @param string $paymentType
     * @param bool $rateConvertedInd
     */
    public function __construct($ruleType = null, $percent = null, $dateTime = null, $paymentType = null, $rateConvertedInd = null)
    {
        $this
            ->setRuleType($ruleType)
            ->setPercent($percent)
            ->setDateTime($dateTime)
            ->setPaymentType($paymentType)
            ->setRateConvertedInd($rateConvertedInd);
    }
    /**
     * Get RuleType value
     * @return string
     */
    public function getRuleType()
    {
        return $this->RuleType;
    }
    /**
     * Set RuleType value
     * @param string $ruleType
     * @return \StructType\MonetaryRuleType
     */
    public function setRuleType($ruleType = null)
    {
        // validation for constraint: string
        if (!is_null($ruleType) && !is_string($ruleType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ruleType, true), gettype($ruleType)), __LINE__);
        }
        $this->RuleType = $ruleType;
        return $this;
    }
    /**
     * Get Percent value
     * @return float|null
     */
    public function getPercent()
    {
        return $this->Percent;
    }
    /**
     * Set Percent value
     * @param float $percent
     * @return \StructType\MonetaryRuleType
     */
    public function setPercent($percent = null)
    {
        // validation for constraint: float
        if (!is_null($percent) && !(is_float($percent) || is_numeric($percent))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($percent, true), gettype($percent)), __LINE__);
        }
        $this->Percent = $percent;
        return $this;
    }
    /**
     * Get DateTime value
     * @return string|null
     */
    public function getDateTime()
    {
        return $this->DateTime;
    }
    /**
     * Set DateTime value
     * @param string $dateTime
     * @return \StructType\MonetaryRuleType
     */
    public function setDateTime($dateTime = null)
    {
        // validation for constraint: string
        if (!is_null($dateTime) && !is_string($dateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dateTime, true), gettype($dateTime)), __LINE__);
        }
        $this->DateTime = $dateTime;
        return $this;
    }
    /**
     * Get PaymentType value
     * @return string|null
     */
    public function getPaymentType()
    {
        return $this->PaymentType;
    }
    /**
     * Set PaymentType value
     * @param string $paymentType
     * @return \StructType\MonetaryRuleType
     */
    public function setPaymentType($paymentType = null)
    {
        // validation for constraint: string
        if (!is_null($paymentType) && !is_string($paymentType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentType, true), gettype($paymentType)), __LINE__);
        }
        $this->PaymentType = $paymentType;
        return $this;
    }
    /**
     * Get RateConvertedInd value
     * @return bool|null
     */
    public function getRateConvertedInd()
    {
        return $this->RateConvertedInd;
    }
    /**
     * Set RateConvertedInd value
     * @param bool $rateConvertedInd
     * @return \StructType\MonetaryRuleType
     */
    public function setRateConvertedInd($rateConvertedInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($rateConvertedInd) && !is_bool($rateConvertedInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($rateConvertedInd, true), gettype($rateConvertedInd)), __LINE__);
        }
        $this->RateConvertedInd = $rateConvertedInd;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\MonetaryRuleType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
