<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MinMax StructType
 * Meta information extracted from the WSDL
 * - documentation: Information on any minimum or maximum amounts, if appropriate.
 * @subpackage Structs
 */
class MinMax extends AbstractStructBase
{
    /**
     * The MaxCharge
     * Meta information extracted from the WSDL
     * - documentation: The maximum amount that will be charged.
     * - use: optional
     * @var float
     */
    public $MaxCharge;
    /**
     * The MinCharge
     * Meta information extracted from the WSDL
     * - documentation: The minimum amount that will be charged.
     * - use: optional
     * @var float
     */
    public $MinCharge;
    /**
     * The MaxChargeDays
     * Meta information extracted from the WSDL
     * - documentation: Maximum number of days for which a charge will be applied.
     * - use: optional
     * @var int
     */
    public $MaxChargeDays;
    /**
     * Constructor method for MinMax
     * @uses MinMax::setMaxCharge()
     * @uses MinMax::setMinCharge()
     * @uses MinMax::setMaxChargeDays()
     * @param float $maxCharge
     * @param float $minCharge
     * @param int $maxChargeDays
     */
    public function __construct($maxCharge = null, $minCharge = null, $maxChargeDays = null)
    {
        $this
            ->setMaxCharge($maxCharge)
            ->setMinCharge($minCharge)
            ->setMaxChargeDays($maxChargeDays);
    }
    /**
     * Get MaxCharge value
     * @return float|null
     */
    public function getMaxCharge()
    {
        return $this->MaxCharge;
    }
    /**
     * Set MaxCharge value
     * @param float $maxCharge
     * @return \StructType\MinMax
     */
    public function setMaxCharge($maxCharge = null)
    {
        // validation for constraint: float
        if (!is_null($maxCharge) && !(is_float($maxCharge) || is_numeric($maxCharge))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($maxCharge, true), gettype($maxCharge)), __LINE__);
        }
        $this->MaxCharge = $maxCharge;
        return $this;
    }
    /**
     * Get MinCharge value
     * @return float|null
     */
    public function getMinCharge()
    {
        return $this->MinCharge;
    }
    /**
     * Set MinCharge value
     * @param float $minCharge
     * @return \StructType\MinMax
     */
    public function setMinCharge($minCharge = null)
    {
        // validation for constraint: float
        if (!is_null($minCharge) && !(is_float($minCharge) || is_numeric($minCharge))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($minCharge, true), gettype($minCharge)), __LINE__);
        }
        $this->MinCharge = $minCharge;
        return $this;
    }
    /**
     * Get MaxChargeDays value
     * @return int|null
     */
    public function getMaxChargeDays()
    {
        return $this->MaxChargeDays;
    }
    /**
     * Set MaxChargeDays value
     * @param int $maxChargeDays
     * @return \StructType\MinMax
     */
    public function setMaxChargeDays($maxChargeDays = null)
    {
        // validation for constraint: int
        if (!is_null($maxChargeDays) && !(is_int($maxChargeDays) || ctype_digit($maxChargeDays))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($maxChargeDays, true), gettype($maxChargeDays)), __LINE__);
        }
        $this->MaxChargeDays = $maxChargeDays;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\MinMax
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
