<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MessageType StructType
 * Meta information extracted from the WSDL
 * - documentation: If StartSeqNmbr and EndSeqNmbr are not sent, the request will be assumed to be for the last sequence number.
 * @subpackage Structs
 */
class MessageType extends AbstractStructBase
{
    /**
     * The OriginalPayloadStdAttributes
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\OriginalPayloadStdAttributes
     */
    public $OriginalPayloadStdAttributes;
    /**
     * The MessageContent
     * Meta information extracted from the WSDL
     * - documentation: This container is designed to store the response message.
     * - minOccurs: 0
     * @var string
     */
    public $MessageContent;
    /**
     * The StartSeqNmbr
     * Meta information extracted from the WSDL
     * - use: optional
     * @var int
     */
    public $StartSeqNmbr;
    /**
     * The EndSeqNmbr
     * Meta information extracted from the WSDL
     * - use: optional
     * @var int
     */
    public $EndSeqNmbr;
    /**
     * The MessageType
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $MessageType;
    /**
     * The ResponseValue
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $ResponseValue;
    /**
     * The RequestCode
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $RequestCode;
    /**
     * The ReasonForRequest
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $ReasonForRequest;
    /**
     * The UserName
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $UserName;
    /**
     * The RatePlanCode
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $RatePlanCode;
    /**
     * The ConfirmationID
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $ConfirmationID;
    /**
     * The ReservationID
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $ReservationID;
    /**
     * Constructor method for MessageType
     * @uses MessageType::setOriginalPayloadStdAttributes()
     * @uses MessageType::setMessageContent()
     * @uses MessageType::setStartSeqNmbr()
     * @uses MessageType::setEndSeqNmbr()
     * @uses MessageType::setMessageType()
     * @uses MessageType::setResponseValue()
     * @uses MessageType::setRequestCode()
     * @uses MessageType::setReasonForRequest()
     * @uses MessageType::setUserName()
     * @uses MessageType::setRatePlanCode()
     * @uses MessageType::setConfirmationID()
     * @uses MessageType::setReservationID()
     * @param \StructType\OriginalPayloadStdAttributes $originalPayloadStdAttributes
     * @param string $messageContent
     * @param int $startSeqNmbr
     * @param int $endSeqNmbr
     * @param string $messageType
     * @param string $responseValue
     * @param string $requestCode
     * @param string $reasonForRequest
     * @param string $userName
     * @param string $ratePlanCode
     * @param string $confirmationID
     * @param string $reservationID
     */
    public function __construct(\StructType\OriginalPayloadStdAttributes $originalPayloadStdAttributes = null, $messageContent = null, $startSeqNmbr = null, $endSeqNmbr = null, $messageType = null, $responseValue = null, $requestCode = null, $reasonForRequest = null, $userName = null, $ratePlanCode = null, $confirmationID = null, $reservationID = null)
    {
        $this
            ->setOriginalPayloadStdAttributes($originalPayloadStdAttributes)
            ->setMessageContent($messageContent)
            ->setStartSeqNmbr($startSeqNmbr)
            ->setEndSeqNmbr($endSeqNmbr)
            ->setMessageType($messageType)
            ->setResponseValue($responseValue)
            ->setRequestCode($requestCode)
            ->setReasonForRequest($reasonForRequest)
            ->setUserName($userName)
            ->setRatePlanCode($ratePlanCode)
            ->setConfirmationID($confirmationID)
            ->setReservationID($reservationID);
    }
    /**
     * Get OriginalPayloadStdAttributes value
     * @return \StructType\OriginalPayloadStdAttributes|null
     */
    public function getOriginalPayloadStdAttributes()
    {
        return $this->OriginalPayloadStdAttributes;
    }
    /**
     * Set OriginalPayloadStdAttributes value
     * @param \StructType\OriginalPayloadStdAttributes $originalPayloadStdAttributes
     * @return \StructType\MessageType
     */
    public function setOriginalPayloadStdAttributes(\StructType\OriginalPayloadStdAttributes $originalPayloadStdAttributes = null)
    {
        $this->OriginalPayloadStdAttributes = $originalPayloadStdAttributes;
        return $this;
    }
    /**
     * Get MessageContent value
     * @return string|null
     */
    public function getMessageContent()
    {
        return $this->MessageContent;
    }
    /**
     * Set MessageContent value
     * @param string $messageContent
     * @return \StructType\MessageType
     */
    public function setMessageContent($messageContent = null)
    {
        // validation for constraint: string
        if (!is_null($messageContent) && !is_string($messageContent)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($messageContent, true), gettype($messageContent)), __LINE__);
        }
        $this->MessageContent = $messageContent;
        return $this;
    }
    /**
     * Get StartSeqNmbr value
     * @return int|null
     */
    public function getStartSeqNmbr()
    {
        return $this->StartSeqNmbr;
    }
    /**
     * Set StartSeqNmbr value
     * @param int $startSeqNmbr
     * @return \StructType\MessageType
     */
    public function setStartSeqNmbr($startSeqNmbr = null)
    {
        // validation for constraint: int
        if (!is_null($startSeqNmbr) && !(is_int($startSeqNmbr) || ctype_digit($startSeqNmbr))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($startSeqNmbr, true), gettype($startSeqNmbr)), __LINE__);
        }
        $this->StartSeqNmbr = $startSeqNmbr;
        return $this;
    }
    /**
     * Get EndSeqNmbr value
     * @return int|null
     */
    public function getEndSeqNmbr()
    {
        return $this->EndSeqNmbr;
    }
    /**
     * Set EndSeqNmbr value
     * @param int $endSeqNmbr
     * @return \StructType\MessageType
     */
    public function setEndSeqNmbr($endSeqNmbr = null)
    {
        // validation for constraint: int
        if (!is_null($endSeqNmbr) && !(is_int($endSeqNmbr) || ctype_digit($endSeqNmbr))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($endSeqNmbr, true), gettype($endSeqNmbr)), __LINE__);
        }
        $this->EndSeqNmbr = $endSeqNmbr;
        return $this;
    }
    /**
     * Get MessageType value
     * @return string|null
     */
    public function getMessageType()
    {
        return $this->MessageType;
    }
    /**
     * Set MessageType value
     * @param string $messageType
     * @return \StructType\MessageType
     */
    public function setMessageType($messageType = null)
    {
        // validation for constraint: string
        if (!is_null($messageType) && !is_string($messageType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($messageType, true), gettype($messageType)), __LINE__);
        }
        $this->MessageType = $messageType;
        return $this;
    }
    /**
     * Get ResponseValue value
     * @return string|null
     */
    public function getResponseValue()
    {
        return $this->ResponseValue;
    }
    /**
     * Set ResponseValue value
     * @param string $responseValue
     * @return \StructType\MessageType
     */
    public function setResponseValue($responseValue = null)
    {
        // validation for constraint: string
        if (!is_null($responseValue) && !is_string($responseValue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($responseValue, true), gettype($responseValue)), __LINE__);
        }
        $this->ResponseValue = $responseValue;
        return $this;
    }
    /**
     * Get RequestCode value
     * @return string|null
     */
    public function getRequestCode()
    {
        return $this->RequestCode;
    }
    /**
     * Set RequestCode value
     * @param string $requestCode
     * @return \StructType\MessageType
     */
    public function setRequestCode($requestCode = null)
    {
        // validation for constraint: string
        if (!is_null($requestCode) && !is_string($requestCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($requestCode, true), gettype($requestCode)), __LINE__);
        }
        $this->RequestCode = $requestCode;
        return $this;
    }
    /**
     * Get ReasonForRequest value
     * @return string|null
     */
    public function getReasonForRequest()
    {
        return $this->ReasonForRequest;
    }
    /**
     * Set ReasonForRequest value
     * @param string $reasonForRequest
     * @return \StructType\MessageType
     */
    public function setReasonForRequest($reasonForRequest = null)
    {
        // validation for constraint: string
        if (!is_null($reasonForRequest) && !is_string($reasonForRequest)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reasonForRequest, true), gettype($reasonForRequest)), __LINE__);
        }
        $this->ReasonForRequest = $reasonForRequest;
        return $this;
    }
    /**
     * Get UserName value
     * @return string|null
     */
    public function getUserName()
    {
        return $this->UserName;
    }
    /**
     * Set UserName value
     * @param string $userName
     * @return \StructType\MessageType
     */
    public function setUserName($userName = null)
    {
        // validation for constraint: string
        if (!is_null($userName) && !is_string($userName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($userName, true), gettype($userName)), __LINE__);
        }
        $this->UserName = $userName;
        return $this;
    }
    /**
     * Get RatePlanCode value
     * @return string|null
     */
    public function getRatePlanCode()
    {
        return $this->RatePlanCode;
    }
    /**
     * Set RatePlanCode value
     * @param string $ratePlanCode
     * @return \StructType\MessageType
     */
    public function setRatePlanCode($ratePlanCode = null)
    {
        // validation for constraint: string
        if (!is_null($ratePlanCode) && !is_string($ratePlanCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ratePlanCode, true), gettype($ratePlanCode)), __LINE__);
        }
        $this->RatePlanCode = $ratePlanCode;
        return $this;
    }
    /**
     * Get ConfirmationID value
     * @return string|null
     */
    public function getConfirmationID()
    {
        return $this->ConfirmationID;
    }
    /**
     * Set ConfirmationID value
     * @param string $confirmationID
     * @return \StructType\MessageType
     */
    public function setConfirmationID($confirmationID = null)
    {
        // validation for constraint: string
        if (!is_null($confirmationID) && !is_string($confirmationID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($confirmationID, true), gettype($confirmationID)), __LINE__);
        }
        $this->ConfirmationID = $confirmationID;
        return $this;
    }
    /**
     * Get ReservationID value
     * @return string|null
     */
    public function getReservationID()
    {
        return $this->ReservationID;
    }
    /**
     * Set ReservationID value
     * @param string $reservationID
     * @return \StructType\MessageType
     */
    public function setReservationID($reservationID = null)
    {
        // validation for constraint: string
        if (!is_null($reservationID) && !is_string($reservationID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reservationID, true), gettype($reservationID)), __LINE__);
        }
        $this->ReservationID = $reservationID;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\MessageType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
