<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MemberInfo StructType
 * Meta information extracted from the WSDL
 * - documentation: Loyalty program member information.
 * @subpackage Structs
 */
class MemberInfo extends AbstractStructBase
{
    /**
     * The OntologyExtension
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: OntologyExtension
     * @var mixed
     */
    public $OntologyExtension;
    /**
     * The PrivacyInd
     * Meta information extracted from the WSDL
     * - documentation: Implementer: If true, this traveler information may only be used to determine relevant offers. | Example: true | Information use and sharing restriction indicator.
     * - use: optional
     * @var bool
     */
    public $PrivacyInd;
    /**
     * The ID
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - pattern: [a-zA-Z0-9]{1,32}
     * - use: optional
     * @var string
     */
    public $ID;
    /**
     * The SignupDate
     * Meta information extracted from the WSDL
     * - documentation: Example: 2010-01-12 | Loyalty program member signup date.
     * - use: optional
     * @var string
     */
    public $SignupDate;
    /**
     * The OntologyRefID
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - pattern: [0-9]{1,8}
     * - use: optional
     * @var string
     */
    public $OntologyRefID;
    /**
     * Constructor method for MemberInfo
     * @uses MemberInfo::setOntologyExtension()
     * @uses MemberInfo::setPrivacyInd()
     * @uses MemberInfo::setID()
     * @uses MemberInfo::setSignupDate()
     * @uses MemberInfo::setOntologyRefID()
     * @param mixed $ontologyExtension
     * @param bool $privacyInd
     * @param string $iD
     * @param string $signupDate
     * @param string $ontologyRefID
     */
    public function __construct($ontologyExtension = null, $privacyInd = null, $iD = null, $signupDate = null, $ontologyRefID = null)
    {
        $this
            ->setOntologyExtension($ontologyExtension)
            ->setPrivacyInd($privacyInd)
            ->setID($iD)
            ->setSignupDate($signupDate)
            ->setOntologyRefID($ontologyRefID);
    }
    /**
     * Get OntologyExtension value
     * @return mixed|null
     */
    public function getOntologyExtension()
    {
        return $this->OntologyExtension;
    }
    /**
     * Set OntologyExtension value
     * @param mixed $ontologyExtension
     * @return \StructType\MemberInfo
     */
    public function setOntologyExtension($ontologyExtension = null)
    {
        $this->OntologyExtension = $ontologyExtension;
        return $this;
    }
    /**
     * Get PrivacyInd value
     * @return bool|null
     */
    public function getPrivacyInd()
    {
        return $this->PrivacyInd;
    }
    /**
     * Set PrivacyInd value
     * @param bool $privacyInd
     * @return \StructType\MemberInfo
     */
    public function setPrivacyInd($privacyInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($privacyInd) && !is_bool($privacyInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($privacyInd, true), gettype($privacyInd)), __LINE__);
        }
        $this->PrivacyInd = $privacyInd;
        return $this;
    }
    /**
     * Get ID value
     * @return string|null
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * Set ID value
     * @param string $iD
     * @return \StructType\MemberInfo
     */
    public function setID($iD = null)
    {
        // validation for constraint: string
        if (!is_null($iD) && !is_string($iD)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iD, true), gettype($iD)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{1,32})
        if (!is_null($iD) && !preg_match('/[a-zA-Z0-9]{1,32}/', $iD)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{1,32}', var_export($iD, true)), __LINE__);
        }
        $this->ID = $iD;
        return $this;
    }
    /**
     * Get SignupDate value
     * @return string|null
     */
    public function getSignupDate()
    {
        return $this->SignupDate;
    }
    /**
     * Set SignupDate value
     * @param string $signupDate
     * @return \StructType\MemberInfo
     */
    public function setSignupDate($signupDate = null)
    {
        // validation for constraint: string
        if (!is_null($signupDate) && !is_string($signupDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($signupDate, true), gettype($signupDate)), __LINE__);
        }
        $this->SignupDate = $signupDate;
        return $this;
    }
    /**
     * Get OntologyRefID value
     * @return string|null
     */
    public function getOntologyRefID()
    {
        return $this->OntologyRefID;
    }
    /**
     * Set OntologyRefID value
     * @param string $ontologyRefID
     * @return \StructType\MemberInfo
     */
    public function setOntologyRefID($ontologyRefID = null)
    {
        // validation for constraint: string
        if (!is_null($ontologyRefID) && !is_string($ontologyRefID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ontologyRefID, true), gettype($ontologyRefID)), __LINE__);
        }
        // validation for constraint: pattern([0-9]{1,8})
        if (!is_null($ontologyRefID) && !preg_match('/[0-9]{1,8}/', $ontologyRefID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9]{1,8}', var_export($ontologyRefID, true)), __LINE__);
        }
        $this->OntologyRefID = $ontologyRefID;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\MemberInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
