<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MasterContact StructType
 * Meta information extracted from the WSDL
 * - documentation: Planner or coordinator contact information for the rooming list.
 * @subpackage Structs
 */
class MasterContact extends ContactPersonType
{
    /**
     * The UniqueIDs
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\UniqueIDs
     */
    public $UniqueIDs;
    /**
     * The Loyalty
     * Meta information extracted from the WSDL
     * - maxOccurs: 5
     * - minOccurs: 0
     * @var \StructType\Loyalty[]
     */
    public $Loyalty;
    /**
     * Constructor method for MasterContact
     * @uses MasterContact::setUniqueIDs()
     * @uses MasterContact::setLoyalty()
     * @param \StructType\UniqueIDs $uniqueIDs
     * @param \StructType\Loyalty[] $loyalty
     */
    public function __construct(\StructType\UniqueIDs $uniqueIDs = null, array $loyalty = array())
    {
        $this
            ->setUniqueIDs($uniqueIDs)
            ->setLoyalty($loyalty);
    }
    /**
     * Get UniqueIDs value
     * @return \StructType\UniqueIDs|null
     */
    public function getUniqueIDs()
    {
        return $this->UniqueIDs;
    }
    /**
     * Set UniqueIDs value
     * @param \StructType\UniqueIDs $uniqueIDs
     * @return \StructType\MasterContact
     */
    public function setUniqueIDs(\StructType\UniqueIDs $uniqueIDs = null)
    {
        $this->UniqueIDs = $uniqueIDs;
        return $this;
    }
    /**
     * Get Loyalty value
     * @return \StructType\Loyalty[]|null
     */
    public function getLoyalty()
    {
        return $this->Loyalty;
    }
    /**
     * This method is responsible for validating the values passed to the setLoyalty method
     * This method is willingly generated in order to preserve the one-line inline validation within the setLoyalty method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateLoyaltyForArrayConstraintsFromSetLoyalty(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $masterContactLoyaltyItem) {
            // validation for constraint: itemType
            if (!$masterContactLoyaltyItem instanceof \StructType\Loyalty) {
                $invalidValues[] = is_object($masterContactLoyaltyItem) ? get_class($masterContactLoyaltyItem) : sprintf('%s(%s)', gettype($masterContactLoyaltyItem), var_export($masterContactLoyaltyItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Loyalty property can only contain items of type \StructType\Loyalty, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Loyalty value
     * @throws \InvalidArgumentException
     * @param \StructType\Loyalty[] $loyalty
     * @return \StructType\MasterContact
     */
    public function setLoyalty(array $loyalty = array())
    {
        // validation for constraint: array
        if ('' !== ($loyaltyArrayErrorMessage = self::validateLoyaltyForArrayConstraintsFromSetLoyalty($loyalty))) {
            throw new \InvalidArgumentException($loyaltyArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(5)
        if (is_array($loyalty) && count($loyalty) > 5) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 5', count($loyalty)), __LINE__);
        }
        $this->Loyalty = $loyalty;
        return $this;
    }
    /**
     * Add item to Loyalty value
     * @throws \InvalidArgumentException
     * @param \StructType\Loyalty $item
     * @return \StructType\MasterContact
     */
    public function addToLoyalty(\StructType\Loyalty $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Loyalty) {
            throw new \InvalidArgumentException(sprintf('The Loyalty property can only contain items of type \StructType\Loyalty, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(5)
        if (is_array($this->Loyalty) && count($this->Loyalty) >= 5) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 5', count($this->Loyalty)), __LINE__);
        }
        $this->Loyalty[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\MasterContact
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
