<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LoyaltyRedemption StructType
 * Meta information extracted from the WSDL
 * - documentation: Used to provide a promotion code of the loyalty redemption. | Identifies the Loyalty scheme, programs and promotions within the scheme, membership reference, form factor used by the certificate, the number of nights it can be used
 * for and its current status. | Details of a loyalty redemption arrangement. This is normally miles or points.
 * @subpackage Structs
 */
class LoyaltyRedemption extends AbstractStructBase
{
    /**
     * The LoyaltyCertificate
     * Meta information extracted from the WSDL
     * - maxOccurs: 9
     * - minOccurs: 0
     * @var \StructType\LoyaltyCertificate[]
     */
    public $LoyaltyCertificate;
    /**
     * The RedemptionQuantity
     * Meta information extracted from the WSDL
     * - documentation: The quantity of loyalty units being redeemed.
     * - use: optional
     * @var int
     */
    public $RedemptionQuantity;
    /**
     * Constructor method for LoyaltyRedemption
     * @uses LoyaltyRedemption::setLoyaltyCertificate()
     * @uses LoyaltyRedemption::setRedemptionQuantity()
     * @param \StructType\LoyaltyCertificate[] $loyaltyCertificate
     * @param int $redemptionQuantity
     */
    public function __construct(array $loyaltyCertificate = array(), $redemptionQuantity = null)
    {
        $this
            ->setLoyaltyCertificate($loyaltyCertificate)
            ->setRedemptionQuantity($redemptionQuantity);
    }
    /**
     * Get LoyaltyCertificate value
     * @return \StructType\LoyaltyCertificate[]|null
     */
    public function getLoyaltyCertificate()
    {
        return $this->LoyaltyCertificate;
    }
    /**
     * This method is responsible for validating the values passed to the setLoyaltyCertificate method
     * This method is willingly generated in order to preserve the one-line inline validation within the setLoyaltyCertificate method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateLoyaltyCertificateForArrayConstraintsFromSetLoyaltyCertificate(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $loyaltyRedemptionLoyaltyCertificateItem) {
            // validation for constraint: itemType
            if (!$loyaltyRedemptionLoyaltyCertificateItem instanceof \StructType\LoyaltyCertificate) {
                $invalidValues[] = is_object($loyaltyRedemptionLoyaltyCertificateItem) ? get_class($loyaltyRedemptionLoyaltyCertificateItem) : sprintf('%s(%s)', gettype($loyaltyRedemptionLoyaltyCertificateItem), var_export($loyaltyRedemptionLoyaltyCertificateItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The LoyaltyCertificate property can only contain items of type \StructType\LoyaltyCertificate, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set LoyaltyCertificate value
     * @throws \InvalidArgumentException
     * @param \StructType\LoyaltyCertificate[] $loyaltyCertificate
     * @return \StructType\LoyaltyRedemption
     */
    public function setLoyaltyCertificate(array $loyaltyCertificate = array())
    {
        // validation for constraint: array
        if ('' !== ($loyaltyCertificateArrayErrorMessage = self::validateLoyaltyCertificateForArrayConstraintsFromSetLoyaltyCertificate($loyaltyCertificate))) {
            throw new \InvalidArgumentException($loyaltyCertificateArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(9)
        if (is_array($loyaltyCertificate) && count($loyaltyCertificate) > 9) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 9', count($loyaltyCertificate)), __LINE__);
        }
        $this->LoyaltyCertificate = $loyaltyCertificate;
        return $this;
    }
    /**
     * Add item to LoyaltyCertificate value
     * @throws \InvalidArgumentException
     * @param \StructType\LoyaltyCertificate $item
     * @return \StructType\LoyaltyRedemption
     */
    public function addToLoyaltyCertificate(\StructType\LoyaltyCertificate $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\LoyaltyCertificate) {
            throw new \InvalidArgumentException(sprintf('The LoyaltyCertificate property can only contain items of type \StructType\LoyaltyCertificate, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(9)
        if (is_array($this->LoyaltyCertificate) && count($this->LoyaltyCertificate) >= 9) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 9', count($this->LoyaltyCertificate)), __LINE__);
        }
        $this->LoyaltyCertificate[] = $item;
        return $this;
    }
    /**
     * Get RedemptionQuantity value
     * @return int|null
     */
    public function getRedemptionQuantity()
    {
        return $this->RedemptionQuantity;
    }
    /**
     * Set RedemptionQuantity value
     * @param int $redemptionQuantity
     * @return \StructType\LoyaltyRedemption
     */
    public function setRedemptionQuantity($redemptionQuantity = null)
    {
        // validation for constraint: int
        if (!is_null($redemptionQuantity) && !(is_int($redemptionQuantity) || ctype_digit($redemptionQuantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($redemptionQuantity, true), gettype($redemptionQuantity)), __LINE__);
        }
        $this->RedemptionQuantity = $redemptionQuantity;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\LoyaltyRedemption
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
