<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LoyalProgram StructType
 * Meta information extracted from the WSDL
 * - documentation: The LoyalProgram class defines the loyalty programs that this hotel participates in.
 * @subpackage Structs
 */
class LoyalProgram extends AbstractStructBase
{
    /**
     * The ProgramDescription
     * Meta information extracted from the WSDL
     * - maxOccurs: 5
     * - minOccurs: 0
     * @var \StructType\ProgramDescription[]
     */
    public $ProgramDescription;
    /**
     * The ProgramRestriction
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ProgramRestriction
     */
    public $ProgramRestriction;
    /**
     * The BlackoutDates
     * Meta information extracted from the WSDL
     * - documentation: A collection of black-out dates (i.e. dates when loyalty redemptions are not allowed).
     * - minOccurs: 0
     * @var mixed
     */
    public $BlackoutDates;
    /**
     * The ProgramName
     * Meta information extracted from the WSDL
     * - documentation: This identifies the loyalty program.
     * - use: optional
     * @var string
     */
    public $ProgramName;
    /**
     * The SecondaryProgramName
     * Meta information extracted from the WSDL
     * - documentation: The name of the secondary level of the program, e.g.: gold, silver, etc..
     * - use: optional
     * @var string
     */
    public $SecondaryProgramName;
    /**
     * The AffiliateProgramName
     * Meta information extracted from the WSDL
     * - documentation: The title of the membership program affiliated with the primary program.
     * - use: optional
     * @var string
     */
    public $AffiliateProgramName;
    /**
     * The HotelLevel
     * Meta information extracted from the WSDL
     * - documentation: Used to indicate the level to which the hotel is assigned within the program for redemption purposes.
     * - use: optional
     * @var string
     */
    public $HotelLevel;
    /**
     * The ProgramCode
     * Meta information extracted from the WSDL
     * - documentation: A company-specific code used to identify a loyalty program.
     * - use: optional
     * @var string
     */
    public $ProgramCode;
    /**
     * The TravelSector
     * Meta information extracted from the WSDL
     * - documentation: Used to identify the specific travel sector to which the loyalty program applies. Refer to OpenTravel Codelist Travel Sector (TVS).
     * - use: optional
     * @var string
     */
    public $TravelSector;
    /**
     * The PrimaryProgramInd
     * Meta information extracted from the WSDL
     * - documentation: If TRUE, identifies the primary loyalty program.
     * - use: optional
     * @var bool
     */
    public $PrimaryProgramInd;
    /**
     * Constructor method for LoyalProgram
     * @uses LoyalProgram::setProgramDescription()
     * @uses LoyalProgram::setProgramRestriction()
     * @uses LoyalProgram::setBlackoutDates()
     * @uses LoyalProgram::setProgramName()
     * @uses LoyalProgram::setSecondaryProgramName()
     * @uses LoyalProgram::setAffiliateProgramName()
     * @uses LoyalProgram::setHotelLevel()
     * @uses LoyalProgram::setProgramCode()
     * @uses LoyalProgram::setTravelSector()
     * @uses LoyalProgram::setPrimaryProgramInd()
     * @param \StructType\ProgramDescription[] $programDescription
     * @param \StructType\ProgramRestriction $programRestriction
     * @param mixed $blackoutDates
     * @param string $programName
     * @param string $secondaryProgramName
     * @param string $affiliateProgramName
     * @param string $hotelLevel
     * @param string $programCode
     * @param string $travelSector
     * @param bool $primaryProgramInd
     */
    public function __construct(array $programDescription = array(), \StructType\ProgramRestriction $programRestriction = null, $blackoutDates = null, $programName = null, $secondaryProgramName = null, $affiliateProgramName = null, $hotelLevel = null, $programCode = null, $travelSector = null, $primaryProgramInd = null)
    {
        $this
            ->setProgramDescription($programDescription)
            ->setProgramRestriction($programRestriction)
            ->setBlackoutDates($blackoutDates)
            ->setProgramName($programName)
            ->setSecondaryProgramName($secondaryProgramName)
            ->setAffiliateProgramName($affiliateProgramName)
            ->setHotelLevel($hotelLevel)
            ->setProgramCode($programCode)
            ->setTravelSector($travelSector)
            ->setPrimaryProgramInd($primaryProgramInd);
    }
    /**
     * Get ProgramDescription value
     * @return \StructType\ProgramDescription[]|null
     */
    public function getProgramDescription()
    {
        return $this->ProgramDescription;
    }
    /**
     * This method is responsible for validating the values passed to the setProgramDescription method
     * This method is willingly generated in order to preserve the one-line inline validation within the setProgramDescription method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateProgramDescriptionForArrayConstraintsFromSetProgramDescription(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $loyalProgramProgramDescriptionItem) {
            // validation for constraint: itemType
            if (!$loyalProgramProgramDescriptionItem instanceof \StructType\ProgramDescription) {
                $invalidValues[] = is_object($loyalProgramProgramDescriptionItem) ? get_class($loyalProgramProgramDescriptionItem) : sprintf('%s(%s)', gettype($loyalProgramProgramDescriptionItem), var_export($loyalProgramProgramDescriptionItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ProgramDescription property can only contain items of type \StructType\ProgramDescription, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ProgramDescription value
     * @throws \InvalidArgumentException
     * @param \StructType\ProgramDescription[] $programDescription
     * @return \StructType\LoyalProgram
     */
    public function setProgramDescription(array $programDescription = array())
    {
        // validation for constraint: array
        if ('' !== ($programDescriptionArrayErrorMessage = self::validateProgramDescriptionForArrayConstraintsFromSetProgramDescription($programDescription))) {
            throw new \InvalidArgumentException($programDescriptionArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(5)
        if (is_array($programDescription) && count($programDescription) > 5) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 5', count($programDescription)), __LINE__);
        }
        $this->ProgramDescription = $programDescription;
        return $this;
    }
    /**
     * Add item to ProgramDescription value
     * @throws \InvalidArgumentException
     * @param \StructType\ProgramDescription $item
     * @return \StructType\LoyalProgram
     */
    public function addToProgramDescription(\StructType\ProgramDescription $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ProgramDescription) {
            throw new \InvalidArgumentException(sprintf('The ProgramDescription property can only contain items of type \StructType\ProgramDescription, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(5)
        if (is_array($this->ProgramDescription) && count($this->ProgramDescription) >= 5) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 5', count($this->ProgramDescription)), __LINE__);
        }
        $this->ProgramDescription[] = $item;
        return $this;
    }
    /**
     * Get ProgramRestriction value
     * @return \StructType\ProgramRestriction|null
     */
    public function getProgramRestriction()
    {
        return $this->ProgramRestriction;
    }
    /**
     * Set ProgramRestriction value
     * @param \StructType\ProgramRestriction $programRestriction
     * @return \StructType\LoyalProgram
     */
    public function setProgramRestriction(\StructType\ProgramRestriction $programRestriction = null)
    {
        $this->ProgramRestriction = $programRestriction;
        return $this;
    }
    /**
     * Get BlackoutDates value
     * @return mixed|null
     */
    public function getBlackoutDates()
    {
        return $this->BlackoutDates;
    }
    /**
     * Set BlackoutDates value
     * @param mixed $blackoutDates
     * @return \StructType\LoyalProgram
     */
    public function setBlackoutDates($blackoutDates = null)
    {
        $this->BlackoutDates = $blackoutDates;
        return $this;
    }
    /**
     * Get ProgramName value
     * @return string|null
     */
    public function getProgramName()
    {
        return $this->ProgramName;
    }
    /**
     * Set ProgramName value
     * @param string $programName
     * @return \StructType\LoyalProgram
     */
    public function setProgramName($programName = null)
    {
        // validation for constraint: string
        if (!is_null($programName) && !is_string($programName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($programName, true), gettype($programName)), __LINE__);
        }
        $this->ProgramName = $programName;
        return $this;
    }
    /**
     * Get SecondaryProgramName value
     * @return string|null
     */
    public function getSecondaryProgramName()
    {
        return $this->SecondaryProgramName;
    }
    /**
     * Set SecondaryProgramName value
     * @param string $secondaryProgramName
     * @return \StructType\LoyalProgram
     */
    public function setSecondaryProgramName($secondaryProgramName = null)
    {
        // validation for constraint: string
        if (!is_null($secondaryProgramName) && !is_string($secondaryProgramName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($secondaryProgramName, true), gettype($secondaryProgramName)), __LINE__);
        }
        $this->SecondaryProgramName = $secondaryProgramName;
        return $this;
    }
    /**
     * Get AffiliateProgramName value
     * @return string|null
     */
    public function getAffiliateProgramName()
    {
        return $this->AffiliateProgramName;
    }
    /**
     * Set AffiliateProgramName value
     * @param string $affiliateProgramName
     * @return \StructType\LoyalProgram
     */
    public function setAffiliateProgramName($affiliateProgramName = null)
    {
        // validation for constraint: string
        if (!is_null($affiliateProgramName) && !is_string($affiliateProgramName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($affiliateProgramName, true), gettype($affiliateProgramName)), __LINE__);
        }
        $this->AffiliateProgramName = $affiliateProgramName;
        return $this;
    }
    /**
     * Get HotelLevel value
     * @return string|null
     */
    public function getHotelLevel()
    {
        return $this->HotelLevel;
    }
    /**
     * Set HotelLevel value
     * @param string $hotelLevel
     * @return \StructType\LoyalProgram
     */
    public function setHotelLevel($hotelLevel = null)
    {
        // validation for constraint: string
        if (!is_null($hotelLevel) && !is_string($hotelLevel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hotelLevel, true), gettype($hotelLevel)), __LINE__);
        }
        $this->HotelLevel = $hotelLevel;
        return $this;
    }
    /**
     * Get ProgramCode value
     * @return string|null
     */
    public function getProgramCode()
    {
        return $this->ProgramCode;
    }
    /**
     * Set ProgramCode value
     * @param string $programCode
     * @return \StructType\LoyalProgram
     */
    public function setProgramCode($programCode = null)
    {
        // validation for constraint: string
        if (!is_null($programCode) && !is_string($programCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($programCode, true), gettype($programCode)), __LINE__);
        }
        $this->ProgramCode = $programCode;
        return $this;
    }
    /**
     * Get TravelSector value
     * @return string|null
     */
    public function getTravelSector()
    {
        return $this->TravelSector;
    }
    /**
     * Set TravelSector value
     * @param string $travelSector
     * @return \StructType\LoyalProgram
     */
    public function setTravelSector($travelSector = null)
    {
        // validation for constraint: string
        if (!is_null($travelSector) && !is_string($travelSector)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($travelSector, true), gettype($travelSector)), __LINE__);
        }
        $this->TravelSector = $travelSector;
        return $this;
    }
    /**
     * Get PrimaryProgramInd value
     * @return bool|null
     */
    public function getPrimaryProgramInd()
    {
        return $this->PrimaryProgramInd;
    }
    /**
     * Set PrimaryProgramInd value
     * @param bool $primaryProgramInd
     * @return \StructType\LoyalProgram
     */
    public function setPrimaryProgramInd($primaryProgramInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($primaryProgramInd) && !is_bool($primaryProgramInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($primaryProgramInd, true), gettype($primaryProgramInd)), __LINE__);
        }
        $this->PrimaryProgramInd = $primaryProgramInd;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\LoyalProgram
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
