<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LocationRequirement StructType
 * Meta information extracted from the WSDL
 * - documentation: Location requirement information for pricing.
 * @subpackage Structs
 */
class LocationRequirement extends AbstractStructBase
{
    /**
     * The Type
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $Type;
    /**
     * The State
     * Meta information extracted from the WSDL
     * - documentation: The state location required for some fares.
     * - use: optional
     * @var mixed
     */
    public $State;
    /**
     * The Country
     * Meta information extracted from the WSDL
     * - documentation: The country location required for some fares.
     * - use: optional
     * @var string
     */
    public $Country;
    /**
     * Constructor method for LocationRequirement
     * @uses LocationRequirement::setType()
     * @uses LocationRequirement::setState()
     * @uses LocationRequirement::setCountry()
     * @param string $type
     * @param mixed $state
     * @param string $country
     */
    public function __construct($type = null, $state = null, $country = null)
    {
        $this
            ->setType($type)
            ->setState($state)
            ->setCountry($country);
    }
    /**
     * Get Type value
     * @return string|null
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @param string $type
     * @return \StructType\LocationRequirement
     */
    public function setType($type = null)
    {
        // validation for constraint: string
        if (!is_null($type) && !is_string($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($type, true), gettype($type)), __LINE__);
        }
        $this->Type = $type;
        return $this;
    }
    /**
     * Get State value
     * @return mixed|null
     */
    public function getState()
    {
        return $this->State;
    }
    /**
     * Set State value
     * @param mixed $state
     * @return \StructType\LocationRequirement
     */
    public function setState($state = null)
    {
        $this->State = $state;
        return $this;
    }
    /**
     * Get Country value
     * @return string|null
     */
    public function getCountry()
    {
        return $this->Country;
    }
    /**
     * Set Country value
     * @param string $country
     * @return \StructType\LocationRequirement
     */
    public function setCountry($country = null)
    {
        // validation for constraint: string
        if (!is_null($country) && !is_string($country)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($country, true), gettype($country)), __LINE__);
        }
        $this->Country = $country;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\LocationRequirement
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
