<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LocationCodes StructType
 * Meta information extracted from the WSDL
 * - documentation: A collections of strings that identify the locations, such as regions or countries, etc., associated with this viewership record.
 * @subpackage Structs
 */
class LocationCodes extends AbstractStructBase
{
    /**
     * The LocationCode
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \StructType\LocationCode[]
     */
    public $LocationCode;
    /**
     * The LocationCodesInclusive
     * Meta information extracted from the WSDL
     * - documentation: Values: false=Exclusive, true=Inclusive. | Indicates whether the collection of Location Codes is inclusive or exclusive.
     * - use: optional
     * @var bool
     */
    public $LocationCodesInclusive;
    /**
     * Constructor method for LocationCodes
     * @uses LocationCodes::setLocationCode()
     * @uses LocationCodes::setLocationCodesInclusive()
     * @param \StructType\LocationCode[] $locationCode
     * @param bool $locationCodesInclusive
     */
    public function __construct(array $locationCode = array(), $locationCodesInclusive = null)
    {
        $this
            ->setLocationCode($locationCode)
            ->setLocationCodesInclusive($locationCodesInclusive);
    }
    /**
     * Get LocationCode value
     * @return \StructType\LocationCode[]|null
     */
    public function getLocationCode()
    {
        return $this->LocationCode;
    }
    /**
     * This method is responsible for validating the values passed to the setLocationCode method
     * This method is willingly generated in order to preserve the one-line inline validation within the setLocationCode method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateLocationCodeForArrayConstraintsFromSetLocationCode(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $locationCodesLocationCodeItem) {
            // validation for constraint: itemType
            if (!$locationCodesLocationCodeItem instanceof \StructType\LocationCode) {
                $invalidValues[] = is_object($locationCodesLocationCodeItem) ? get_class($locationCodesLocationCodeItem) : sprintf('%s(%s)', gettype($locationCodesLocationCodeItem), var_export($locationCodesLocationCodeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The LocationCode property can only contain items of type \StructType\LocationCode, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set LocationCode value
     * @throws \InvalidArgumentException
     * @param \StructType\LocationCode[] $locationCode
     * @return \StructType\LocationCodes
     */
    public function setLocationCode(array $locationCode = array())
    {
        // validation for constraint: array
        if ('' !== ($locationCodeArrayErrorMessage = self::validateLocationCodeForArrayConstraintsFromSetLocationCode($locationCode))) {
            throw new \InvalidArgumentException($locationCodeArrayErrorMessage, __LINE__);
        }
        $this->LocationCode = $locationCode;
        return $this;
    }
    /**
     * Add item to LocationCode value
     * @throws \InvalidArgumentException
     * @param \StructType\LocationCode $item
     * @return \StructType\LocationCodes
     */
    public function addToLocationCode(\StructType\LocationCode $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\LocationCode) {
            throw new \InvalidArgumentException(sprintf('The LocationCode property can only contain items of type \StructType\LocationCode, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->LocationCode[] = $item;
        return $this;
    }
    /**
     * Get LocationCodesInclusive value
     * @return bool|null
     */
    public function getLocationCodesInclusive()
    {
        return $this->LocationCodesInclusive;
    }
    /**
     * Set LocationCodesInclusive value
     * @param bool $locationCodesInclusive
     * @return \StructType\LocationCodes
     */
    public function setLocationCodesInclusive($locationCodesInclusive = null)
    {
        // validation for constraint: boolean
        if (!is_null($locationCodesInclusive) && !is_bool($locationCodesInclusive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($locationCodesInclusive, true), gettype($locationCodesInclusive)), __LINE__);
        }
        $this->LocationCodesInclusive = $locationCodesInclusive;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\LocationCodes
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
