<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LinkedBookings StructType
 * Meta information extracted from the WSDL
 * - documentation: Collection of linked bookings.
 * @subpackage Structs
 */
class LinkedBookings extends AbstractStructBase
{
    /**
     * The LinkedBooking
     * Meta information extracted from the WSDL
     * - maxOccurs: 32
     * @var \StructType\LinkedBooking[]
     */
    public $LinkedBooking;
    /**
     * Constructor method for LinkedBookings
     * @uses LinkedBookings::setLinkedBooking()
     * @param \StructType\LinkedBooking[] $linkedBooking
     */
    public function __construct(array $linkedBooking = array())
    {
        $this
            ->setLinkedBooking($linkedBooking);
    }
    /**
     * Get LinkedBooking value
     * @return \StructType\LinkedBooking[]|null
     */
    public function getLinkedBooking()
    {
        return $this->LinkedBooking;
    }
    /**
     * This method is responsible for validating the values passed to the setLinkedBooking method
     * This method is willingly generated in order to preserve the one-line inline validation within the setLinkedBooking method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateLinkedBookingForArrayConstraintsFromSetLinkedBooking(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $linkedBookingsLinkedBookingItem) {
            // validation for constraint: itemType
            if (!$linkedBookingsLinkedBookingItem instanceof \StructType\LinkedBooking) {
                $invalidValues[] = is_object($linkedBookingsLinkedBookingItem) ? get_class($linkedBookingsLinkedBookingItem) : sprintf('%s(%s)', gettype($linkedBookingsLinkedBookingItem), var_export($linkedBookingsLinkedBookingItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The LinkedBooking property can only contain items of type \StructType\LinkedBooking, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set LinkedBooking value
     * @throws \InvalidArgumentException
     * @param \StructType\LinkedBooking[] $linkedBooking
     * @return \StructType\LinkedBookings
     */
    public function setLinkedBooking(array $linkedBooking = array())
    {
        // validation for constraint: array
        if ('' !== ($linkedBookingArrayErrorMessage = self::validateLinkedBookingForArrayConstraintsFromSetLinkedBooking($linkedBooking))) {
            throw new \InvalidArgumentException($linkedBookingArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(32)
        if (is_array($linkedBooking) && count($linkedBooking) > 32) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 32', count($linkedBooking)), __LINE__);
        }
        $this->LinkedBooking = $linkedBooking;
        return $this;
    }
    /**
     * Add item to LinkedBooking value
     * @throws \InvalidArgumentException
     * @param \StructType\LinkedBooking $item
     * @return \StructType\LinkedBookings
     */
    public function addToLinkedBooking(\StructType\LinkedBooking $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\LinkedBooking) {
            throw new \InvalidArgumentException(sprintf('The LinkedBooking property can only contain items of type \StructType\LinkedBooking, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(32)
        if (is_array($this->LinkedBooking) && count($this->LinkedBooking) >= 32) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 32', count($this->LinkedBooking)), __LINE__);
        }
        $this->LinkedBooking[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\LinkedBookings
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
