<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LengthsOfStayType StructType
 * Meta information extracted from the WSDL
 * - documentation: A collection of LengthOfStay.
 * @subpackage Structs
 */
class LengthsOfStayType extends AbstractStructBase
{
    /**
     * The LengthOfStay
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\LengthOfStay[]
     */
    public $LengthOfStay;
    /**
     * The ArrivalDateBased
     * Meta information extracted from the WSDL
     * - documentation: True indicates that LOS is based on arrival date. False indicates that LOS is based on stay date.
     * - use: optional
     * @var bool
     */
    public $ArrivalDateBased;
    /**
     * The FixedPatternLength
     * Meta information extracted from the WSDL
     * - documentation: The number of elements in a fixed pattern length of stay (FPLOS) array.
     * - use: optional
     * @var int
     */
    public $FixedPatternLength;
    /**
     * Constructor method for LengthsOfStayType
     * @uses LengthsOfStayType::setLengthOfStay()
     * @uses LengthsOfStayType::setArrivalDateBased()
     * @uses LengthsOfStayType::setFixedPatternLength()
     * @param \StructType\LengthOfStay[] $lengthOfStay
     * @param bool $arrivalDateBased
     * @param int $fixedPatternLength
     */
    public function __construct(array $lengthOfStay = array(), $arrivalDateBased = null, $fixedPatternLength = null)
    {
        $this
            ->setLengthOfStay($lengthOfStay)
            ->setArrivalDateBased($arrivalDateBased)
            ->setFixedPatternLength($fixedPatternLength);
    }
    /**
     * Get LengthOfStay value
     * @return \StructType\LengthOfStay[]|null
     */
    public function getLengthOfStay()
    {
        return $this->LengthOfStay;
    }
    /**
     * This method is responsible for validating the values passed to the setLengthOfStay method
     * This method is willingly generated in order to preserve the one-line inline validation within the setLengthOfStay method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateLengthOfStayForArrayConstraintsFromSetLengthOfStay(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $lengthsOfStayTypeLengthOfStayItem) {
            // validation for constraint: itemType
            if (!$lengthsOfStayTypeLengthOfStayItem instanceof \StructType\LengthOfStay) {
                $invalidValues[] = is_object($lengthsOfStayTypeLengthOfStayItem) ? get_class($lengthsOfStayTypeLengthOfStayItem) : sprintf('%s(%s)', gettype($lengthsOfStayTypeLengthOfStayItem), var_export($lengthsOfStayTypeLengthOfStayItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The LengthOfStay property can only contain items of type \StructType\LengthOfStay, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set LengthOfStay value
     * @throws \InvalidArgumentException
     * @param \StructType\LengthOfStay[] $lengthOfStay
     * @return \StructType\LengthsOfStayType
     */
    public function setLengthOfStay(array $lengthOfStay = array())
    {
        // validation for constraint: array
        if ('' !== ($lengthOfStayArrayErrorMessage = self::validateLengthOfStayForArrayConstraintsFromSetLengthOfStay($lengthOfStay))) {
            throw new \InvalidArgumentException($lengthOfStayArrayErrorMessage, __LINE__);
        }
        $this->LengthOfStay = $lengthOfStay;
        return $this;
    }
    /**
     * Add item to LengthOfStay value
     * @throws \InvalidArgumentException
     * @param \StructType\LengthOfStay $item
     * @return \StructType\LengthsOfStayType
     */
    public function addToLengthOfStay(\StructType\LengthOfStay $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\LengthOfStay) {
            throw new \InvalidArgumentException(sprintf('The LengthOfStay property can only contain items of type \StructType\LengthOfStay, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->LengthOfStay[] = $item;
        return $this;
    }
    /**
     * Get ArrivalDateBased value
     * @return bool|null
     */
    public function getArrivalDateBased()
    {
        return $this->ArrivalDateBased;
    }
    /**
     * Set ArrivalDateBased value
     * @param bool $arrivalDateBased
     * @return \StructType\LengthsOfStayType
     */
    public function setArrivalDateBased($arrivalDateBased = null)
    {
        // validation for constraint: boolean
        if (!is_null($arrivalDateBased) && !is_bool($arrivalDateBased)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($arrivalDateBased, true), gettype($arrivalDateBased)), __LINE__);
        }
        $this->ArrivalDateBased = $arrivalDateBased;
        return $this;
    }
    /**
     * Get FixedPatternLength value
     * @return int|null
     */
    public function getFixedPatternLength()
    {
        return $this->FixedPatternLength;
    }
    /**
     * Set FixedPatternLength value
     * @param int $fixedPatternLength
     * @return \StructType\LengthsOfStayType
     */
    public function setFixedPatternLength($fixedPatternLength = null)
    {
        // validation for constraint: int
        if (!is_null($fixedPatternLength) && !(is_int($fixedPatternLength) || ctype_digit($fixedPatternLength))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($fixedPatternLength, true), gettype($fixedPatternLength)), __LINE__);
        }
        $this->FixedPatternLength = $fixedPatternLength;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\LengthsOfStayType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
