<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ItineraryItems StructType
 * Meta information extracted from the WSDL
 * - documentation: A collection of elements to allow any item of inventory to be requested for a booking. Normal usage is for the items to be presented in chronological sequence. | A collection of elements to allow any item of inventory to be requested
 * for a booking. Normal usage is for the items to be presented in chronological sequence
 * @subpackage Structs
 */
class ItineraryItems extends AbstractStructBase
{
    /**
     * The ItineraryItem
     * Meta information extracted from the WSDL
     * - documentation: Details of a package component. | An item of package itinerary - typically a flight, accommodation or car rental arrangement.
     * - maxOccurs: 99
     * @var mixed[]
     */
    public $ItineraryItem;
    /**
     * Constructor method for ItineraryItems
     * @uses ItineraryItems::setItineraryItem()
     * @param mixed[] $itineraryItem
     */
    public function __construct(array $itineraryItem = array())
    {
        $this
            ->setItineraryItem($itineraryItem);
    }
    /**
     * Get ItineraryItem value
     * @return mixed[]|null
     */
    public function getItineraryItem()
    {
        return $this->ItineraryItem;
    }
    /**
     * This method is responsible for validating the values passed to the setItineraryItem method
     * This method is willingly generated in order to preserve the one-line inline validation within the setItineraryItem method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateItineraryItemForArrayConstraintsFromSetItineraryItem(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $itineraryItemsItineraryItemItem) {
            // validation for constraint: itemType
            if (false) {
                $invalidValues[] = is_object($itineraryItemsItineraryItemItem) ? get_class($itineraryItemsItineraryItemItem) : sprintf('%s(%s)', gettype($itineraryItemsItineraryItemItem), var_export($itineraryItemsItineraryItemItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ItineraryItem property can only contain items of type anyType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ItineraryItem value
     * @throws \InvalidArgumentException
     * @param mixed[] $itineraryItem
     * @return \StructType\ItineraryItems
     */
    public function setItineraryItem(array $itineraryItem = array())
    {
        // validation for constraint: array
        if ('' !== ($itineraryItemArrayErrorMessage = self::validateItineraryItemForArrayConstraintsFromSetItineraryItem($itineraryItem))) {
            throw new \InvalidArgumentException($itineraryItemArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($itineraryItem) && count($itineraryItem) > 99) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 99', count($itineraryItem)), __LINE__);
        }
        $this->ItineraryItem = $itineraryItem;
        return $this;
    }
    /**
     * Add item to ItineraryItem value
     * @throws \InvalidArgumentException
     * @param mixed $item
     * @return \StructType\ItineraryItems
     */
    public function addToItineraryItem($item)
    {
        // validation for constraint: itemType
        if (false) {
            throw new \InvalidArgumentException(sprintf('The ItineraryItem property can only contain items of type anyType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($this->ItineraryItem) && count($this->ItineraryItem) >= 99) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 99', count($this->ItineraryItem)), __LINE__);
        }
        $this->ItineraryItem[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ItineraryItems
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
