<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ItineraryItemRequestType StructType
 * Meta information extracted from the WSDL
 * - documentation: Request data for any valid item of inventory.
 * @subpackage Structs
 */
class ItineraryItemRequestType extends AbstractStructBase
{
    /**
     * The Accommodation
     * Meta information extracted from the WSDL
     * - documentation: Details of an accommodation item required in the package.
     * - choice: Accommodation | Flight | RentalCar
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * @var mixed
     */
    public $Accommodation;
    /**
     * The Flight
     * Meta information extracted from the WSDL
     * - documentation: Details of a flight item required in the package.
     * - choice: Accommodation | Flight | RentalCar
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * @var mixed
     */
    public $Flight;
    /**
     * The RentalCar
     * Meta information extracted from the WSDL
     * - choice: Accommodation | Flight | RentalCar
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * @var \StructType\RentalCar
     */
    public $RentalCar;
    /**
     * The RPH
     * Meta information extracted from the WSDL
     * - documentation: (Reference Place Holder) - an index code to identify an instance in a collection of like items. For example, used to assign individual passengers or clients to particular itinerary items.
     * - use: optional
     * @var string
     */
    public $RPH;
    /**
     * Constructor method for ItineraryItemRequestType
     * @uses ItineraryItemRequestType::setAccommodation()
     * @uses ItineraryItemRequestType::setFlight()
     * @uses ItineraryItemRequestType::setRentalCar()
     * @uses ItineraryItemRequestType::setRPH()
     * @param mixed $accommodation
     * @param mixed $flight
     * @param \StructType\RentalCar $rentalCar
     * @param string $rPH
     */
    public function __construct($accommodation = null, $flight = null, \StructType\RentalCar $rentalCar = null, $rPH = null)
    {
        $this
            ->setAccommodation($accommodation)
            ->setFlight($flight)
            ->setRentalCar($rentalCar)
            ->setRPH($rPH);
    }
    /**
     * Get Accommodation value
     * @return mixed|null
     */
    public function getAccommodation()
    {
        return isset($this->Accommodation) ? $this->Accommodation : null;
    }
    /**
     * This method is responsible for validating the value passed to the setAccommodation method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAccommodation method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateAccommodationForChoiceConstraintsFromSetAccommodation($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Flight',
            'RentalCar',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Accommodation can\'t be set as the property %s is already set. Only one property must be set among these properties: Accommodation, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Accommodation value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param mixed $accommodation
     * @return \StructType\ItineraryItemRequestType
     */
    public function setAccommodation($accommodation = null)
    {
        // validation for constraint: choice(Accommodation, Flight, RentalCar)
        if ('' !== ($accommodationChoiceErrorMessage = self::validateAccommodationForChoiceConstraintsFromSetAccommodation($accommodation))) {
            throw new \InvalidArgumentException($accommodationChoiceErrorMessage, __LINE__);
        }
        if (is_null($accommodation) || (is_array($accommodation) && empty($accommodation))) {
            unset($this->Accommodation);
        } else {
            $this->Accommodation = $accommodation;
        }
        return $this;
    }
    /**
     * Get Flight value
     * @return mixed|null
     */
    public function getFlight()
    {
        return isset($this->Flight) ? $this->Flight : null;
    }
    /**
     * This method is responsible for validating the value passed to the setFlight method
     * This method is willingly generated in order to preserve the one-line inline validation within the setFlight method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateFlightForChoiceConstraintsFromSetFlight($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Accommodation',
            'RentalCar',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Flight can\'t be set as the property %s is already set. Only one property must be set among these properties: Flight, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Flight value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param mixed $flight
     * @return \StructType\ItineraryItemRequestType
     */
    public function setFlight($flight = null)
    {
        // validation for constraint: choice(Accommodation, Flight, RentalCar)
        if ('' !== ($flightChoiceErrorMessage = self::validateFlightForChoiceConstraintsFromSetFlight($flight))) {
            throw new \InvalidArgumentException($flightChoiceErrorMessage, __LINE__);
        }
        if (is_null($flight) || (is_array($flight) && empty($flight))) {
            unset($this->Flight);
        } else {
            $this->Flight = $flight;
        }
        return $this;
    }
    /**
     * Get RentalCar value
     * @return \StructType\RentalCar|null
     */
    public function getRentalCar()
    {
        return isset($this->RentalCar) ? $this->RentalCar : null;
    }
    /**
     * This method is responsible for validating the value passed to the setRentalCar method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRentalCar method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateRentalCarForChoiceConstraintsFromSetRentalCar($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Accommodation',
            'Flight',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property RentalCar can\'t be set as the property %s is already set. Only one property must be set among these properties: RentalCar, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set RentalCar value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\RentalCar $rentalCar
     * @return \StructType\ItineraryItemRequestType
     */
    public function setRentalCar(\StructType\RentalCar $rentalCar = null)
    {
        // validation for constraint: choice(Accommodation, Flight, RentalCar)
        if ('' !== ($rentalCarChoiceErrorMessage = self::validateRentalCarForChoiceConstraintsFromSetRentalCar($rentalCar))) {
            throw new \InvalidArgumentException($rentalCarChoiceErrorMessage, __LINE__);
        }
        if (is_null($rentalCar) || (is_array($rentalCar) && empty($rentalCar))) {
            unset($this->RentalCar);
        } else {
            $this->RentalCar = $rentalCar;
        }
        return $this;
    }
    /**
     * Get RPH value
     * @return string|null
     */
    public function getRPH()
    {
        return $this->RPH;
    }
    /**
     * Set RPH value
     * @param string $rPH
     * @return \StructType\ItineraryItemRequestType
     */
    public function setRPH($rPH = null)
    {
        // validation for constraint: string
        if (!is_null($rPH) && !is_string($rPH)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rPH, true), gettype($rPH)), __LINE__);
        }
        $this->RPH = $rPH;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ItineraryItemRequestType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
