<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ItemSearchCriterionType StructType
 * Meta information extracted from the WSDL
 * - documentation: Identifies the criterion for a search.
 * @subpackage Structs
 */
class ItemSearchCriterionType extends AbstractStructBase
{
    /**
     * The Position
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Position
     */
    public $Position;
    /**
     * The Address
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Address
     */
    public $Address;
    /**
     * The Telephone
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Telephone
     */
    public $Telephone;
    /**
     * The RefPoint
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\RefPoint[]
     */
    public $RefPoint;
    /**
     * The CodeRef
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\CodeRef
     */
    public $CodeRef;
    /**
     * The HotelRef
     * Meta information extracted from the WSDL
     * - maxOccurs: 99
     * - minOccurs: 0
     * @var \StructType\HotelRef[]
     */
    public $HotelRef;
    /**
     * The Radius
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Radius
     */
    public $Radius;
    /**
     * The MapArea
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\MapArea
     */
    public $MapArea;
    /**
     * The AdditionalContents
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\AdditionalContents
     */
    public $AdditionalContents;
    /**
     * The ExactMatch
     * Meta information extracted from the WSDL
     * - documentation: Values of "true" or "false", indicating whether the string of the search value must be an exact match.
     * - use: optional
     * @var bool
     */
    public $ExactMatch;
    /**
     * The ImportanceType
     * Meta information extracted from the WSDL
     * - use: optional
     * @var mixed
     */
    public $ImportanceType;
    /**
     * The Ranking
     * Meta information extracted from the WSDL
     * - documentation: Defines a ranking scale expressed as integers; meaning and scale are based on individual implementations.
     * - use: optional
     * @var int
     */
    public $Ranking;
    /**
     * Constructor method for ItemSearchCriterionType
     * @uses ItemSearchCriterionType::setPosition()
     * @uses ItemSearchCriterionType::setAddress()
     * @uses ItemSearchCriterionType::setTelephone()
     * @uses ItemSearchCriterionType::setRefPoint()
     * @uses ItemSearchCriterionType::setCodeRef()
     * @uses ItemSearchCriterionType::setHotelRef()
     * @uses ItemSearchCriterionType::setRadius()
     * @uses ItemSearchCriterionType::setMapArea()
     * @uses ItemSearchCriterionType::setAdditionalContents()
     * @uses ItemSearchCriterionType::setExactMatch()
     * @uses ItemSearchCriterionType::setImportanceType()
     * @uses ItemSearchCriterionType::setRanking()
     * @param \StructType\Position $position
     * @param \StructType\Address $address
     * @param \StructType\Telephone $telephone
     * @param \StructType\RefPoint[] $refPoint
     * @param \StructType\CodeRef $codeRef
     * @param \StructType\HotelRef[] $hotelRef
     * @param \StructType\Radius $radius
     * @param \StructType\MapArea $mapArea
     * @param \StructType\AdditionalContents $additionalContents
     * @param bool $exactMatch
     * @param mixed $importanceType
     * @param int $ranking
     */
    public function __construct(\StructType\Position $position = null, \StructType\Address $address = null, \StructType\Telephone $telephone = null, array $refPoint = array(), \StructType\CodeRef $codeRef = null, array $hotelRef = array(), \StructType\Radius $radius = null, \StructType\MapArea $mapArea = null, \StructType\AdditionalContents $additionalContents = null, $exactMatch = null, $importanceType = null, $ranking = null)
    {
        $this
            ->setPosition($position)
            ->setAddress($address)
            ->setTelephone($telephone)
            ->setRefPoint($refPoint)
            ->setCodeRef($codeRef)
            ->setHotelRef($hotelRef)
            ->setRadius($radius)
            ->setMapArea($mapArea)
            ->setAdditionalContents($additionalContents)
            ->setExactMatch($exactMatch)
            ->setImportanceType($importanceType)
            ->setRanking($ranking);
    }
    /**
     * Get Position value
     * @return \StructType\Position|null
     */
    public function getPosition()
    {
        return $this->Position;
    }
    /**
     * Set Position value
     * @param \StructType\Position $position
     * @return \StructType\ItemSearchCriterionType
     */
    public function setPosition(\StructType\Position $position = null)
    {
        $this->Position = $position;
        return $this;
    }
    /**
     * Get Address value
     * @return \StructType\Address|null
     */
    public function getAddress()
    {
        return $this->Address;
    }
    /**
     * Set Address value
     * @param \StructType\Address $address
     * @return \StructType\ItemSearchCriterionType
     */
    public function setAddress(\StructType\Address $address = null)
    {
        $this->Address = $address;
        return $this;
    }
    /**
     * Get Telephone value
     * @return \StructType\Telephone|null
     */
    public function getTelephone()
    {
        return $this->Telephone;
    }
    /**
     * Set Telephone value
     * @param \StructType\Telephone $telephone
     * @return \StructType\ItemSearchCriterionType
     */
    public function setTelephone(\StructType\Telephone $telephone = null)
    {
        $this->Telephone = $telephone;
        return $this;
    }
    /**
     * Get RefPoint value
     * @return \StructType\RefPoint[]|null
     */
    public function getRefPoint()
    {
        return $this->RefPoint;
    }
    /**
     * This method is responsible for validating the values passed to the setRefPoint method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRefPoint method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRefPointForArrayConstraintsFromSetRefPoint(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $itemSearchCriterionTypeRefPointItem) {
            // validation for constraint: itemType
            if (!$itemSearchCriterionTypeRefPointItem instanceof \StructType\RefPoint) {
                $invalidValues[] = is_object($itemSearchCriterionTypeRefPointItem) ? get_class($itemSearchCriterionTypeRefPointItem) : sprintf('%s(%s)', gettype($itemSearchCriterionTypeRefPointItem), var_export($itemSearchCriterionTypeRefPointItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The RefPoint property can only contain items of type \StructType\RefPoint, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set RefPoint value
     * @throws \InvalidArgumentException
     * @param \StructType\RefPoint[] $refPoint
     * @return \StructType\ItemSearchCriterionType
     */
    public function setRefPoint(array $refPoint = array())
    {
        // validation for constraint: array
        if ('' !== ($refPointArrayErrorMessage = self::validateRefPointForArrayConstraintsFromSetRefPoint($refPoint))) {
            throw new \InvalidArgumentException($refPointArrayErrorMessage, __LINE__);
        }
        $this->RefPoint = $refPoint;
        return $this;
    }
    /**
     * Add item to RefPoint value
     * @throws \InvalidArgumentException
     * @param \StructType\RefPoint $item
     * @return \StructType\ItemSearchCriterionType
     */
    public function addToRefPoint(\StructType\RefPoint $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\RefPoint) {
            throw new \InvalidArgumentException(sprintf('The RefPoint property can only contain items of type \StructType\RefPoint, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->RefPoint[] = $item;
        return $this;
    }
    /**
     * Get CodeRef value
     * @return \StructType\CodeRef|null
     */
    public function getCodeRef()
    {
        return $this->CodeRef;
    }
    /**
     * Set CodeRef value
     * @param \StructType\CodeRef $codeRef
     * @return \StructType\ItemSearchCriterionType
     */
    public function setCodeRef(\StructType\CodeRef $codeRef = null)
    {
        $this->CodeRef = $codeRef;
        return $this;
    }
    /**
     * Get HotelRef value
     * @return \StructType\HotelRef[]|null
     */
    public function getHotelRef()
    {
        return $this->HotelRef;
    }
    /**
     * This method is responsible for validating the values passed to the setHotelRef method
     * This method is willingly generated in order to preserve the one-line inline validation within the setHotelRef method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateHotelRefForArrayConstraintsFromSetHotelRef(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $itemSearchCriterionTypeHotelRefItem) {
            // validation for constraint: itemType
            if (!$itemSearchCriterionTypeHotelRefItem instanceof \StructType\HotelRef) {
                $invalidValues[] = is_object($itemSearchCriterionTypeHotelRefItem) ? get_class($itemSearchCriterionTypeHotelRefItem) : sprintf('%s(%s)', gettype($itemSearchCriterionTypeHotelRefItem), var_export($itemSearchCriterionTypeHotelRefItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The HotelRef property can only contain items of type \StructType\HotelRef, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set HotelRef value
     * @throws \InvalidArgumentException
     * @param \StructType\HotelRef[] $hotelRef
     * @return \StructType\ItemSearchCriterionType
     */
    public function setHotelRef(array $hotelRef = array())
    {
        // validation for constraint: array
        if ('' !== ($hotelRefArrayErrorMessage = self::validateHotelRefForArrayConstraintsFromSetHotelRef($hotelRef))) {
            throw new \InvalidArgumentException($hotelRefArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($hotelRef) && count($hotelRef) > 99) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 99', count($hotelRef)), __LINE__);
        }
        $this->HotelRef = $hotelRef;
        return $this;
    }
    /**
     * Add item to HotelRef value
     * @throws \InvalidArgumentException
     * @param \StructType\HotelRef $item
     * @return \StructType\ItemSearchCriterionType
     */
    public function addToHotelRef(\StructType\HotelRef $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\HotelRef) {
            throw new \InvalidArgumentException(sprintf('The HotelRef property can only contain items of type \StructType\HotelRef, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($this->HotelRef) && count($this->HotelRef) >= 99) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 99', count($this->HotelRef)), __LINE__);
        }
        $this->HotelRef[] = $item;
        return $this;
    }
    /**
     * Get Radius value
     * @return \StructType\Radius|null
     */
    public function getRadius()
    {
        return $this->Radius;
    }
    /**
     * Set Radius value
     * @param \StructType\Radius $radius
     * @return \StructType\ItemSearchCriterionType
     */
    public function setRadius(\StructType\Radius $radius = null)
    {
        $this->Radius = $radius;
        return $this;
    }
    /**
     * Get MapArea value
     * @return \StructType\MapArea|null
     */
    public function getMapArea()
    {
        return $this->MapArea;
    }
    /**
     * Set MapArea value
     * @param \StructType\MapArea $mapArea
     * @return \StructType\ItemSearchCriterionType
     */
    public function setMapArea(\StructType\MapArea $mapArea = null)
    {
        $this->MapArea = $mapArea;
        return $this;
    }
    /**
     * Get AdditionalContents value
     * @return \StructType\AdditionalContents|null
     */
    public function getAdditionalContents()
    {
        return $this->AdditionalContents;
    }
    /**
     * Set AdditionalContents value
     * @param \StructType\AdditionalContents $additionalContents
     * @return \StructType\ItemSearchCriterionType
     */
    public function setAdditionalContents(\StructType\AdditionalContents $additionalContents = null)
    {
        $this->AdditionalContents = $additionalContents;
        return $this;
    }
    /**
     * Get ExactMatch value
     * @return bool|null
     */
    public function getExactMatch()
    {
        return $this->ExactMatch;
    }
    /**
     * Set ExactMatch value
     * @param bool $exactMatch
     * @return \StructType\ItemSearchCriterionType
     */
    public function setExactMatch($exactMatch = null)
    {
        // validation for constraint: boolean
        if (!is_null($exactMatch) && !is_bool($exactMatch)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($exactMatch, true), gettype($exactMatch)), __LINE__);
        }
        $this->ExactMatch = $exactMatch;
        return $this;
    }
    /**
     * Get ImportanceType value
     * @return mixed|null
     */
    public function getImportanceType()
    {
        return $this->ImportanceType;
    }
    /**
     * Set ImportanceType value
     * @param mixed $importanceType
     * @return \StructType\ItemSearchCriterionType
     */
    public function setImportanceType($importanceType = null)
    {
        $this->ImportanceType = $importanceType;
        return $this;
    }
    /**
     * Get Ranking value
     * @return int|null
     */
    public function getRanking()
    {
        return $this->Ranking;
    }
    /**
     * Set Ranking value
     * @param int $ranking
     * @return \StructType\ItemSearchCriterionType
     */
    public function setRanking($ranking = null)
    {
        // validation for constraint: int
        if (!is_null($ranking) && !(is_int($ranking) || ctype_digit($ranking))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($ranking, true), gettype($ranking)), __LINE__);
        }
        $this->Ranking = $ranking;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ItemSearchCriterionType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
