<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Item StructType
 * Meta information extracted from the WSDL
 * - documentation: Example: Suitcase | Baggage item name or code.
 * @subpackage Structs
 */
class Item extends OntologyCodeType
{
    /**
     * The SpecialItemInd
     * Meta information extracted from the WSDL
     * - documentation: Implementer: If true, this is a specialty baggage item. | Example: true | Specialty baggage item indicator.
     * - use: optional
     * @var bool
     */
    public $SpecialItemInd;
    /**
     * Constructor method for Item
     * @uses Item::setSpecialItemInd()
     * @param bool $specialItemInd
     */
    public function __construct($specialItemInd = null)
    {
        $this
            ->setSpecialItemInd($specialItemInd);
    }
    /**
     * Get SpecialItemInd value
     * @return bool|null
     */
    public function getSpecialItemInd()
    {
        return $this->SpecialItemInd;
    }
    /**
     * Set SpecialItemInd value
     * @param bool $specialItemInd
     * @return \StructType\Item
     */
    public function setSpecialItemInd($specialItemInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($specialItemInd) && !is_bool($specialItemInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($specialItemInd, true), gettype($specialItemInd)), __LINE__);
        }
        $this->SpecialItemInd = $specialItemInd;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Item
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
