<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Inventory StructType
 * Meta information extracted from the WSDL
 * - documentation: Defines the inventory type for which this offer may or may not apply (e.g., room, board or extra). Used in conjunction with the AppliesToIndicator. | Defines the inventory (e.g., Room type or Board) to which the offer may or may not
 * apply. | Defines the inventory (e.g., Room type or Board) which is required in order for the offer to apply.
 * @subpackage Structs
 */
class Inventory extends AbstractStructBase
{
    /**
     * The AppliesToIndicator
     * Meta information extracted from the WSDL
     * - documentation: When true, the offer applies to the defined inventory. When false, the offer does not apply to the defined inventory.
     * - use: required
     * @var bool
     */
    public $AppliesToIndicator;
    /**
     * Constructor method for Inventory
     * @uses Inventory::setAppliesToIndicator()
     * @param bool $appliesToIndicator
     */
    public function __construct($appliesToIndicator = null)
    {
        $this
            ->setAppliesToIndicator($appliesToIndicator);
    }
    /**
     * Get AppliesToIndicator value
     * @return bool
     */
    public function getAppliesToIndicator()
    {
        return $this->AppliesToIndicator;
    }
    /**
     * Set AppliesToIndicator value
     * @param bool $appliesToIndicator
     * @return \StructType\Inventory
     */
    public function setAppliesToIndicator($appliesToIndicator = null)
    {
        // validation for constraint: boolean
        if (!is_null($appliesToIndicator) && !is_bool($appliesToIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($appliesToIndicator, true), gettype($appliesToIndicator)), __LINE__);
        }
        $this->AppliesToIndicator = $appliesToIndicator;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Inventory
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
