<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InvCounts StructType
 * Meta information extracted from the WSDL
 * - documentation: A collection of inventory counts.
 * @subpackage Structs
 */
class InvCounts extends AbstractStructBase
{
    /**
     * The InvCount
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \StructType\InvCount[]
     */
    public $InvCount;
    /**
     * Constructor method for InvCounts
     * @uses InvCounts::setInvCount()
     * @param \StructType\InvCount[] $invCount
     */
    public function __construct(array $invCount = array())
    {
        $this
            ->setInvCount($invCount);
    }
    /**
     * Get InvCount value
     * @return \StructType\InvCount[]|null
     */
    public function getInvCount()
    {
        return $this->InvCount;
    }
    /**
     * This method is responsible for validating the values passed to the setInvCount method
     * This method is willingly generated in order to preserve the one-line inline validation within the setInvCount method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateInvCountForArrayConstraintsFromSetInvCount(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $invCountsInvCountItem) {
            // validation for constraint: itemType
            if (!$invCountsInvCountItem instanceof \StructType\InvCount) {
                $invalidValues[] = is_object($invCountsInvCountItem) ? get_class($invCountsInvCountItem) : sprintf('%s(%s)', gettype($invCountsInvCountItem), var_export($invCountsInvCountItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The InvCount property can only contain items of type \StructType\InvCount, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set InvCount value
     * @throws \InvalidArgumentException
     * @param \StructType\InvCount[] $invCount
     * @return \StructType\InvCounts
     */
    public function setInvCount(array $invCount = array())
    {
        // validation for constraint: array
        if ('' !== ($invCountArrayErrorMessage = self::validateInvCountForArrayConstraintsFromSetInvCount($invCount))) {
            throw new \InvalidArgumentException($invCountArrayErrorMessage, __LINE__);
        }
        $this->InvCount = $invCount;
        return $this;
    }
    /**
     * Add item to InvCount value
     * @throws \InvalidArgumentException
     * @param \StructType\InvCount $item
     * @return \StructType\InvCounts
     */
    public function addToInvCount(\StructType\InvCount $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\InvCount) {
            throw new \InvalidArgumentException(sprintf('The InvCount property can only contain items of type \StructType\InvCount, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->InvCount[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\InvCounts
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
