<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InsurancePrefType StructType
 * Meta information extracted from the WSDL
 * - documentation: Used to specify the preference level for this insurance policy. | Identifies a preference for a travel insurance policy. | Used for Character Strings, length 1 to 64.
 * - base: xs:string
 * - maxLength: 64
 * - minLength: 1
 * @subpackage Structs
 */
class InsurancePrefType extends AbstractStructBase
{
    /**
     * The RPH
     * Meta information extracted from the WSDL
     * - documentation: Index number to be used for reference the insurance policy to be used in this travel collection.
     * - use: optional
     * @var string
     */
    public $RPH;
    /**
     * Constructor method for InsurancePrefType
     * @uses InsurancePrefType::setRPH()
     * @param string $rPH
     */
    public function __construct($rPH = null)
    {
        $this
            ->setRPH($rPH);
    }
    /**
     * Get RPH value
     * @return string|null
     */
    public function getRPH()
    {
        return $this->RPH;
    }
    /**
     * Set RPH value
     * @param string $rPH
     * @return \StructType\InsurancePrefType
     */
    public function setRPH($rPH = null)
    {
        // validation for constraint: string
        if (!is_null($rPH) && !is_string($rPH)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rPH, true), gettype($rPH)), __LINE__);
        }
        $this->RPH = $rPH;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\InsurancePrefType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
