<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ImageFormat StructType
 * Meta information extracted from the WSDL
 * - documentation: Detailed information about an image. | A set of images for a given category which may be provided in multiple formats.
 * @subpackage Structs
 */
class ImageFormat extends ImageItemType
{
    /**
     * The Language
     * Meta information extracted from the WSDL
     * - documentation: The language in which the image text is provided.
     * - use: optional
     * @var string
     */
    public $Language;
    /**
     * The Format
     * Meta information extracted from the WSDL
     * - documentation: Identifies the format of an image. Refer to OpenTravel Code List Content Format Code (CFC).
     * - use: optional
     * @var string
     */
    public $Format;
    /**
     * The FileName
     * Meta information extracted from the WSDL
     * - documentation: The name of the image file.
     * - use: optional
     * @var string
     */
    public $FileName;
    /**
     * The FileSize
     * Meta information extracted from the WSDL
     * - documentation: The size of the image file.
     * - use: optional
     * @var int
     */
    public $FileSize;
    /**
     * The DimensionCategory
     * Meta information extracted from the WSDL
     * - documentation: Associates the image size to a given category (e.g., 70x70, 100x100, 480x480, thumbnail). For example, if an image with a dimension of 72x73 is sent, it may be categorized as a 70x70 image.
     * - use: optional
     * @var string
     */
    public $DimensionCategory;
    /**
     * The IsOriginalIndicator
     * Meta information extracted from the WSDL
     * - documentation: When true, the image is the original file and format. When false, the image is not the original file and format.
     * - use: optional
     * @var bool
     */
    public $IsOriginalIndicator;
    /**
     * The AuthorContact
     * Meta information extracted from the WSDL
     * - documentation: Example: email address - John@company.com | Information to contact the author of an image.
     * @var string
     */
    public $AuthorContact;
    /**
     * The Sort
     * Meta information extracted from the WSDL
     * - documentation: Example: 1 | Used to define the display order.
     * @var int
     */
    public $Sort;
    /**
     * The Resolution
     * Meta information extracted from the WSDL
     * - documentation: Example: 600 | The resolution of an image expressed in DPI (Dots Per Inch).
     * @var int
     */
    public $Resolution;
    /**
     * The ColorSpace
     * Meta information extracted from the WSDL
     * - documentation: Implementers: A color model is an abstract mathematical model describing the way colors can be represented as multiples of numbers, typically as three or four values or color components. | Example: RGB | The color model.
     * @var string
     */
    public $ColorSpace;
    /**
     * The Latitude
     * Meta information extracted from the WSDL
     * - documentation: Example: 40°44′54.36″N | The latitude of what is depicted in the image.
     * @var string
     */
    public $Latitude;
    /**
     * The Longitude
     * Meta information extracted from the WSDL
     * - documentation: Example: 73°59′8.5″W | The longitude of what is depicted in the image.
     * @var string
     */
    public $Longitude;
    /**
     * The OriginalFileName
     * Meta information extracted from the WSDL
     * - documentation: Example: 394820 | The original name of the image file.
     * @var string
     */
    public $OriginalFileName;
    /**
     * Constructor method for ImageFormat
     * @uses ImageFormat::setLanguage()
     * @uses ImageFormat::setFormat()
     * @uses ImageFormat::setFileName()
     * @uses ImageFormat::setFileSize()
     * @uses ImageFormat::setDimensionCategory()
     * @uses ImageFormat::setIsOriginalIndicator()
     * @uses ImageFormat::setAuthorContact()
     * @uses ImageFormat::setSort()
     * @uses ImageFormat::setResolution()
     * @uses ImageFormat::setColorSpace()
     * @uses ImageFormat::setLatitude()
     * @uses ImageFormat::setLongitude()
     * @uses ImageFormat::setOriginalFileName()
     * @param string $language
     * @param string $format
     * @param string $fileName
     * @param int $fileSize
     * @param string $dimensionCategory
     * @param bool $isOriginalIndicator
     * @param string $authorContact
     * @param int $sort
     * @param int $resolution
     * @param string $colorSpace
     * @param string $latitude
     * @param string $longitude
     * @param string $originalFileName
     */
    public function __construct($language = null, $format = null, $fileName = null, $fileSize = null, $dimensionCategory = null, $isOriginalIndicator = null, $authorContact = null, $sort = null, $resolution = null, $colorSpace = null, $latitude = null, $longitude = null, $originalFileName = null)
    {
        $this
            ->setLanguage($language)
            ->setFormat($format)
            ->setFileName($fileName)
            ->setFileSize($fileSize)
            ->setDimensionCategory($dimensionCategory)
            ->setIsOriginalIndicator($isOriginalIndicator)
            ->setAuthorContact($authorContact)
            ->setSort($sort)
            ->setResolution($resolution)
            ->setColorSpace($colorSpace)
            ->setLatitude($latitude)
            ->setLongitude($longitude)
            ->setOriginalFileName($originalFileName);
    }
    /**
     * Get Language value
     * @return string|null
     */
    public function getLanguage()
    {
        return $this->Language;
    }
    /**
     * Set Language value
     * @param string $language
     * @return \StructType\ImageFormat
     */
    public function setLanguage($language = null)
    {
        // validation for constraint: string
        if (!is_null($language) && !is_string($language)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($language, true), gettype($language)), __LINE__);
        }
        $this->Language = $language;
        return $this;
    }
    /**
     * Get Format value
     * @return string|null
     */
    public function getFormat()
    {
        return $this->Format;
    }
    /**
     * Set Format value
     * @param string $format
     * @return \StructType\ImageFormat
     */
    public function setFormat($format = null)
    {
        // validation for constraint: string
        if (!is_null($format) && !is_string($format)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($format, true), gettype($format)), __LINE__);
        }
        $this->Format = $format;
        return $this;
    }
    /**
     * Get FileName value
     * @return string|null
     */
    public function getFileName()
    {
        return $this->FileName;
    }
    /**
     * Set FileName value
     * @param string $fileName
     * @return \StructType\ImageFormat
     */
    public function setFileName($fileName = null)
    {
        // validation for constraint: string
        if (!is_null($fileName) && !is_string($fileName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fileName, true), gettype($fileName)), __LINE__);
        }
        $this->FileName = $fileName;
        return $this;
    }
    /**
     * Get FileSize value
     * @return int|null
     */
    public function getFileSize()
    {
        return $this->FileSize;
    }
    /**
     * Set FileSize value
     * @param int $fileSize
     * @return \StructType\ImageFormat
     */
    public function setFileSize($fileSize = null)
    {
        // validation for constraint: int
        if (!is_null($fileSize) && !(is_int($fileSize) || ctype_digit($fileSize))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($fileSize, true), gettype($fileSize)), __LINE__);
        }
        $this->FileSize = $fileSize;
        return $this;
    }
    /**
     * Get DimensionCategory value
     * @return string|null
     */
    public function getDimensionCategory()
    {
        return $this->DimensionCategory;
    }
    /**
     * Set DimensionCategory value
     * @param string $dimensionCategory
     * @return \StructType\ImageFormat
     */
    public function setDimensionCategory($dimensionCategory = null)
    {
        // validation for constraint: string
        if (!is_null($dimensionCategory) && !is_string($dimensionCategory)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dimensionCategory, true), gettype($dimensionCategory)), __LINE__);
        }
        $this->DimensionCategory = $dimensionCategory;
        return $this;
    }
    /**
     * Get IsOriginalIndicator value
     * @return bool|null
     */
    public function getIsOriginalIndicator()
    {
        return $this->IsOriginalIndicator;
    }
    /**
     * Set IsOriginalIndicator value
     * @param bool $isOriginalIndicator
     * @return \StructType\ImageFormat
     */
    public function setIsOriginalIndicator($isOriginalIndicator = null)
    {
        // validation for constraint: boolean
        if (!is_null($isOriginalIndicator) && !is_bool($isOriginalIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isOriginalIndicator, true), gettype($isOriginalIndicator)), __LINE__);
        }
        $this->IsOriginalIndicator = $isOriginalIndicator;
        return $this;
    }
    /**
     * Get AuthorContact value
     * @return string|null
     */
    public function getAuthorContact()
    {
        return $this->AuthorContact;
    }
    /**
     * Set AuthorContact value
     * @param string $authorContact
     * @return \StructType\ImageFormat
     */
    public function setAuthorContact($authorContact = null)
    {
        // validation for constraint: string
        if (!is_null($authorContact) && !is_string($authorContact)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($authorContact, true), gettype($authorContact)), __LINE__);
        }
        $this->AuthorContact = $authorContact;
        return $this;
    }
    /**
     * Get Sort value
     * @return int|null
     */
    public function getSort()
    {
        return $this->Sort;
    }
    /**
     * Set Sort value
     * @param int $sort
     * @return \StructType\ImageFormat
     */
    public function setSort($sort = null)
    {
        // validation for constraint: int
        if (!is_null($sort) && !(is_int($sort) || ctype_digit($sort))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($sort, true), gettype($sort)), __LINE__);
        }
        $this->Sort = $sort;
        return $this;
    }
    /**
     * Get Resolution value
     * @return int|null
     */
    public function getResolution()
    {
        return $this->Resolution;
    }
    /**
     * Set Resolution value
     * @param int $resolution
     * @return \StructType\ImageFormat
     */
    public function setResolution($resolution = null)
    {
        // validation for constraint: int
        if (!is_null($resolution) && !(is_int($resolution) || ctype_digit($resolution))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($resolution, true), gettype($resolution)), __LINE__);
        }
        $this->Resolution = $resolution;
        return $this;
    }
    /**
     * Get ColorSpace value
     * @return string|null
     */
    public function getColorSpace()
    {
        return $this->ColorSpace;
    }
    /**
     * Set ColorSpace value
     * @param string $colorSpace
     * @return \StructType\ImageFormat
     */
    public function setColorSpace($colorSpace = null)
    {
        // validation for constraint: string
        if (!is_null($colorSpace) && !is_string($colorSpace)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($colorSpace, true), gettype($colorSpace)), __LINE__);
        }
        $this->ColorSpace = $colorSpace;
        return $this;
    }
    /**
     * Get Latitude value
     * @return string|null
     */
    public function getLatitude()
    {
        return $this->Latitude;
    }
    /**
     * Set Latitude value
     * @param string $latitude
     * @return \StructType\ImageFormat
     */
    public function setLatitude($latitude = null)
    {
        // validation for constraint: string
        if (!is_null($latitude) && !is_string($latitude)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($latitude, true), gettype($latitude)), __LINE__);
        }
        $this->Latitude = $latitude;
        return $this;
    }
    /**
     * Get Longitude value
     * @return string|null
     */
    public function getLongitude()
    {
        return $this->Longitude;
    }
    /**
     * Set Longitude value
     * @param string $longitude
     * @return \StructType\ImageFormat
     */
    public function setLongitude($longitude = null)
    {
        // validation for constraint: string
        if (!is_null($longitude) && !is_string($longitude)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($longitude, true), gettype($longitude)), __LINE__);
        }
        $this->Longitude = $longitude;
        return $this;
    }
    /**
     * Get OriginalFileName value
     * @return string|null
     */
    public function getOriginalFileName()
    {
        return $this->OriginalFileName;
    }
    /**
     * Set OriginalFileName value
     * @param string $originalFileName
     * @return \StructType\ImageFormat
     */
    public function setOriginalFileName($originalFileName = null)
    {
        // validation for constraint: string
        if (!is_null($originalFileName) && !is_string($originalFileName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($originalFileName, true), gettype($originalFileName)), __LINE__);
        }
        $this->OriginalFileName = $originalFileName;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ImageFormat
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
