<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Identification StructType
 * Meta information extracted from the WSDL
 * - documentation: Implementer: Exchanging this level of personal information between trading partners may be subject to state, local and government legislation and internal or negotiated data use and sharing permissions. | Identifying traveler
 * information.
 * @subpackage Structs
 */
class Identification extends AbstractStructBase
{
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - documentation: Traveler name.
     * - minOccurs: 0
     * @var mixed
     */
    public $Name;
    /**
     * The Age
     * Meta information extracted from the WSDL
     * - documentation: Traveler age and birth information.
     * - minOccurs: 0
     * @var mixed
     */
    public $Age;
    /**
     * The Address
     * Meta information extracted from the WSDL
     * - documentation: Traveler address.
     * - minOccurs: 0
     * @var mixed
     */
    public $Address;
    /**
     * The Contact
     * Meta information extracted from the WSDL
     * - documentation: Traveler contact information.
     * - minOccurs: 0
     * @var mixed
     */
    public $Contact;
    /**
     * The LoyaltyProgram
     * Meta information extracted from the WSDL
     * - documentation: Traveler loyalty program information.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var mixed[]
     */
    public $LoyaltyProgram;
    /**
     * The OntologyExtension
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: OntologyExtension
     * @var mixed
     */
    public $OntologyExtension;
    /**
     * Constructor method for Identification
     * @uses Identification::setName()
     * @uses Identification::setAge()
     * @uses Identification::setAddress()
     * @uses Identification::setContact()
     * @uses Identification::setLoyaltyProgram()
     * @uses Identification::setOntologyExtension()
     * @param mixed $name
     * @param mixed $age
     * @param mixed $address
     * @param mixed $contact
     * @param mixed[] $loyaltyProgram
     * @param mixed $ontologyExtension
     */
    public function __construct($name = null, $age = null, $address = null, $contact = null, array $loyaltyProgram = array(), $ontologyExtension = null)
    {
        $this
            ->setName($name)
            ->setAge($age)
            ->setAddress($address)
            ->setContact($contact)
            ->setLoyaltyProgram($loyaltyProgram)
            ->setOntologyExtension($ontologyExtension);
    }
    /**
     * Get Name value
     * @return mixed|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param mixed $name
     * @return \StructType\Identification
     */
    public function setName($name = null)
    {
        $this->Name = $name;
        return $this;
    }
    /**
     * Get Age value
     * @return mixed|null
     */
    public function getAge()
    {
        return $this->Age;
    }
    /**
     * Set Age value
     * @param mixed $age
     * @return \StructType\Identification
     */
    public function setAge($age = null)
    {
        $this->Age = $age;
        return $this;
    }
    /**
     * Get Address value
     * @return mixed|null
     */
    public function getAddress()
    {
        return $this->Address;
    }
    /**
     * Set Address value
     * @param mixed $address
     * @return \StructType\Identification
     */
    public function setAddress($address = null)
    {
        $this->Address = $address;
        return $this;
    }
    /**
     * Get Contact value
     * @return mixed|null
     */
    public function getContact()
    {
        return $this->Contact;
    }
    /**
     * Set Contact value
     * @param mixed $contact
     * @return \StructType\Identification
     */
    public function setContact($contact = null)
    {
        $this->Contact = $contact;
        return $this;
    }
    /**
     * Get LoyaltyProgram value
     * @return mixed[]|null
     */
    public function getLoyaltyProgram()
    {
        return $this->LoyaltyProgram;
    }
    /**
     * This method is responsible for validating the values passed to the setLoyaltyProgram method
     * This method is willingly generated in order to preserve the one-line inline validation within the setLoyaltyProgram method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateLoyaltyProgramForArrayConstraintsFromSetLoyaltyProgram(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $identificationLoyaltyProgramItem) {
            // validation for constraint: itemType
            if (false) {
                $invalidValues[] = is_object($identificationLoyaltyProgramItem) ? get_class($identificationLoyaltyProgramItem) : sprintf('%s(%s)', gettype($identificationLoyaltyProgramItem), var_export($identificationLoyaltyProgramItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The LoyaltyProgram property can only contain items of type anyType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set LoyaltyProgram value
     * @throws \InvalidArgumentException
     * @param mixed[] $loyaltyProgram
     * @return \StructType\Identification
     */
    public function setLoyaltyProgram(array $loyaltyProgram = array())
    {
        // validation for constraint: array
        if ('' !== ($loyaltyProgramArrayErrorMessage = self::validateLoyaltyProgramForArrayConstraintsFromSetLoyaltyProgram($loyaltyProgram))) {
            throw new \InvalidArgumentException($loyaltyProgramArrayErrorMessage, __LINE__);
        }
        $this->LoyaltyProgram = $loyaltyProgram;
        return $this;
    }
    /**
     * Add item to LoyaltyProgram value
     * @throws \InvalidArgumentException
     * @param mixed $item
     * @return \StructType\Identification
     */
    public function addToLoyaltyProgram($item)
    {
        // validation for constraint: itemType
        if (false) {
            throw new \InvalidArgumentException(sprintf('The LoyaltyProgram property can only contain items of type anyType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->LoyaltyProgram[] = $item;
        return $this;
    }
    /**
     * Get OntologyExtension value
     * @return mixed|null
     */
    public function getOntologyExtension()
    {
        return $this->OntologyExtension;
    }
    /**
     * Set OntologyExtension value
     * @param mixed $ontologyExtension
     * @return \StructType\Identification
     */
    public function setOntologyExtension($ontologyExtension = null)
    {
        $this->OntologyExtension = $ontologyExtension;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Identification
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
