<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for HotelSearchCriterionType StructType
 * Meta information extracted from the WSDL
 * - documentation: A collection of Profile objects or Unique IDs of Profiles.
 * @subpackage Structs
 */
class HotelSearchCriterionType extends ItemSearchCriterionType
{
    /**
     * The HotelAmenity
     * Meta information extracted from the WSDL
     * - maxOccurs: 10
     * - minOccurs: 0
     * @var \StructType\HotelAmenity[]
     */
    public $HotelAmenity;
    /**
     * The RoomAmenity
     * Meta information extracted from the WSDL
     * - documentation: Room level amenities for searches.
     * - maxOccurs: 5
     * - minOccurs: 0
     * @var mixed[]
     */
    public $RoomAmenity;
    /**
     * The HotelFeature
     * Meta information extracted from the WSDL
     * - maxOccurs: 10
     * - minOccurs: 0
     * @var \StructType\HotelFeature[]
     */
    public $HotelFeature;
    /**
     * The Award
     * Meta information extracted from the WSDL
     * - maxOccurs: 5
     * - minOccurs: 0
     * @var \StructType\Award[]
     */
    public $Award;
    /**
     * The Recreation
     * Meta information extracted from the WSDL
     * - maxOccurs: 5
     * - minOccurs: 0
     * @var \StructType\Recreation[]
     */
    public $Recreation;
    /**
     * The Service
     * Meta information extracted from the WSDL
     * - maxOccurs: 99
     * - minOccurs: 0
     * @var \StructType\Service[]
     */
    public $Service;
    /**
     * The Transportation
     * Meta information extracted from the WSDL
     * - maxOccurs: 5
     * - minOccurs: 0
     * @var \StructType\Transportation[]
     */
    public $Transportation;
    /**
     * The StayDateRange
     * Meta information extracted from the WSDL
     * - documentation: Range of dates, or fixed set of dates for Availability Request. Date range can also be specified by using start dates and number of nights (minimum, maximum or fixed).
     * - minOccurs: 0
     * @var mixed
     */
    public $StayDateRange;
    /**
     * The RateRange
     * Meta information extracted from the WSDL
     * - maxOccurs: 5
     * - minOccurs: 0
     * @var \StructType\RateRange[]
     */
    public $RateRange;
    /**
     * The RatePlanCandidates
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RatePlanCandidates
     */
    public $RatePlanCandidates;
    /**
     * The Profiles
     * Meta information extracted from the WSDL
     * - documentation: A collection of profile objects or unique IDs of profiles.
     * - minOccurs: 0
     * @var mixed
     */
    public $Profiles;
    /**
     * The RoomStayCandidates
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RoomStayCandidates
     */
    public $RoomStayCandidates;
    /**
     * The AcceptedPayments
     * Meta information extracted from the WSDL
     * - documentation: Provides the ability to search for hotel(s) based on whether they accept specific form(s) of payment.
     * - minOccurs: 0
     * @var mixed
     */
    public $AcceptedPayments;
    /**
     * The Media
     * Meta information extracted from the WSDL
     * - maxOccurs: 5
     * - minOccurs: 0
     * @var \StructType\Media[]
     */
    public $Media;
    /**
     * The HotelMeetingFacility
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\HotelMeetingFacility[]
     */
    public $HotelMeetingFacility;
    /**
     * The MealPlan
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\MealPlan
     */
    public $MealPlan;
    /**
     * The RebatePrograms
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RebatePrograms
     */
    public $RebatePrograms;
    /**
     * The UserGeneratedContent
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\UserGeneratedContent
     */
    public $UserGeneratedContent;
    /**
     * The TPA_Extensions
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: TPA_Extensions
     * @var mixed
     */
    public $TPA_Extensions;
    /**
     * Constructor method for HotelSearchCriterionType
     * @uses HotelSearchCriterionType::setHotelAmenity()
     * @uses HotelSearchCriterionType::setRoomAmenity()
     * @uses HotelSearchCriterionType::setHotelFeature()
     * @uses HotelSearchCriterionType::setAward()
     * @uses HotelSearchCriterionType::setRecreation()
     * @uses HotelSearchCriterionType::setService()
     * @uses HotelSearchCriterionType::setTransportation()
     * @uses HotelSearchCriterionType::setStayDateRange()
     * @uses HotelSearchCriterionType::setRateRange()
     * @uses HotelSearchCriterionType::setRatePlanCandidates()
     * @uses HotelSearchCriterionType::setProfiles()
     * @uses HotelSearchCriterionType::setRoomStayCandidates()
     * @uses HotelSearchCriterionType::setAcceptedPayments()
     * @uses HotelSearchCriterionType::setMedia()
     * @uses HotelSearchCriterionType::setHotelMeetingFacility()
     * @uses HotelSearchCriterionType::setMealPlan()
     * @uses HotelSearchCriterionType::setRebatePrograms()
     * @uses HotelSearchCriterionType::setUserGeneratedContent()
     * @uses HotelSearchCriterionType::setTPA_Extensions()
     * @param \StructType\HotelAmenity[] $hotelAmenity
     * @param mixed[] $roomAmenity
     * @param \StructType\HotelFeature[] $hotelFeature
     * @param \StructType\Award[] $award
     * @param \StructType\Recreation[] $recreation
     * @param \StructType\Service[] $service
     * @param \StructType\Transportation[] $transportation
     * @param mixed $stayDateRange
     * @param \StructType\RateRange[] $rateRange
     * @param \StructType\RatePlanCandidates $ratePlanCandidates
     * @param mixed $profiles
     * @param \StructType\RoomStayCandidates $roomStayCandidates
     * @param mixed $acceptedPayments
     * @param \StructType\Media[] $media
     * @param \StructType\HotelMeetingFacility[] $hotelMeetingFacility
     * @param \StructType\MealPlan $mealPlan
     * @param \StructType\RebatePrograms $rebatePrograms
     * @param \StructType\UserGeneratedContent $userGeneratedContent
     * @param mixed $tPA_Extensions
     */
    public function __construct(array $hotelAmenity = array(), array $roomAmenity = array(), array $hotelFeature = array(), array $award = array(), array $recreation = array(), array $service = array(), array $transportation = array(), $stayDateRange = null, array $rateRange = array(), \StructType\RatePlanCandidates $ratePlanCandidates = null, $profiles = null, \StructType\RoomStayCandidates $roomStayCandidates = null, $acceptedPayments = null, array $media = array(), array $hotelMeetingFacility = array(), \StructType\MealPlan $mealPlan = null, \StructType\RebatePrograms $rebatePrograms = null, \StructType\UserGeneratedContent $userGeneratedContent = null, $tPA_Extensions = null)
    {
        $this
            ->setHotelAmenity($hotelAmenity)
            ->setRoomAmenity($roomAmenity)
            ->setHotelFeature($hotelFeature)
            ->setAward($award)
            ->setRecreation($recreation)
            ->setService($service)
            ->setTransportation($transportation)
            ->setStayDateRange($stayDateRange)
            ->setRateRange($rateRange)
            ->setRatePlanCandidates($ratePlanCandidates)
            ->setProfiles($profiles)
            ->setRoomStayCandidates($roomStayCandidates)
            ->setAcceptedPayments($acceptedPayments)
            ->setMedia($media)
            ->setHotelMeetingFacility($hotelMeetingFacility)
            ->setMealPlan($mealPlan)
            ->setRebatePrograms($rebatePrograms)
            ->setUserGeneratedContent($userGeneratedContent)
            ->setTPA_Extensions($tPA_Extensions);
    }
    /**
     * Get HotelAmenity value
     * @return \StructType\HotelAmenity[]|null
     */
    public function getHotelAmenity()
    {
        return $this->HotelAmenity;
    }
    /**
     * This method is responsible for validating the values passed to the setHotelAmenity method
     * This method is willingly generated in order to preserve the one-line inline validation within the setHotelAmenity method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateHotelAmenityForArrayConstraintsFromSetHotelAmenity(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $hotelSearchCriterionTypeHotelAmenityItem) {
            // validation for constraint: itemType
            if (!$hotelSearchCriterionTypeHotelAmenityItem instanceof \StructType\HotelAmenity) {
                $invalidValues[] = is_object($hotelSearchCriterionTypeHotelAmenityItem) ? get_class($hotelSearchCriterionTypeHotelAmenityItem) : sprintf('%s(%s)', gettype($hotelSearchCriterionTypeHotelAmenityItem), var_export($hotelSearchCriterionTypeHotelAmenityItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The HotelAmenity property can only contain items of type \StructType\HotelAmenity, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set HotelAmenity value
     * @throws \InvalidArgumentException
     * @param \StructType\HotelAmenity[] $hotelAmenity
     * @return \StructType\HotelSearchCriterionType
     */
    public function setHotelAmenity(array $hotelAmenity = array())
    {
        // validation for constraint: array
        if ('' !== ($hotelAmenityArrayErrorMessage = self::validateHotelAmenityForArrayConstraintsFromSetHotelAmenity($hotelAmenity))) {
            throw new \InvalidArgumentException($hotelAmenityArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(10)
        if (is_array($hotelAmenity) && count($hotelAmenity) > 10) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 10', count($hotelAmenity)), __LINE__);
        }
        $this->HotelAmenity = $hotelAmenity;
        return $this;
    }
    /**
     * Add item to HotelAmenity value
     * @throws \InvalidArgumentException
     * @param \StructType\HotelAmenity $item
     * @return \StructType\HotelSearchCriterionType
     */
    public function addToHotelAmenity(\StructType\HotelAmenity $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\HotelAmenity) {
            throw new \InvalidArgumentException(sprintf('The HotelAmenity property can only contain items of type \StructType\HotelAmenity, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(10)
        if (is_array($this->HotelAmenity) && count($this->HotelAmenity) >= 10) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 10', count($this->HotelAmenity)), __LINE__);
        }
        $this->HotelAmenity[] = $item;
        return $this;
    }
    /**
     * Get RoomAmenity value
     * @return mixed[]|null
     */
    public function getRoomAmenity()
    {
        return $this->RoomAmenity;
    }
    /**
     * This method is responsible for validating the values passed to the setRoomAmenity method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRoomAmenity method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRoomAmenityForArrayConstraintsFromSetRoomAmenity(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $hotelSearchCriterionTypeRoomAmenityItem) {
            // validation for constraint: itemType
            if (false) {
                $invalidValues[] = is_object($hotelSearchCriterionTypeRoomAmenityItem) ? get_class($hotelSearchCriterionTypeRoomAmenityItem) : sprintf('%s(%s)', gettype($hotelSearchCriterionTypeRoomAmenityItem), var_export($hotelSearchCriterionTypeRoomAmenityItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The RoomAmenity property can only contain items of type anyType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set RoomAmenity value
     * @throws \InvalidArgumentException
     * @param mixed[] $roomAmenity
     * @return \StructType\HotelSearchCriterionType
     */
    public function setRoomAmenity(array $roomAmenity = array())
    {
        // validation for constraint: array
        if ('' !== ($roomAmenityArrayErrorMessage = self::validateRoomAmenityForArrayConstraintsFromSetRoomAmenity($roomAmenity))) {
            throw new \InvalidArgumentException($roomAmenityArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(5)
        if (is_array($roomAmenity) && count($roomAmenity) > 5) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 5', count($roomAmenity)), __LINE__);
        }
        $this->RoomAmenity = $roomAmenity;
        return $this;
    }
    /**
     * Add item to RoomAmenity value
     * @throws \InvalidArgumentException
     * @param mixed $item
     * @return \StructType\HotelSearchCriterionType
     */
    public function addToRoomAmenity($item)
    {
        // validation for constraint: itemType
        if (false) {
            throw new \InvalidArgumentException(sprintf('The RoomAmenity property can only contain items of type anyType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(5)
        if (is_array($this->RoomAmenity) && count($this->RoomAmenity) >= 5) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 5', count($this->RoomAmenity)), __LINE__);
        }
        $this->RoomAmenity[] = $item;
        return $this;
    }
    /**
     * Get HotelFeature value
     * @return \StructType\HotelFeature[]|null
     */
    public function getHotelFeature()
    {
        return $this->HotelFeature;
    }
    /**
     * This method is responsible for validating the values passed to the setHotelFeature method
     * This method is willingly generated in order to preserve the one-line inline validation within the setHotelFeature method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateHotelFeatureForArrayConstraintsFromSetHotelFeature(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $hotelSearchCriterionTypeHotelFeatureItem) {
            // validation for constraint: itemType
            if (!$hotelSearchCriterionTypeHotelFeatureItem instanceof \StructType\HotelFeature) {
                $invalidValues[] = is_object($hotelSearchCriterionTypeHotelFeatureItem) ? get_class($hotelSearchCriterionTypeHotelFeatureItem) : sprintf('%s(%s)', gettype($hotelSearchCriterionTypeHotelFeatureItem), var_export($hotelSearchCriterionTypeHotelFeatureItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The HotelFeature property can only contain items of type \StructType\HotelFeature, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set HotelFeature value
     * @throws \InvalidArgumentException
     * @param \StructType\HotelFeature[] $hotelFeature
     * @return \StructType\HotelSearchCriterionType
     */
    public function setHotelFeature(array $hotelFeature = array())
    {
        // validation for constraint: array
        if ('' !== ($hotelFeatureArrayErrorMessage = self::validateHotelFeatureForArrayConstraintsFromSetHotelFeature($hotelFeature))) {
            throw new \InvalidArgumentException($hotelFeatureArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(10)
        if (is_array($hotelFeature) && count($hotelFeature) > 10) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 10', count($hotelFeature)), __LINE__);
        }
        $this->HotelFeature = $hotelFeature;
        return $this;
    }
    /**
     * Add item to HotelFeature value
     * @throws \InvalidArgumentException
     * @param \StructType\HotelFeature $item
     * @return \StructType\HotelSearchCriterionType
     */
    public function addToHotelFeature(\StructType\HotelFeature $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\HotelFeature) {
            throw new \InvalidArgumentException(sprintf('The HotelFeature property can only contain items of type \StructType\HotelFeature, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(10)
        if (is_array($this->HotelFeature) && count($this->HotelFeature) >= 10) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 10', count($this->HotelFeature)), __LINE__);
        }
        $this->HotelFeature[] = $item;
        return $this;
    }
    /**
     * Get Award value
     * @return \StructType\Award[]|null
     */
    public function getAward()
    {
        return $this->Award;
    }
    /**
     * This method is responsible for validating the values passed to the setAward method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAward method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAwardForArrayConstraintsFromSetAward(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $hotelSearchCriterionTypeAwardItem) {
            // validation for constraint: itemType
            if (!$hotelSearchCriterionTypeAwardItem instanceof \StructType\Award) {
                $invalidValues[] = is_object($hotelSearchCriterionTypeAwardItem) ? get_class($hotelSearchCriterionTypeAwardItem) : sprintf('%s(%s)', gettype($hotelSearchCriterionTypeAwardItem), var_export($hotelSearchCriterionTypeAwardItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Award property can only contain items of type \StructType\Award, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Award value
     * @throws \InvalidArgumentException
     * @param \StructType\Award[] $award
     * @return \StructType\HotelSearchCriterionType
     */
    public function setAward(array $award = array())
    {
        // validation for constraint: array
        if ('' !== ($awardArrayErrorMessage = self::validateAwardForArrayConstraintsFromSetAward($award))) {
            throw new \InvalidArgumentException($awardArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(5)
        if (is_array($award) && count($award) > 5) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 5', count($award)), __LINE__);
        }
        $this->Award = $award;
        return $this;
    }
    /**
     * Add item to Award value
     * @throws \InvalidArgumentException
     * @param \StructType\Award $item
     * @return \StructType\HotelSearchCriterionType
     */
    public function addToAward(\StructType\Award $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Award) {
            throw new \InvalidArgumentException(sprintf('The Award property can only contain items of type \StructType\Award, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(5)
        if (is_array($this->Award) && count($this->Award) >= 5) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 5', count($this->Award)), __LINE__);
        }
        $this->Award[] = $item;
        return $this;
    }
    /**
     * Get Recreation value
     * @return \StructType\Recreation[]|null
     */
    public function getRecreation()
    {
        return $this->Recreation;
    }
    /**
     * This method is responsible for validating the values passed to the setRecreation method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRecreation method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRecreationForArrayConstraintsFromSetRecreation(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $hotelSearchCriterionTypeRecreationItem) {
            // validation for constraint: itemType
            if (!$hotelSearchCriterionTypeRecreationItem instanceof \StructType\Recreation) {
                $invalidValues[] = is_object($hotelSearchCriterionTypeRecreationItem) ? get_class($hotelSearchCriterionTypeRecreationItem) : sprintf('%s(%s)', gettype($hotelSearchCriterionTypeRecreationItem), var_export($hotelSearchCriterionTypeRecreationItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Recreation property can only contain items of type \StructType\Recreation, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Recreation value
     * @throws \InvalidArgumentException
     * @param \StructType\Recreation[] $recreation
     * @return \StructType\HotelSearchCriterionType
     */
    public function setRecreation(array $recreation = array())
    {
        // validation for constraint: array
        if ('' !== ($recreationArrayErrorMessage = self::validateRecreationForArrayConstraintsFromSetRecreation($recreation))) {
            throw new \InvalidArgumentException($recreationArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(5)
        if (is_array($recreation) && count($recreation) > 5) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 5', count($recreation)), __LINE__);
        }
        $this->Recreation = $recreation;
        return $this;
    }
    /**
     * Add item to Recreation value
     * @throws \InvalidArgumentException
     * @param \StructType\Recreation $item
     * @return \StructType\HotelSearchCriterionType
     */
    public function addToRecreation(\StructType\Recreation $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Recreation) {
            throw new \InvalidArgumentException(sprintf('The Recreation property can only contain items of type \StructType\Recreation, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(5)
        if (is_array($this->Recreation) && count($this->Recreation) >= 5) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 5', count($this->Recreation)), __LINE__);
        }
        $this->Recreation[] = $item;
        return $this;
    }
    /**
     * Get Service value
     * @return \StructType\Service[]|null
     */
    public function getService()
    {
        return $this->Service;
    }
    /**
     * This method is responsible for validating the values passed to the setService method
     * This method is willingly generated in order to preserve the one-line inline validation within the setService method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateServiceForArrayConstraintsFromSetService(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $hotelSearchCriterionTypeServiceItem) {
            // validation for constraint: itemType
            if (!$hotelSearchCriterionTypeServiceItem instanceof \StructType\Service) {
                $invalidValues[] = is_object($hotelSearchCriterionTypeServiceItem) ? get_class($hotelSearchCriterionTypeServiceItem) : sprintf('%s(%s)', gettype($hotelSearchCriterionTypeServiceItem), var_export($hotelSearchCriterionTypeServiceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Service property can only contain items of type \StructType\Service, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Service value
     * @throws \InvalidArgumentException
     * @param \StructType\Service[] $service
     * @return \StructType\HotelSearchCriterionType
     */
    public function setService(array $service = array())
    {
        // validation for constraint: array
        if ('' !== ($serviceArrayErrorMessage = self::validateServiceForArrayConstraintsFromSetService($service))) {
            throw new \InvalidArgumentException($serviceArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($service) && count($service) > 99) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 99', count($service)), __LINE__);
        }
        $this->Service = $service;
        return $this;
    }
    /**
     * Add item to Service value
     * @throws \InvalidArgumentException
     * @param \StructType\Service $item
     * @return \StructType\HotelSearchCriterionType
     */
    public function addToService(\StructType\Service $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Service) {
            throw new \InvalidArgumentException(sprintf('The Service property can only contain items of type \StructType\Service, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($this->Service) && count($this->Service) >= 99) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 99', count($this->Service)), __LINE__);
        }
        $this->Service[] = $item;
        return $this;
    }
    /**
     * Get Transportation value
     * @return \StructType\Transportation[]|null
     */
    public function getTransportation()
    {
        return $this->Transportation;
    }
    /**
     * This method is responsible for validating the values passed to the setTransportation method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTransportation method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTransportationForArrayConstraintsFromSetTransportation(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $hotelSearchCriterionTypeTransportationItem) {
            // validation for constraint: itemType
            if (!$hotelSearchCriterionTypeTransportationItem instanceof \StructType\Transportation) {
                $invalidValues[] = is_object($hotelSearchCriterionTypeTransportationItem) ? get_class($hotelSearchCriterionTypeTransportationItem) : sprintf('%s(%s)', gettype($hotelSearchCriterionTypeTransportationItem), var_export($hotelSearchCriterionTypeTransportationItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Transportation property can only contain items of type \StructType\Transportation, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Transportation value
     * @throws \InvalidArgumentException
     * @param \StructType\Transportation[] $transportation
     * @return \StructType\HotelSearchCriterionType
     */
    public function setTransportation(array $transportation = array())
    {
        // validation for constraint: array
        if ('' !== ($transportationArrayErrorMessage = self::validateTransportationForArrayConstraintsFromSetTransportation($transportation))) {
            throw new \InvalidArgumentException($transportationArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(5)
        if (is_array($transportation) && count($transportation) > 5) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 5', count($transportation)), __LINE__);
        }
        $this->Transportation = $transportation;
        return $this;
    }
    /**
     * Add item to Transportation value
     * @throws \InvalidArgumentException
     * @param \StructType\Transportation $item
     * @return \StructType\HotelSearchCriterionType
     */
    public function addToTransportation(\StructType\Transportation $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Transportation) {
            throw new \InvalidArgumentException(sprintf('The Transportation property can only contain items of type \StructType\Transportation, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(5)
        if (is_array($this->Transportation) && count($this->Transportation) >= 5) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 5', count($this->Transportation)), __LINE__);
        }
        $this->Transportation[] = $item;
        return $this;
    }
    /**
     * Get StayDateRange value
     * @return mixed|null
     */
    public function getStayDateRange()
    {
        return $this->StayDateRange;
    }
    /**
     * Set StayDateRange value
     * @param mixed $stayDateRange
     * @return \StructType\HotelSearchCriterionType
     */
    public function setStayDateRange($stayDateRange = null)
    {
        $this->StayDateRange = $stayDateRange;
        return $this;
    }
    /**
     * Get RateRange value
     * @return \StructType\RateRange[]|null
     */
    public function getRateRange()
    {
        return $this->RateRange;
    }
    /**
     * This method is responsible for validating the values passed to the setRateRange method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRateRange method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRateRangeForArrayConstraintsFromSetRateRange(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $hotelSearchCriterionTypeRateRangeItem) {
            // validation for constraint: itemType
            if (!$hotelSearchCriterionTypeRateRangeItem instanceof \StructType\RateRange) {
                $invalidValues[] = is_object($hotelSearchCriterionTypeRateRangeItem) ? get_class($hotelSearchCriterionTypeRateRangeItem) : sprintf('%s(%s)', gettype($hotelSearchCriterionTypeRateRangeItem), var_export($hotelSearchCriterionTypeRateRangeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The RateRange property can only contain items of type \StructType\RateRange, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set RateRange value
     * @throws \InvalidArgumentException
     * @param \StructType\RateRange[] $rateRange
     * @return \StructType\HotelSearchCriterionType
     */
    public function setRateRange(array $rateRange = array())
    {
        // validation for constraint: array
        if ('' !== ($rateRangeArrayErrorMessage = self::validateRateRangeForArrayConstraintsFromSetRateRange($rateRange))) {
            throw new \InvalidArgumentException($rateRangeArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(5)
        if (is_array($rateRange) && count($rateRange) > 5) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 5', count($rateRange)), __LINE__);
        }
        $this->RateRange = $rateRange;
        return $this;
    }
    /**
     * Add item to RateRange value
     * @throws \InvalidArgumentException
     * @param \StructType\RateRange $item
     * @return \StructType\HotelSearchCriterionType
     */
    public function addToRateRange(\StructType\RateRange $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\RateRange) {
            throw new \InvalidArgumentException(sprintf('The RateRange property can only contain items of type \StructType\RateRange, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(5)
        if (is_array($this->RateRange) && count($this->RateRange) >= 5) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 5', count($this->RateRange)), __LINE__);
        }
        $this->RateRange[] = $item;
        return $this;
    }
    /**
     * Get RatePlanCandidates value
     * @return \StructType\RatePlanCandidates|null
     */
    public function getRatePlanCandidates()
    {
        return $this->RatePlanCandidates;
    }
    /**
     * Set RatePlanCandidates value
     * @param \StructType\RatePlanCandidates $ratePlanCandidates
     * @return \StructType\HotelSearchCriterionType
     */
    public function setRatePlanCandidates(\StructType\RatePlanCandidates $ratePlanCandidates = null)
    {
        $this->RatePlanCandidates = $ratePlanCandidates;
        return $this;
    }
    /**
     * Get Profiles value
     * @return mixed|null
     */
    public function getProfiles()
    {
        return $this->Profiles;
    }
    /**
     * Set Profiles value
     * @param mixed $profiles
     * @return \StructType\HotelSearchCriterionType
     */
    public function setProfiles($profiles = null)
    {
        $this->Profiles = $profiles;
        return $this;
    }
    /**
     * Get RoomStayCandidates value
     * @return \StructType\RoomStayCandidates|null
     */
    public function getRoomStayCandidates()
    {
        return $this->RoomStayCandidates;
    }
    /**
     * Set RoomStayCandidates value
     * @param \StructType\RoomStayCandidates $roomStayCandidates
     * @return \StructType\HotelSearchCriterionType
     */
    public function setRoomStayCandidates(\StructType\RoomStayCandidates $roomStayCandidates = null)
    {
        $this->RoomStayCandidates = $roomStayCandidates;
        return $this;
    }
    /**
     * Get AcceptedPayments value
     * @return mixed|null
     */
    public function getAcceptedPayments()
    {
        return $this->AcceptedPayments;
    }
    /**
     * Set AcceptedPayments value
     * @param mixed $acceptedPayments
     * @return \StructType\HotelSearchCriterionType
     */
    public function setAcceptedPayments($acceptedPayments = null)
    {
        $this->AcceptedPayments = $acceptedPayments;
        return $this;
    }
    /**
     * Get Media value
     * @return \StructType\Media[]|null
     */
    public function getMedia()
    {
        return $this->Media;
    }
    /**
     * This method is responsible for validating the values passed to the setMedia method
     * This method is willingly generated in order to preserve the one-line inline validation within the setMedia method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateMediaForArrayConstraintsFromSetMedia(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $hotelSearchCriterionTypeMediaItem) {
            // validation for constraint: itemType
            if (!$hotelSearchCriterionTypeMediaItem instanceof \StructType\Media) {
                $invalidValues[] = is_object($hotelSearchCriterionTypeMediaItem) ? get_class($hotelSearchCriterionTypeMediaItem) : sprintf('%s(%s)', gettype($hotelSearchCriterionTypeMediaItem), var_export($hotelSearchCriterionTypeMediaItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Media property can only contain items of type \StructType\Media, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Media value
     * @throws \InvalidArgumentException
     * @param \StructType\Media[] $media
     * @return \StructType\HotelSearchCriterionType
     */
    public function setMedia(array $media = array())
    {
        // validation for constraint: array
        if ('' !== ($mediaArrayErrorMessage = self::validateMediaForArrayConstraintsFromSetMedia($media))) {
            throw new \InvalidArgumentException($mediaArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(5)
        if (is_array($media) && count($media) > 5) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 5', count($media)), __LINE__);
        }
        $this->Media = $media;
        return $this;
    }
    /**
     * Add item to Media value
     * @throws \InvalidArgumentException
     * @param \StructType\Media $item
     * @return \StructType\HotelSearchCriterionType
     */
    public function addToMedia(\StructType\Media $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Media) {
            throw new \InvalidArgumentException(sprintf('The Media property can only contain items of type \StructType\Media, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(5)
        if (is_array($this->Media) && count($this->Media) >= 5) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 5', count($this->Media)), __LINE__);
        }
        $this->Media[] = $item;
        return $this;
    }
    /**
     * Get HotelMeetingFacility value
     * @return \StructType\HotelMeetingFacility[]|null
     */
    public function getHotelMeetingFacility()
    {
        return $this->HotelMeetingFacility;
    }
    /**
     * This method is responsible for validating the values passed to the setHotelMeetingFacility method
     * This method is willingly generated in order to preserve the one-line inline validation within the setHotelMeetingFacility method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateHotelMeetingFacilityForArrayConstraintsFromSetHotelMeetingFacility(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $hotelSearchCriterionTypeHotelMeetingFacilityItem) {
            // validation for constraint: itemType
            if (!$hotelSearchCriterionTypeHotelMeetingFacilityItem instanceof \StructType\HotelMeetingFacility) {
                $invalidValues[] = is_object($hotelSearchCriterionTypeHotelMeetingFacilityItem) ? get_class($hotelSearchCriterionTypeHotelMeetingFacilityItem) : sprintf('%s(%s)', gettype($hotelSearchCriterionTypeHotelMeetingFacilityItem), var_export($hotelSearchCriterionTypeHotelMeetingFacilityItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The HotelMeetingFacility property can only contain items of type \StructType\HotelMeetingFacility, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set HotelMeetingFacility value
     * @throws \InvalidArgumentException
     * @param \StructType\HotelMeetingFacility[] $hotelMeetingFacility
     * @return \StructType\HotelSearchCriterionType
     */
    public function setHotelMeetingFacility(array $hotelMeetingFacility = array())
    {
        // validation for constraint: array
        if ('' !== ($hotelMeetingFacilityArrayErrorMessage = self::validateHotelMeetingFacilityForArrayConstraintsFromSetHotelMeetingFacility($hotelMeetingFacility))) {
            throw new \InvalidArgumentException($hotelMeetingFacilityArrayErrorMessage, __LINE__);
        }
        $this->HotelMeetingFacility = $hotelMeetingFacility;
        return $this;
    }
    /**
     * Add item to HotelMeetingFacility value
     * @throws \InvalidArgumentException
     * @param \StructType\HotelMeetingFacility $item
     * @return \StructType\HotelSearchCriterionType
     */
    public function addToHotelMeetingFacility(\StructType\HotelMeetingFacility $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\HotelMeetingFacility) {
            throw new \InvalidArgumentException(sprintf('The HotelMeetingFacility property can only contain items of type \StructType\HotelMeetingFacility, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->HotelMeetingFacility[] = $item;
        return $this;
    }
    /**
     * Get MealPlan value
     * @return \StructType\MealPlan|null
     */
    public function getMealPlan()
    {
        return $this->MealPlan;
    }
    /**
     * Set MealPlan value
     * @param \StructType\MealPlan $mealPlan
     * @return \StructType\HotelSearchCriterionType
     */
    public function setMealPlan(\StructType\MealPlan $mealPlan = null)
    {
        $this->MealPlan = $mealPlan;
        return $this;
    }
    /**
     * Get RebatePrograms value
     * @return \StructType\RebatePrograms|null
     */
    public function getRebatePrograms()
    {
        return $this->RebatePrograms;
    }
    /**
     * Set RebatePrograms value
     * @param \StructType\RebatePrograms $rebatePrograms
     * @return \StructType\HotelSearchCriterionType
     */
    public function setRebatePrograms(\StructType\RebatePrograms $rebatePrograms = null)
    {
        $this->RebatePrograms = $rebatePrograms;
        return $this;
    }
    /**
     * Get UserGeneratedContent value
     * @return \StructType\UserGeneratedContent|null
     */
    public function getUserGeneratedContent()
    {
        return $this->UserGeneratedContent;
    }
    /**
     * Set UserGeneratedContent value
     * @param \StructType\UserGeneratedContent $userGeneratedContent
     * @return \StructType\HotelSearchCriterionType
     */
    public function setUserGeneratedContent(\StructType\UserGeneratedContent $userGeneratedContent = null)
    {
        $this->UserGeneratedContent = $userGeneratedContent;
        return $this;
    }
    /**
     * Get TPA_Extensions value
     * @return mixed|null
     */
    public function getTPA_Extensions()
    {
        return $this->TPA_Extensions;
    }
    /**
     * Set TPA_Extensions value
     * @param mixed $tPA_Extensions
     * @return \StructType\HotelSearchCriterionType
     */
    public function setTPA_Extensions($tPA_Extensions = null)
    {
        $this->TPA_Extensions = $tPA_Extensions;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\HotelSearchCriterionType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
