<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for HotelResModifyType StructType
 * Meta information extracted from the WSDL
 * - documentation: Full structure of a hotel reservation modification.
 * @subpackage Structs
 */
class HotelResModifyType extends AbstractStructBase
{
    /**
     * The HotelResModify
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \StructType\HotelResModify[]
     */
    public $HotelResModify;
    /**
     * The RoutingHops
     * Meta information extracted from the WSDL
     * - documentation: A collection of routing hops.
     * - minOccurs: 0
     * @var mixed
     */
    public $RoutingHops;
    /**
     * The WrittenConfInst
     * Meta information extracted from the WSDL
     * - documentation: To indicate a confirmation is to be sent for this batch of reservations.
     * - minOccurs: 0
     * @var mixed
     */
    public $WrittenConfInst;
    /**
     * The TPA_Extensions
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: TPA_Extensions
     * @var mixed
     */
    public $TPA_Extensions;
    /**
     * Constructor method for HotelResModifyType
     * @uses HotelResModifyType::setHotelResModify()
     * @uses HotelResModifyType::setRoutingHops()
     * @uses HotelResModifyType::setWrittenConfInst()
     * @uses HotelResModifyType::setTPA_Extensions()
     * @param \StructType\HotelResModify[] $hotelResModify
     * @param mixed $routingHops
     * @param mixed $writtenConfInst
     * @param mixed $tPA_Extensions
     */
    public function __construct(array $hotelResModify = array(), $routingHops = null, $writtenConfInst = null, $tPA_Extensions = null)
    {
        $this
            ->setHotelResModify($hotelResModify)
            ->setRoutingHops($routingHops)
            ->setWrittenConfInst($writtenConfInst)
            ->setTPA_Extensions($tPA_Extensions);
    }
    /**
     * Get HotelResModify value
     * @return \StructType\HotelResModify[]|null
     */
    public function getHotelResModify()
    {
        return $this->HotelResModify;
    }
    /**
     * This method is responsible for validating the values passed to the setHotelResModify method
     * This method is willingly generated in order to preserve the one-line inline validation within the setHotelResModify method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateHotelResModifyForArrayConstraintsFromSetHotelResModify(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $hotelResModifyTypeHotelResModifyItem) {
            // validation for constraint: itemType
            if (!$hotelResModifyTypeHotelResModifyItem instanceof \StructType\HotelResModify) {
                $invalidValues[] = is_object($hotelResModifyTypeHotelResModifyItem) ? get_class($hotelResModifyTypeHotelResModifyItem) : sprintf('%s(%s)', gettype($hotelResModifyTypeHotelResModifyItem), var_export($hotelResModifyTypeHotelResModifyItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The HotelResModify property can only contain items of type \StructType\HotelResModify, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set HotelResModify value
     * @throws \InvalidArgumentException
     * @param \StructType\HotelResModify[] $hotelResModify
     * @return \StructType\HotelResModifyType
     */
    public function setHotelResModify(array $hotelResModify = array())
    {
        // validation for constraint: array
        if ('' !== ($hotelResModifyArrayErrorMessage = self::validateHotelResModifyForArrayConstraintsFromSetHotelResModify($hotelResModify))) {
            throw new \InvalidArgumentException($hotelResModifyArrayErrorMessage, __LINE__);
        }
        $this->HotelResModify = $hotelResModify;
        return $this;
    }
    /**
     * Add item to HotelResModify value
     * @throws \InvalidArgumentException
     * @param \StructType\HotelResModify $item
     * @return \StructType\HotelResModifyType
     */
    public function addToHotelResModify(\StructType\HotelResModify $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\HotelResModify) {
            throw new \InvalidArgumentException(sprintf('The HotelResModify property can only contain items of type \StructType\HotelResModify, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->HotelResModify[] = $item;
        return $this;
    }
    /**
     * Get RoutingHops value
     * @return mixed|null
     */
    public function getRoutingHops()
    {
        return $this->RoutingHops;
    }
    /**
     * Set RoutingHops value
     * @param mixed $routingHops
     * @return \StructType\HotelResModifyType
     */
    public function setRoutingHops($routingHops = null)
    {
        $this->RoutingHops = $routingHops;
        return $this;
    }
    /**
     * Get WrittenConfInst value
     * @return mixed|null
     */
    public function getWrittenConfInst()
    {
        return $this->WrittenConfInst;
    }
    /**
     * Set WrittenConfInst value
     * @param mixed $writtenConfInst
     * @return \StructType\HotelResModifyType
     */
    public function setWrittenConfInst($writtenConfInst = null)
    {
        $this->WrittenConfInst = $writtenConfInst;
        return $this;
    }
    /**
     * Get TPA_Extensions value
     * @return mixed|null
     */
    public function getTPA_Extensions()
    {
        return $this->TPA_Extensions;
    }
    /**
     * Set TPA_Extensions value
     * @param mixed $tPA_Extensions
     * @return \StructType\HotelResModifyType
     */
    public function setTPA_Extensions($tPA_Extensions = null)
    {
        $this->TPA_Extensions = $tPA_Extensions;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\HotelResModifyType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
