<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for HotelResModifyResponseType StructType
 * Meta information extracted from the WSDL
 * - documentation: This is the response message for a full overlay modification to a reservation. The response could be as simple as indicating the modification was made or as complex as echoing back all reservation information.
 * @subpackage Structs
 */
class HotelResModifyResponseType extends AbstractStructBase
{
    /**
     * The POS
     * Meta information extracted from the WSDL
     * - documentation: Point of sale object.
     * - minOccurs: 0
     * @var mixed
     */
    public $POS;
    /**
     * The Success
     * Meta information extracted from the WSDL
     * - choice: Success | Warnings | HotelResModifies | Errors
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * @var mixed
     */
    public $Success;
    /**
     * The Warnings
     * Meta information extracted from the WSDL
     * - documentation: This is a place to list any non-fatal errors.
     * - choice: Success | Warnings | HotelResModifies | Errors
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - minOccurs: 0
     * @var mixed
     */
    public $Warnings;
    /**
     * The HotelResModifies
     * Meta information extracted from the WSDL
     * - documentation: A collection of reservations which have been modified.
     * - choice: Success | Warnings | HotelResModifies | Errors
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - minOccurs: 0
     * @var mixed
     */
    public $HotelResModifies;
    /**
     * The Errors
     * Meta information extracted from the WSDL
     * - choice: Success | Warnings | HotelResModifies | Errors
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * @var mixed
     */
    public $Errors;
    /**
     * The ResResponseType
     * @var string
     */
    public $ResResponseType;
    /**
     * Constructor method for HotelResModifyResponseType
     * @uses HotelResModifyResponseType::setPOS()
     * @uses HotelResModifyResponseType::setSuccess()
     * @uses HotelResModifyResponseType::setWarnings()
     * @uses HotelResModifyResponseType::setHotelResModifies()
     * @uses HotelResModifyResponseType::setErrors()
     * @uses HotelResModifyResponseType::setResResponseType()
     * @param mixed $pOS
     * @param mixed $success
     * @param mixed $warnings
     * @param mixed $hotelResModifies
     * @param mixed $errors
     * @param string $resResponseType
     */
    public function __construct($pOS = null, $success = null, $warnings = null, $hotelResModifies = null, $errors = null, $resResponseType = null)
    {
        $this
            ->setPOS($pOS)
            ->setSuccess($success)
            ->setWarnings($warnings)
            ->setHotelResModifies($hotelResModifies)
            ->setErrors($errors)
            ->setResResponseType($resResponseType);
    }
    /**
     * Get POS value
     * @return mixed|null
     */
    public function getPOS()
    {
        return $this->POS;
    }
    /**
     * Set POS value
     * @param mixed $pOS
     * @return \StructType\HotelResModifyResponseType
     */
    public function setPOS($pOS = null)
    {
        $this->POS = $pOS;
        return $this;
    }
    /**
     * Get Success value
     * @return mixed|null
     */
    public function getSuccess()
    {
        return isset($this->Success) ? $this->Success : null;
    }
    /**
     * This method is responsible for validating the value passed to the setSuccess method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSuccess method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateSuccessForChoiceConstraintsFromSetSuccess($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Warnings',
            'HotelResModifies',
            'Errors',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Success can\'t be set as the property %s is already set. Only one property must be set among these properties: Success, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Success value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param mixed $success
     * @return \StructType\HotelResModifyResponseType
     */
    public function setSuccess($success = null)
    {
        // validation for constraint: choice(Success, Warnings, HotelResModifies, Errors)
        if ('' !== ($successChoiceErrorMessage = self::validateSuccessForChoiceConstraintsFromSetSuccess($success))) {
            throw new \InvalidArgumentException($successChoiceErrorMessage, __LINE__);
        }
        if (is_null($success) || (is_array($success) && empty($success))) {
            unset($this->Success);
        } else {
            $this->Success = $success;
        }
        return $this;
    }
    /**
     * Get Warnings value
     * @return mixed|null
     */
    public function getWarnings()
    {
        return isset($this->Warnings) ? $this->Warnings : null;
    }
    /**
     * This method is responsible for validating the value passed to the setWarnings method
     * This method is willingly generated in order to preserve the one-line inline validation within the setWarnings method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateWarningsForChoiceConstraintsFromSetWarnings($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Success',
            'HotelResModifies',
            'Errors',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Warnings can\'t be set as the property %s is already set. Only one property must be set among these properties: Warnings, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Warnings value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param mixed $warnings
     * @return \StructType\HotelResModifyResponseType
     */
    public function setWarnings($warnings = null)
    {
        // validation for constraint: choice(Success, Warnings, HotelResModifies, Errors)
        if ('' !== ($warningsChoiceErrorMessage = self::validateWarningsForChoiceConstraintsFromSetWarnings($warnings))) {
            throw new \InvalidArgumentException($warningsChoiceErrorMessage, __LINE__);
        }
        if (is_null($warnings) || (is_array($warnings) && empty($warnings))) {
            unset($this->Warnings);
        } else {
            $this->Warnings = $warnings;
        }
        return $this;
    }
    /**
     * Get HotelResModifies value
     * @return mixed|null
     */
    public function getHotelResModifies()
    {
        return isset($this->HotelResModifies) ? $this->HotelResModifies : null;
    }
    /**
     * This method is responsible for validating the value passed to the setHotelResModifies method
     * This method is willingly generated in order to preserve the one-line inline validation within the setHotelResModifies method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateHotelResModifiesForChoiceConstraintsFromSetHotelResModifies($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Success',
            'Warnings',
            'Errors',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property HotelResModifies can\'t be set as the property %s is already set. Only one property must be set among these properties: HotelResModifies, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set HotelResModifies value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param mixed $hotelResModifies
     * @return \StructType\HotelResModifyResponseType
     */
    public function setHotelResModifies($hotelResModifies = null)
    {
        // validation for constraint: choice(Success, Warnings, HotelResModifies, Errors)
        if ('' !== ($hotelResModifiesChoiceErrorMessage = self::validateHotelResModifiesForChoiceConstraintsFromSetHotelResModifies($hotelResModifies))) {
            throw new \InvalidArgumentException($hotelResModifiesChoiceErrorMessage, __LINE__);
        }
        if (is_null($hotelResModifies) || (is_array($hotelResModifies) && empty($hotelResModifies))) {
            unset($this->HotelResModifies);
        } else {
            $this->HotelResModifies = $hotelResModifies;
        }
        return $this;
    }
    /**
     * Get Errors value
     * @return mixed|null
     */
    public function getErrors()
    {
        return isset($this->Errors) ? $this->Errors : null;
    }
    /**
     * This method is responsible for validating the value passed to the setErrors method
     * This method is willingly generated in order to preserve the one-line inline validation within the setErrors method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateErrorsForChoiceConstraintsFromSetErrors($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Success',
            'Warnings',
            'HotelResModifies',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Errors can\'t be set as the property %s is already set. Only one property must be set among these properties: Errors, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Errors value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param mixed $errors
     * @return \StructType\HotelResModifyResponseType
     */
    public function setErrors($errors = null)
    {
        // validation for constraint: choice(Success, Warnings, HotelResModifies, Errors)
        if ('' !== ($errorsChoiceErrorMessage = self::validateErrorsForChoiceConstraintsFromSetErrors($errors))) {
            throw new \InvalidArgumentException($errorsChoiceErrorMessage, __LINE__);
        }
        if (is_null($errors) || (is_array($errors) && empty($errors))) {
            unset($this->Errors);
        } else {
            $this->Errors = $errors;
        }
        return $this;
    }
    /**
     * Get ResResponseType value
     * @return string|null
     */
    public function getResResponseType()
    {
        return $this->ResResponseType;
    }
    /**
     * Set ResResponseType value
     * @uses \EnumType\TransactionStatusType::valueIsValid()
     * @uses \EnumType\TransactionStatusType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $resResponseType
     * @return \StructType\HotelResModifyResponseType
     */
    public function setResResponseType($resResponseType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\TransactionStatusType::valueIsValid($resResponseType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\TransactionStatusType', is_array($resResponseType) ? implode(', ', $resResponseType) : var_export($resResponseType, true), implode(', ', \EnumType\TransactionStatusType::getValidValues())), __LINE__);
        }
        $this->ResResponseType = $resResponseType;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\HotelResModifyResponseType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
