<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for HotelNotifReport StructType
 * Meta information extracted from the WSDL
 * - documentation: Used to provide business details regarding processing of a previous hotel message.
 * @subpackage Structs
 */
class HotelNotifReport extends AbstractStructBase
{
    /**
     * The HotelReservations
     * Meta information extracted from the WSDL
     * - choice: HotelReservations | AvailStatusMessages | RateAmountMessages | HotelDescriptiveContents
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - minOccurs: 0
     * @var \StructType\HotelReservations
     */
    public $HotelReservations;
    /**
     * The AvailStatusMessages
     * Meta information extracted from the WSDL
     * - choice: HotelReservations | AvailStatusMessages | RateAmountMessages | HotelDescriptiveContents
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - minOccurs: 0
     * @var \StructType\AvailStatusMessages
     */
    public $AvailStatusMessages;
    /**
     * The RateAmountMessages
     * Meta information extracted from the WSDL
     * - choice: HotelReservations | AvailStatusMessages | RateAmountMessages | HotelDescriptiveContents
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - minOccurs: 0
     * @var \StructType\RateAmountMessages
     */
    public $RateAmountMessages;
    /**
     * The HotelDescriptiveContents
     * Meta information extracted from the WSDL
     * - choice: HotelReservations | AvailStatusMessages | RateAmountMessages | HotelDescriptiveContents
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - minOccurs: 0
     * @var \StructType\HotelDescriptiveContents
     */
    public $HotelDescriptiveContents;
    /**
     * Constructor method for HotelNotifReport
     * @uses HotelNotifReport::setHotelReservations()
     * @uses HotelNotifReport::setAvailStatusMessages()
     * @uses HotelNotifReport::setRateAmountMessages()
     * @uses HotelNotifReport::setHotelDescriptiveContents()
     * @param \StructType\HotelReservations $hotelReservations
     * @param \StructType\AvailStatusMessages $availStatusMessages
     * @param \StructType\RateAmountMessages $rateAmountMessages
     * @param \StructType\HotelDescriptiveContents $hotelDescriptiveContents
     */
    public function __construct(\StructType\HotelReservations $hotelReservations = null, \StructType\AvailStatusMessages $availStatusMessages = null, \StructType\RateAmountMessages $rateAmountMessages = null, \StructType\HotelDescriptiveContents $hotelDescriptiveContents = null)
    {
        $this
            ->setHotelReservations($hotelReservations)
            ->setAvailStatusMessages($availStatusMessages)
            ->setRateAmountMessages($rateAmountMessages)
            ->setHotelDescriptiveContents($hotelDescriptiveContents);
    }
    /**
     * Get HotelReservations value
     * @return \StructType\HotelReservations|null
     */
    public function getHotelReservations()
    {
        return isset($this->HotelReservations) ? $this->HotelReservations : null;
    }
    /**
     * This method is responsible for validating the value passed to the setHotelReservations method
     * This method is willingly generated in order to preserve the one-line inline validation within the setHotelReservations method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateHotelReservationsForChoiceConstraintsFromSetHotelReservations($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'AvailStatusMessages',
            'RateAmountMessages',
            'HotelDescriptiveContents',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property HotelReservations can\'t be set as the property %s is already set. Only one property must be set among these properties: HotelReservations, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set HotelReservations value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\HotelReservations $hotelReservations
     * @return \StructType\HotelNotifReport
     */
    public function setHotelReservations(\StructType\HotelReservations $hotelReservations = null)
    {
        // validation for constraint: choice(HotelReservations, AvailStatusMessages, RateAmountMessages, HotelDescriptiveContents)
        if ('' !== ($hotelReservationsChoiceErrorMessage = self::validateHotelReservationsForChoiceConstraintsFromSetHotelReservations($hotelReservations))) {
            throw new \InvalidArgumentException($hotelReservationsChoiceErrorMessage, __LINE__);
        }
        if (is_null($hotelReservations) || (is_array($hotelReservations) && empty($hotelReservations))) {
            unset($this->HotelReservations);
        } else {
            $this->HotelReservations = $hotelReservations;
        }
        return $this;
    }
    /**
     * Get AvailStatusMessages value
     * @return \StructType\AvailStatusMessages|null
     */
    public function getAvailStatusMessages()
    {
        return isset($this->AvailStatusMessages) ? $this->AvailStatusMessages : null;
    }
    /**
     * This method is responsible for validating the value passed to the setAvailStatusMessages method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAvailStatusMessages method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateAvailStatusMessagesForChoiceConstraintsFromSetAvailStatusMessages($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'HotelReservations',
            'RateAmountMessages',
            'HotelDescriptiveContents',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property AvailStatusMessages can\'t be set as the property %s is already set. Only one property must be set among these properties: AvailStatusMessages, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set AvailStatusMessages value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\AvailStatusMessages $availStatusMessages
     * @return \StructType\HotelNotifReport
     */
    public function setAvailStatusMessages(\StructType\AvailStatusMessages $availStatusMessages = null)
    {
        // validation for constraint: choice(HotelReservations, AvailStatusMessages, RateAmountMessages, HotelDescriptiveContents)
        if ('' !== ($availStatusMessagesChoiceErrorMessage = self::validateAvailStatusMessagesForChoiceConstraintsFromSetAvailStatusMessages($availStatusMessages))) {
            throw new \InvalidArgumentException($availStatusMessagesChoiceErrorMessage, __LINE__);
        }
        if (is_null($availStatusMessages) || (is_array($availStatusMessages) && empty($availStatusMessages))) {
            unset($this->AvailStatusMessages);
        } else {
            $this->AvailStatusMessages = $availStatusMessages;
        }
        return $this;
    }
    /**
     * Get RateAmountMessages value
     * @return \StructType\RateAmountMessages|null
     */
    public function getRateAmountMessages()
    {
        return isset($this->RateAmountMessages) ? $this->RateAmountMessages : null;
    }
    /**
     * This method is responsible for validating the value passed to the setRateAmountMessages method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRateAmountMessages method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateRateAmountMessagesForChoiceConstraintsFromSetRateAmountMessages($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'HotelReservations',
            'AvailStatusMessages',
            'HotelDescriptiveContents',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property RateAmountMessages can\'t be set as the property %s is already set. Only one property must be set among these properties: RateAmountMessages, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set RateAmountMessages value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\RateAmountMessages $rateAmountMessages
     * @return \StructType\HotelNotifReport
     */
    public function setRateAmountMessages(\StructType\RateAmountMessages $rateAmountMessages = null)
    {
        // validation for constraint: choice(HotelReservations, AvailStatusMessages, RateAmountMessages, HotelDescriptiveContents)
        if ('' !== ($rateAmountMessagesChoiceErrorMessage = self::validateRateAmountMessagesForChoiceConstraintsFromSetRateAmountMessages($rateAmountMessages))) {
            throw new \InvalidArgumentException($rateAmountMessagesChoiceErrorMessage, __LINE__);
        }
        if (is_null($rateAmountMessages) || (is_array($rateAmountMessages) && empty($rateAmountMessages))) {
            unset($this->RateAmountMessages);
        } else {
            $this->RateAmountMessages = $rateAmountMessages;
        }
        return $this;
    }
    /**
     * Get HotelDescriptiveContents value
     * @return \StructType\HotelDescriptiveContents|null
     */
    public function getHotelDescriptiveContents()
    {
        return isset($this->HotelDescriptiveContents) ? $this->HotelDescriptiveContents : null;
    }
    /**
     * This method is responsible for validating the value passed to the setHotelDescriptiveContents method
     * This method is willingly generated in order to preserve the one-line inline validation within the setHotelDescriptiveContents method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateHotelDescriptiveContentsForChoiceConstraintsFromSetHotelDescriptiveContents($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'HotelReservations',
            'AvailStatusMessages',
            'RateAmountMessages',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property HotelDescriptiveContents can\'t be set as the property %s is already set. Only one property must be set among these properties: HotelDescriptiveContents, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set HotelDescriptiveContents value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\HotelDescriptiveContents $hotelDescriptiveContents
     * @return \StructType\HotelNotifReport
     */
    public function setHotelDescriptiveContents(\StructType\HotelDescriptiveContents $hotelDescriptiveContents = null)
    {
        // validation for constraint: choice(HotelReservations, AvailStatusMessages, RateAmountMessages, HotelDescriptiveContents)
        if ('' !== ($hotelDescriptiveContentsChoiceErrorMessage = self::validateHotelDescriptiveContentsForChoiceConstraintsFromSetHotelDescriptiveContents($hotelDescriptiveContents))) {
            throw new \InvalidArgumentException($hotelDescriptiveContentsChoiceErrorMessage, __LINE__);
        }
        if (is_null($hotelDescriptiveContents) || (is_array($hotelDescriptiveContents) && empty($hotelDescriptiveContents))) {
            unset($this->HotelDescriptiveContents);
        } else {
            $this->HotelDescriptiveContents = $hotelDescriptiveContents;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\HotelNotifReport
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
