<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for HotelInfoType StructType
 * Meta information extracted from the WSDL
 * - documentation: Used to provide the opening and closing dates for the hotel. The date that the hotel opened or is going to open is provided in the start attribute. The end attribute may be used to provide a closing date in the event that the hotel
 * has closed or is going to close. | The HotelInfo class that describes general information about the hotel.
 * @subpackage Structs
 */
class HotelInfoType extends AbstractStructBase
{
    /**
     * The HotelName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\HotelName
     */
    public $HotelName;
    /**
     * The ClosedSeasons
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ClosedSeasons
     */
    public $ClosedSeasons;
    /**
     * The BlackoutDates
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\BlackoutDates
     */
    public $BlackoutDates;
    /**
     * The RelativePositions
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RelativePositions
     */
    public $RelativePositions;
    /**
     * The CategoryCodes
     * Meta information extracted from the WSDL
     * - documentation: Collection of descriptive details about a hotel.
     * - minOccurs: 0
     * @var mixed
     */
    public $CategoryCodes;
    /**
     * The Descriptions
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Descriptions
     */
    public $Descriptions;
    /**
     * The HotelInfoCodes
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\HotelInfoCodes
     */
    public $HotelInfoCodes;
    /**
     * The Position
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Position
     */
    public $Position;
    /**
     * The Services
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Services
     */
    public $Services;
    /**
     * The WeatherInfos
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\WeatherInfos
     */
    public $WeatherInfos;
    /**
     * The OwnershipManagementInfos
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\OwnershipManagementInfos
     */
    public $OwnershipManagementInfos;
    /**
     * The Languages
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Languages
     */
    public $Languages;
    /**
     * The WhenBuilt
     * Meta information extracted from the WSDL
     * - documentation: The date that the hotel facility was built, usually just the year. If a full date is used, it is recommended that the W3C date format be followed.
     * - use: optional
     * @var string
     */
    public $WhenBuilt;
    /**
     * The LastUpdated
     * Meta information extracted from the WSDL
     * - documentation: Indication as to the last time any element supported within this message was updated.
     * - use: optional
     * @var string
     */
    public $LastUpdated;
    /**
     * The AreaWeather
     * Meta information extracted from the WSDL
     * - documentation: Description of the weather typical to the hotel facility's area.
     * - use: optional
     * @var string
     */
    public $AreaWeather;
    /**
     * The InterfaceCompliance
     * Meta information extracted from the WSDL
     * - documentation: Identifies the interface being used by this hotel.
     * - use: optional
     * @var string
     */
    public $InterfaceCompliance;
    /**
     * The PMSSystem
     * Meta information extracted from the WSDL
     * - documentation: Identifies the Property Management System being used by this hotel.
     * - use: optional
     * @var string
     */
    public $PMSSystem;
    /**
     * The HotelStatus
     * Meta information extracted from the WSDL
     * - documentation: This is a description of the operating status of the Hotel. This information may support the code in HotelStatusCode.
     * - use: optional
     * @var string
     */
    public $HotelStatus;
    /**
     * The HotelStatusCode
     * Meta information extracted from the WSDL
     * - documentation: This indicates the operating status (e.g. Open, Closed, Deflagged, Pre-opening) of the hotels to be returned in the response. Refer to OpenTravel Code List HotelStatusCode.
     * - use: optional
     * @var string
     */
    public $HotelStatusCode;
    /**
     * The TaxID
     * Meta information extracted from the WSDL
     * - documentation: The tax ID code for the property.
     * - use: optional
     * @var string
     */
    public $TaxID;
    /**
     * The DaylightSavingIndicator
     * Meta information extracted from the WSDL
     * - documentation: When false, indicates the location does not observe Daylight Saving Time.
     * - use: optional
     * @var bool
     */
    public $DaylightSavingIndicator;
    /**
     * The ISO9000CertifiedInd
     * Meta information extracted from the WSDL
     * - documentation: When true, the hotel indicates they are ISO 9000 certified.
     * - use: optional
     * @var bool
     */
    public $ISO9000CertifiedInd;
    /**
     * Constructor method for HotelInfoType
     * @uses HotelInfoType::setHotelName()
     * @uses HotelInfoType::setClosedSeasons()
     * @uses HotelInfoType::setBlackoutDates()
     * @uses HotelInfoType::setRelativePositions()
     * @uses HotelInfoType::setCategoryCodes()
     * @uses HotelInfoType::setDescriptions()
     * @uses HotelInfoType::setHotelInfoCodes()
     * @uses HotelInfoType::setPosition()
     * @uses HotelInfoType::setServices()
     * @uses HotelInfoType::setWeatherInfos()
     * @uses HotelInfoType::setOwnershipManagementInfos()
     * @uses HotelInfoType::setLanguages()
     * @uses HotelInfoType::setWhenBuilt()
     * @uses HotelInfoType::setLastUpdated()
     * @uses HotelInfoType::setAreaWeather()
     * @uses HotelInfoType::setInterfaceCompliance()
     * @uses HotelInfoType::setPMSSystem()
     * @uses HotelInfoType::setHotelStatus()
     * @uses HotelInfoType::setHotelStatusCode()
     * @uses HotelInfoType::setTaxID()
     * @uses HotelInfoType::setDaylightSavingIndicator()
     * @uses HotelInfoType::setISO9000CertifiedInd()
     * @param \StructType\HotelName $hotelName
     * @param \StructType\ClosedSeasons $closedSeasons
     * @param \StructType\BlackoutDates $blackoutDates
     * @param \StructType\RelativePositions $relativePositions
     * @param mixed $categoryCodes
     * @param \StructType\Descriptions $descriptions
     * @param \StructType\HotelInfoCodes $hotelInfoCodes
     * @param \StructType\Position $position
     * @param \StructType\Services $services
     * @param \StructType\WeatherInfos $weatherInfos
     * @param \StructType\OwnershipManagementInfos $ownershipManagementInfos
     * @param \StructType\Languages $languages
     * @param string $whenBuilt
     * @param string $lastUpdated
     * @param string $areaWeather
     * @param string $interfaceCompliance
     * @param string $pMSSystem
     * @param string $hotelStatus
     * @param string $hotelStatusCode
     * @param string $taxID
     * @param bool $daylightSavingIndicator
     * @param bool $iSO9000CertifiedInd
     */
    public function __construct(\StructType\HotelName $hotelName = null, \StructType\ClosedSeasons $closedSeasons = null, \StructType\BlackoutDates $blackoutDates = null, \StructType\RelativePositions $relativePositions = null, $categoryCodes = null, \StructType\Descriptions $descriptions = null, \StructType\HotelInfoCodes $hotelInfoCodes = null, \StructType\Position $position = null, \StructType\Services $services = null, \StructType\WeatherInfos $weatherInfos = null, \StructType\OwnershipManagementInfos $ownershipManagementInfos = null, \StructType\Languages $languages = null, $whenBuilt = null, $lastUpdated = null, $areaWeather = null, $interfaceCompliance = null, $pMSSystem = null, $hotelStatus = null, $hotelStatusCode = null, $taxID = null, $daylightSavingIndicator = null, $iSO9000CertifiedInd = null)
    {
        $this
            ->setHotelName($hotelName)
            ->setClosedSeasons($closedSeasons)
            ->setBlackoutDates($blackoutDates)
            ->setRelativePositions($relativePositions)
            ->setCategoryCodes($categoryCodes)
            ->setDescriptions($descriptions)
            ->setHotelInfoCodes($hotelInfoCodes)
            ->setPosition($position)
            ->setServices($services)
            ->setWeatherInfos($weatherInfos)
            ->setOwnershipManagementInfos($ownershipManagementInfos)
            ->setLanguages($languages)
            ->setWhenBuilt($whenBuilt)
            ->setLastUpdated($lastUpdated)
            ->setAreaWeather($areaWeather)
            ->setInterfaceCompliance($interfaceCompliance)
            ->setPMSSystem($pMSSystem)
            ->setHotelStatus($hotelStatus)
            ->setHotelStatusCode($hotelStatusCode)
            ->setTaxID($taxID)
            ->setDaylightSavingIndicator($daylightSavingIndicator)
            ->setISO9000CertifiedInd($iSO9000CertifiedInd);
    }
    /**
     * Get HotelName value
     * @return \StructType\HotelName|null
     */
    public function getHotelName()
    {
        return $this->HotelName;
    }
    /**
     * Set HotelName value
     * @param \StructType\HotelName $hotelName
     * @return \StructType\HotelInfoType
     */
    public function setHotelName(\StructType\HotelName $hotelName = null)
    {
        $this->HotelName = $hotelName;
        return $this;
    }
    /**
     * Get ClosedSeasons value
     * @return \StructType\ClosedSeasons|null
     */
    public function getClosedSeasons()
    {
        return $this->ClosedSeasons;
    }
    /**
     * Set ClosedSeasons value
     * @param \StructType\ClosedSeasons $closedSeasons
     * @return \StructType\HotelInfoType
     */
    public function setClosedSeasons(\StructType\ClosedSeasons $closedSeasons = null)
    {
        $this->ClosedSeasons = $closedSeasons;
        return $this;
    }
    /**
     * Get BlackoutDates value
     * @return \StructType\BlackoutDates|null
     */
    public function getBlackoutDates()
    {
        return $this->BlackoutDates;
    }
    /**
     * Set BlackoutDates value
     * @param \StructType\BlackoutDates $blackoutDates
     * @return \StructType\HotelInfoType
     */
    public function setBlackoutDates(\StructType\BlackoutDates $blackoutDates = null)
    {
        $this->BlackoutDates = $blackoutDates;
        return $this;
    }
    /**
     * Get RelativePositions value
     * @return \StructType\RelativePositions|null
     */
    public function getRelativePositions()
    {
        return $this->RelativePositions;
    }
    /**
     * Set RelativePositions value
     * @param \StructType\RelativePositions $relativePositions
     * @return \StructType\HotelInfoType
     */
    public function setRelativePositions(\StructType\RelativePositions $relativePositions = null)
    {
        $this->RelativePositions = $relativePositions;
        return $this;
    }
    /**
     * Get CategoryCodes value
     * @return mixed|null
     */
    public function getCategoryCodes()
    {
        return $this->CategoryCodes;
    }
    /**
     * Set CategoryCodes value
     * @param mixed $categoryCodes
     * @return \StructType\HotelInfoType
     */
    public function setCategoryCodes($categoryCodes = null)
    {
        $this->CategoryCodes = $categoryCodes;
        return $this;
    }
    /**
     * Get Descriptions value
     * @return \StructType\Descriptions|null
     */
    public function getDescriptions()
    {
        return $this->Descriptions;
    }
    /**
     * Set Descriptions value
     * @param \StructType\Descriptions $descriptions
     * @return \StructType\HotelInfoType
     */
    public function setDescriptions(\StructType\Descriptions $descriptions = null)
    {
        $this->Descriptions = $descriptions;
        return $this;
    }
    /**
     * Get HotelInfoCodes value
     * @return \StructType\HotelInfoCodes|null
     */
    public function getHotelInfoCodes()
    {
        return $this->HotelInfoCodes;
    }
    /**
     * Set HotelInfoCodes value
     * @param \StructType\HotelInfoCodes $hotelInfoCodes
     * @return \StructType\HotelInfoType
     */
    public function setHotelInfoCodes(\StructType\HotelInfoCodes $hotelInfoCodes = null)
    {
        $this->HotelInfoCodes = $hotelInfoCodes;
        return $this;
    }
    /**
     * Get Position value
     * @return \StructType\Position|null
     */
    public function getPosition()
    {
        return $this->Position;
    }
    /**
     * Set Position value
     * @param \StructType\Position $position
     * @return \StructType\HotelInfoType
     */
    public function setPosition(\StructType\Position $position = null)
    {
        $this->Position = $position;
        return $this;
    }
    /**
     * Get Services value
     * @return \StructType\Services|null
     */
    public function getServices()
    {
        return $this->Services;
    }
    /**
     * Set Services value
     * @param \StructType\Services $services
     * @return \StructType\HotelInfoType
     */
    public function setServices(\StructType\Services $services = null)
    {
        $this->Services = $services;
        return $this;
    }
    /**
     * Get WeatherInfos value
     * @return \StructType\WeatherInfos|null
     */
    public function getWeatherInfos()
    {
        return $this->WeatherInfos;
    }
    /**
     * Set WeatherInfos value
     * @param \StructType\WeatherInfos $weatherInfos
     * @return \StructType\HotelInfoType
     */
    public function setWeatherInfos(\StructType\WeatherInfos $weatherInfos = null)
    {
        $this->WeatherInfos = $weatherInfos;
        return $this;
    }
    /**
     * Get OwnershipManagementInfos value
     * @return \StructType\OwnershipManagementInfos|null
     */
    public function getOwnershipManagementInfos()
    {
        return $this->OwnershipManagementInfos;
    }
    /**
     * Set OwnershipManagementInfos value
     * @param \StructType\OwnershipManagementInfos $ownershipManagementInfos
     * @return \StructType\HotelInfoType
     */
    public function setOwnershipManagementInfos(\StructType\OwnershipManagementInfos $ownershipManagementInfos = null)
    {
        $this->OwnershipManagementInfos = $ownershipManagementInfos;
        return $this;
    }
    /**
     * Get Languages value
     * @return \StructType\Languages|null
     */
    public function getLanguages()
    {
        return $this->Languages;
    }
    /**
     * Set Languages value
     * @param \StructType\Languages $languages
     * @return \StructType\HotelInfoType
     */
    public function setLanguages(\StructType\Languages $languages = null)
    {
        $this->Languages = $languages;
        return $this;
    }
    /**
     * Get WhenBuilt value
     * @return string|null
     */
    public function getWhenBuilt()
    {
        return $this->WhenBuilt;
    }
    /**
     * Set WhenBuilt value
     * @param string $whenBuilt
     * @return \StructType\HotelInfoType
     */
    public function setWhenBuilt($whenBuilt = null)
    {
        // validation for constraint: string
        if (!is_null($whenBuilt) && !is_string($whenBuilt)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($whenBuilt, true), gettype($whenBuilt)), __LINE__);
        }
        $this->WhenBuilt = $whenBuilt;
        return $this;
    }
    /**
     * Get LastUpdated value
     * @return string|null
     */
    public function getLastUpdated()
    {
        return $this->LastUpdated;
    }
    /**
     * Set LastUpdated value
     * @param string $lastUpdated
     * @return \StructType\HotelInfoType
     */
    public function setLastUpdated($lastUpdated = null)
    {
        // validation for constraint: string
        if (!is_null($lastUpdated) && !is_string($lastUpdated)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastUpdated, true), gettype($lastUpdated)), __LINE__);
        }
        $this->LastUpdated = $lastUpdated;
        return $this;
    }
    /**
     * Get AreaWeather value
     * @return string|null
     */
    public function getAreaWeather()
    {
        return $this->AreaWeather;
    }
    /**
     * Set AreaWeather value
     * @param string $areaWeather
     * @return \StructType\HotelInfoType
     */
    public function setAreaWeather($areaWeather = null)
    {
        // validation for constraint: string
        if (!is_null($areaWeather) && !is_string($areaWeather)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($areaWeather, true), gettype($areaWeather)), __LINE__);
        }
        $this->AreaWeather = $areaWeather;
        return $this;
    }
    /**
     * Get InterfaceCompliance value
     * @return string|null
     */
    public function getInterfaceCompliance()
    {
        return $this->InterfaceCompliance;
    }
    /**
     * Set InterfaceCompliance value
     * @param string $interfaceCompliance
     * @return \StructType\HotelInfoType
     */
    public function setInterfaceCompliance($interfaceCompliance = null)
    {
        // validation for constraint: string
        if (!is_null($interfaceCompliance) && !is_string($interfaceCompliance)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($interfaceCompliance, true), gettype($interfaceCompliance)), __LINE__);
        }
        $this->InterfaceCompliance = $interfaceCompliance;
        return $this;
    }
    /**
     * Get PMSSystem value
     * @return string|null
     */
    public function getPMSSystem()
    {
        return $this->PMSSystem;
    }
    /**
     * Set PMSSystem value
     * @param string $pMSSystem
     * @return \StructType\HotelInfoType
     */
    public function setPMSSystem($pMSSystem = null)
    {
        // validation for constraint: string
        if (!is_null($pMSSystem) && !is_string($pMSSystem)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pMSSystem, true), gettype($pMSSystem)), __LINE__);
        }
        $this->PMSSystem = $pMSSystem;
        return $this;
    }
    /**
     * Get HotelStatus value
     * @return string|null
     */
    public function getHotelStatus()
    {
        return $this->HotelStatus;
    }
    /**
     * Set HotelStatus value
     * @param string $hotelStatus
     * @return \StructType\HotelInfoType
     */
    public function setHotelStatus($hotelStatus = null)
    {
        // validation for constraint: string
        if (!is_null($hotelStatus) && !is_string($hotelStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hotelStatus, true), gettype($hotelStatus)), __LINE__);
        }
        $this->HotelStatus = $hotelStatus;
        return $this;
    }
    /**
     * Get HotelStatusCode value
     * @return string|null
     */
    public function getHotelStatusCode()
    {
        return $this->HotelStatusCode;
    }
    /**
     * Set HotelStatusCode value
     * @param string $hotelStatusCode
     * @return \StructType\HotelInfoType
     */
    public function setHotelStatusCode($hotelStatusCode = null)
    {
        // validation for constraint: string
        if (!is_null($hotelStatusCode) && !is_string($hotelStatusCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hotelStatusCode, true), gettype($hotelStatusCode)), __LINE__);
        }
        $this->HotelStatusCode = $hotelStatusCode;
        return $this;
    }
    /**
     * Get TaxID value
     * @return string|null
     */
    public function getTaxID()
    {
        return $this->TaxID;
    }
    /**
     * Set TaxID value
     * @param string $taxID
     * @return \StructType\HotelInfoType
     */
    public function setTaxID($taxID = null)
    {
        // validation for constraint: string
        if (!is_null($taxID) && !is_string($taxID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($taxID, true), gettype($taxID)), __LINE__);
        }
        $this->TaxID = $taxID;
        return $this;
    }
    /**
     * Get DaylightSavingIndicator value
     * @return bool|null
     */
    public function getDaylightSavingIndicator()
    {
        return $this->DaylightSavingIndicator;
    }
    /**
     * Set DaylightSavingIndicator value
     * @param bool $daylightSavingIndicator
     * @return \StructType\HotelInfoType
     */
    public function setDaylightSavingIndicator($daylightSavingIndicator = null)
    {
        // validation for constraint: boolean
        if (!is_null($daylightSavingIndicator) && !is_bool($daylightSavingIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($daylightSavingIndicator, true), gettype($daylightSavingIndicator)), __LINE__);
        }
        $this->DaylightSavingIndicator = $daylightSavingIndicator;
        return $this;
    }
    /**
     * Get ISO9000CertifiedInd value
     * @return bool|null
     */
    public function getISO9000CertifiedInd()
    {
        return $this->ISO9000CertifiedInd;
    }
    /**
     * Set ISO9000CertifiedInd value
     * @param bool $iSO9000CertifiedInd
     * @return \StructType\HotelInfoType
     */
    public function setISO9000CertifiedInd($iSO9000CertifiedInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($iSO9000CertifiedInd) && !is_bool($iSO9000CertifiedInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($iSO9000CertifiedInd, true), gettype($iSO9000CertifiedInd)), __LINE__);
        }
        $this->ISO9000CertifiedInd = $iSO9000CertifiedInd;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\HotelInfoType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
